/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.implementation.ControllerUsageState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ComponentControllerUsageState
extends CommonDevelopmentObjectState {
    private HashMap mOutgoingControllerUsages = new HashMap();
    private Reference mUsedComponentControllerRef = null;

    ComponentControllerUsageState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ComponentControllerUsageState lState = (ComponentControllerUsageState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ComponentControllerUsageState lState = (ComponentControllerUsageState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentControllerUsageState lState = (ComponentControllerUsageState)((Object)super.clone());
        lState.mOutgoingControllerUsages = new HashMap();
        Iterator it = this.mOutgoingControllerUsages.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mOutgoingControllerUsages.put(lKey, ((ControllerUsageState)((Object)this.mOutgoingControllerUsages.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mOutgoingControllerUsages.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mOutgoingControllerUsages.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mOutgoingControllerUsages.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mUsedComponentControllerRef != null) {
            if (clipboardService.isExcluded(this.mUsedComponentControllerRef)) {
                this.mUsedComponentControllerRef = null;
            } else if (innerObjectKeys.contains(this.mUsedComponentControllerRef.toReferenceString())) {
                this.mUsedComponentControllerRef = clipboardService.refactor(this.mUsedComponentControllerRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mUsedComponentControllerRef != null && this.mUsedComponentControllerRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mUsedComponentControllerRef != null) {
            this.mUsedComponentControllerRef = refactoringService.refactor(this.mUsedComponentControllerRef);
        }
    }

    void addOutgoingControllerUsage(ControllerUsageState state) {
        this.mOutgoingControllerUsages.put(state.getName().toLowerCase(), state);
    }

    int getOutgoingControllerUsageCount() {
        return this.mOutgoingControllerUsages.size();
    }

    ControllerUsageState getOutgoingControllerUsage(String name) {
        return (ControllerUsageState)((Object)this.mOutgoingControllerUsages.get(name.toLowerCase()));
    }

    Vector getOutgoingControllerUsages() {
        return new Vector(this.mOutgoingControllerUsages.values());
    }

    void removeOutgoingControllerUsage(String aggregationKey) {
        this.mOutgoingControllerUsages.remove(aggregationKey.toLowerCase());
    }

    void removeOutgoingControllerUsage(ControllerUsageState state) {
        this.mOutgoingControllerUsages.remove(state.getName().toLowerCase());
    }

    void removeAllOutgoingControllerUsages() {
        this.mOutgoingControllerUsages.clear();
    }

    Reference getUsedComponentController() {
        return this.mUsedComponentControllerRef;
    }

    void setUsedComponentController(Reference reference) {
        this.mUsedComponentControllerRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("OutgoingControllerUsages")) {
            this.addOutgoingControllerUsage((ControllerUsageState)((Object)data));
        } else if (roleName.equals("UsedComponentController")) {
            this.setUsedComponentController((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

