/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.webdynpro.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.webdynpro.enum.ViewLifespanEnum;
import com.sap.ide.metamodel.webdynpro.enum.ViewTypeEnum;
import com.sap.ide.metamodel.webdynpro.implementation.InboundPlugState;
import com.sap.ide.metamodel.webdynpro.implementation.OutboundPlugState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

abstract class AbstractViewState
extends CommonDevelopmentObjectState {
    private String mLifespan = "framework_controlled";
    private boolean mHasLifespan = false;
    private String mType = "normal";
    private boolean mHasType = false;
    private HashMap mInboundPlugs = new HashMap();
    private HashMap mOutboundPlugs = new HashMap();
    private Reference mViewControllerRef = null;

    AbstractViewState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        AbstractViewState lState = (AbstractViewState)object;
        if (!String.valueOf(this.mLifespan).equals(String.valueOf(lState.mLifespan))) {
            return false;
        }
        return String.valueOf(this.mType).equals(String.valueOf(lState.mType));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        AbstractViewState lState = (AbstractViewState)object;
        if (!String.valueOf(this.mLifespan).equals(String.valueOf(lState.mLifespan))) {
            compareContext.addPropertyDelta(sourceObject, "lifespan", (Object)ViewLifespanEnum.valueOf(lState.mLifespan));
        }
        if (!String.valueOf(this.mType).equals(String.valueOf(lState.mType))) {
            compareContext.addPropertyDelta(sourceObject, "type", (Object)ViewTypeEnum.valueOf(lState.mType));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractViewState lState = (AbstractViewState)((Object)super.clone());
        lState.mInboundPlugs = new HashMap();
        Iterator it = this.mInboundPlugs.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mInboundPlugs.put(lKey, ((InboundPlugState)((Object)this.mInboundPlugs.get(lKey))).clone());
        }
        lState.mOutboundPlugs = new HashMap();
        Iterator it2 = this.mOutboundPlugs.keySet().iterator();
        while (it2.hasNext()) {
            String lKey = (String)it2.next();
            lState.mOutboundPlugs.put(lKey, ((OutboundPlugState)((Object)this.mOutboundPlugs.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mViewControllerRef != null && !innerObjectKeys.contains(this.mViewControllerRef.toString())) {
            this.mViewControllerRef = null;
        }
        Iterator it = this.mInboundPlugs.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mOutboundPlugs.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mInboundPlugs.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mOutboundPlugs.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mInboundPlugs.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mOutboundPlugs.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mViewControllerRef != null) {
            if (clipboardService.isExcluded(this.mViewControllerRef)) {
                this.mViewControllerRef = null;
            } else if (innerObjectKeys.contains(this.mViewControllerRef.toReferenceString())) {
                this.mViewControllerRef = clipboardService.refactor(this.mViewControllerRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        return this.mViewControllerRef != null && this.mViewControllerRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mViewControllerRef != null) {
            this.mViewControllerRef = refactoringService.refactor(this.mViewControllerRef);
        }
    }

    void setLifespan(String value) {
        this.mLifespan = value;
        this.mHasLifespan = true;
    }

    String getLifespan() {
        return this.mLifespan;
    }

    boolean hasLifespan() {
        return this.mHasLifespan;
    }

    void setType(String value) {
        this.mType = value;
        this.mHasType = true;
    }

    String getType() {
        return this.mType;
    }

    boolean hasType() {
        return this.mHasType;
    }

    void addInboundPlug(InboundPlugState state) {
        this.mInboundPlugs.put(state.getName().toLowerCase(), state);
    }

    int getInboundPlugCount() {
        return this.mInboundPlugs.size();
    }

    InboundPlugState getInboundPlug(String name) {
        return (InboundPlugState)((Object)this.mInboundPlugs.get(name.toLowerCase()));
    }

    Vector getInboundPlugs() {
        return new Vector(this.mInboundPlugs.values());
    }

    void removeInboundPlug(String aggregationKey) {
        this.mInboundPlugs.remove(aggregationKey.toLowerCase());
    }

    void removeInboundPlug(InboundPlugState state) {
        this.mInboundPlugs.remove(state.getName().toLowerCase());
    }

    void removeAllInboundPlugs() {
        this.mInboundPlugs.clear();
    }

    void addOutboundPlug(OutboundPlugState state) {
        this.mOutboundPlugs.put(state.getName().toLowerCase(), state);
    }

    int getOutboundPlugCount() {
        return this.mOutboundPlugs.size();
    }

    OutboundPlugState getOutboundPlug(String name) {
        return (OutboundPlugState)((Object)this.mOutboundPlugs.get(name.toLowerCase()));
    }

    Vector getOutboundPlugs() {
        return new Vector(this.mOutboundPlugs.values());
    }

    void removeOutboundPlug(String aggregationKey) {
        this.mOutboundPlugs.remove(aggregationKey.toLowerCase());
    }

    void removeOutboundPlug(OutboundPlugState state) {
        this.mOutboundPlugs.remove(state.getName().toLowerCase());
    }

    void removeAllOutboundPlugs() {
        this.mOutboundPlugs.clear();
    }

    Reference getViewController() {
        return this.mViewControllerRef;
    }

    void setViewController(Reference reference) {
        this.mViewControllerRef = reference;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("lifespan")) {
            if (ViewLifespanEnum.valueOf((String)value) != null) {
                this.setLifespan((String)value);
            }
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("type")) {
            if (ViewTypeEnum.valueOf((String)value) != null) {
                this.setType((String)value);
            }
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("InboundPlugs")) {
            this.addInboundPlug((InboundPlugState)((Object)data));
        } else if (roleName.equals("OutboundPlugs")) {
            this.addOutboundPlug((OutboundPlugState)((Object)data));
        } else if (roleName.equals("ViewController")) {
            this.setViewController((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

