/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.window;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.window.WindowWizardData;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WindowWizardPage
extends WizardPage {
    private final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGENAME = mTPool.getText(303);
    private String PAGETITLE = mTPool.getText(303);
    private String DESCRIPTION = mTPool.getText(201);
    private final String WINDOW = this.mCPool.getText(113);
    private final String WINDOW_NAME = mTPool.getText(404);
    private final String WINDOW_PACKAGE = mTPool.getText(421);
    private final String SOURCE_FOLDER = this.mCPool.getText(207);
    private final String BROWSE = this.mCPool.getText(208);
    private WindowWizardData mWindowWizardData = null;
    private Component mComponent = null;
    private Metamodel mMetamodel = null;
    private Text mNameField = null;
    private Text mPackageField = null;
    private Button mBrowsePackageButton = null;
    private List mSourcePathList = null;
    private boolean mFixedWindowName = false;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public WindowWizardPage(WindowWizardData data, Component component) {
        super(PAGENAME);
        this.setTitle(this.PAGETITLE);
        this.setDescription(this.DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_WINDOW_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mWindowWizardData = data;
        this.mComponent = component;
        this.mMetamodel = this.mComponent.getRoot().getMetamodel();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        wizardPane.addTextLabel(this.WINDOW_NAME);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mNameField.setEditable(!this.mFixedWindowName);
        GridData windowGridData = new GridData(1808);
        windowGridData.widthHint = 270;
        this.mNameField.setLayoutData((Object)windowGridData);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(this.WINDOW_PACKAGE);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mPackageField = wizardPane.addTextField(this.mWindowWizardData.getWindowPackageName(), false, gridLayoutData);
        GridData packageGridData = new GridData(1808);
        packageGridData.widthHint = 270;
        this.mPackageField.setLayoutData((Object)packageGridData);
        this.mBrowsePackageButton = wizardPane.addPushButton(this.BROWSE);
        wizardPane.addTextLabel(this.SOURCE_FOLDER);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.mWindowWizardData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mWindowWizardData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 40;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.setSelection(preselectionIndex);
        this.mNameField.setText(this.mWindowWizardData.getWindowName());
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mPackageField.addModifyListener((ModifyListener)new PackageModifyListener());
        this.mBrowsePackageButton.addSelectionListener((SelectionListener)new BrowsePackageButtonListener());
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        if (this.mWindowWizardData.getWindowName().length() == 0 || this.mWindowWizardData.getWindowPackageName().length() == 0) {
            this.setPageComplete(false);
        } else if (this.isValidNameField() && this.isValidPackageField()) {
            this.handlePageCompletion();
        } else {
            this.setPageComplete(false);
        }
    }

    public void handlePageCompletion() {
        this.setErrorMessage(null);
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
        }
        this.setPageComplete(true);
        this.mWindowWizardData.setWindowName(this.mNameField.getText());
        this.mWindowWizardData.setWindowPackageName(this.mPackageField.getText());
        this.mWindowWizardData.setSelectedRoot(this.mWindowWizardData.getTemporaryRoot());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String nameInput = this.mNameField.getText();
        String packageInput = this.mPackageField.getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.mNameField);
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, this.WINDOW));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(this.mCPool.getText(17, (Object)nameInput));
            return false;
        }
        if (this.mComponent.hasWindow(packageInput, nameInput)) {
            this.setErrorMessage(mTPool.getText(5, nameInput, this.mComponent.getName()));
            return false;
        }
        String intViewCtrlName = NamingService.getInterfaceViewName((String)nameInput);
        boolean controllerExists = ControllerService.doesAnyControllerExist((Component)this.mComponent, (String)intViewCtrlName);
        if (controllerExists) {
            this.setErrorMessage(this.mCPool.getText(41, (Object)intViewCtrlName));
            return false;
        }
        IStatus status = ServicesCreation.isValidWindowCreationPath(this.mComponent.getMetamodel(), nameInput, packageInput, this.mWindowWizardData.getTemporarySourcePathIdentifier());
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.mPackageField);
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    public void setFixedWindowName(boolean value) {
        this.mFixedWindowName = value;
    }

    public boolean isFixedWindowName() {
        return this.mFixedWindowName;
    }

    private boolean isValidSourcePathField() {
        return this.mSourcePathList.getItemCount() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mNameField.setFocus();
        }
    }

    class BrowsePackageButtonListener
    extends SelectionAdapter {
        BrowsePackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot sourceRoot = WindowWizardPage.this.mWindowWizardData.getTemporaryRoot();
            String packageName = WindowWizardPage.this.mWindowWizardData.getWindowPackageName();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            if ((packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)WindowWizardPage.this.getShell())) != null) {
                WindowWizardPage.this.mPackageField.setText(packageFragment.getElementName());
            }
            if (WindowWizardPage.this.isValidPackageField() && WindowWizardPage.this.isValidNameField() && WindowWizardPage.this.mSourcePathList.getItemCount() > 0) {
                WindowWizardPage.this.handlePageCompletion();
            } else {
                WindowWizardPage.this.setPageComplete(false);
            }
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = WindowWizardPage.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = WindowWizardPage.this.mWindowWizardData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                WindowWizardPage.this.mWindowWizardData.setTemporaryRoot(selectedRoot);
                if (WindowWizardPage.this.isValidSourcePathField() && WindowWizardPage.this.isValidNameField() && WindowWizardPage.this.isValidPackageField()) {
                    WindowWizardPage.this.handlePageCompletion();
                } else {
                    WindowWizardPage.this.setPageComplete(false);
                }
            }
        }
    }

    class PackageModifyListener
    implements ModifyListener {
        PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WindowWizardPage.this.isValidPackageField() && WindowWizardPage.this.isValidNameField() && WindowWizardPage.this.mSourcePathList.getItemCount() > 0) {
                WindowWizardPage.this.handlePageCompletion();
            } else {
                WindowWizardPage.this.setPageComplete(false);
            }
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WindowWizardPage.this.isValidNameField() && WindowWizardPage.this.isValidPackageField() && WindowWizardPage.this.mSourcePathList.getItemCount() > 0) {
                WindowWizardPage.this.handlePageCompletion();
            } else {
                WindowWizardPage.this.setPageComplete(false);
            }
        }
    }
}

