/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.window;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.webdynpro.service.applicationmodeler.ServiceApplicationModelerPlugin;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.window.WindowWizardData;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.window.WindowWizardPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class WindowWizard
extends Wizard
implements INewWizard {
    private final TextPool mTPool = TextPool.getInstance();
    private final String WINDOWWIZARD = this.mTPool.getText(503);
    private Component mComponent = null;
    private Window mWindow = null;
    private WindowWizardData mWindowWizardData = null;
    private WindowWizardPage mWindowWizardPage = null;
    private boolean mFixedWindowName = false;

    public WindowWizard(Component component) {
        this.mComponent = component;
        this.mWindowWizardData = new WindowWizardData(component);
        this.setWindowTitle(this.mTPool.getText(303));
    }

    public boolean performFinish() {
        try {
            if (this.mComponent == null) {
                ServiceApplicationModelerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", "Wizard cannot be finished due to method invocation error.", null, false);
                return false;
            }
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            IPackageFragmentRoot packageFragmentRoot = this.mWindowWizardData.getSelectedRoot();
            MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mComponent.getRoot().getMetamodel().getName());
            IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
            SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
            String packageName = this.mWindowWizardData.getWindowPackageName();
            String name = this.mWindowWizardData.getWindowName();
            IStatus status = ServicesCreation.isValidWindowCreationPath(this.mComponent.getMetamodel(), name, packageName, identifier);
            if (status.getSeverity() == 4) {
                page.setErrorMessage(status.getMessage());
                return false;
            }
            String error = ServicesCreation.checkWindowOnFileSystem(name, packageName, this.mComponent.getRoot().getMetamodel());
            if (error != null) {
                page.setErrorMessage(error);
                return false;
            }
            this.mWindow = ServicesCreation.createWindow(this.mComponent, packageName, name, identifier);
            if (this.mWindow != null) {
                return true;
            }
            ServiceApplicationModelerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", "Wizard cannot be finished due to window creation error.", null, false);
            return false;
        }
        catch (Throwable e) {
            ServiceApplicationModelerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish", "Exception occured", e, false);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mWindowWizardPage = new WindowWizardPage(this.mWindowWizardData, this.mComponent);
        this.mWindowWizardPage.setFixedWindowName(this.mFixedWindowName);
        this.addPage((IWizardPage)this.mWindowWizardPage);
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public void setFixedWindowName(String fixedWindowName) {
        this.mFixedWindowName = true;
        this.mWindowWizardData.setWindowName(fixedWindowName);
    }

    public void setPackageName(String packageName) {
        this.mWindowWizardData.setWindowPackageName(packageName);
    }
}

