/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.viewusage;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesVSH;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.viewusage.ViewUsageWizardData;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.viewdesigner.ServicesCreation;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ViewUsageWizardPage2
extends WizardPage {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGENAME = mTPool.getText(306);
    private String TITLE = PAGENAME;
    private String DESCRIPTION = mTPool.getText(206);
    private final String VIEW = mCPool.getText(104);
    private final String VIEW_NAME = mTPool.getText(406);
    private final String VIEW_PACKAGE = mTPool.getText(422);
    private final String SOURCE_FOLDER = mCPool.getText(207);
    private final String BROWSE = mCPool.getText(208);
    private DevelopmentObject mObject = null;
    private ViewUsageWizardData mViewUsageWizardData = null;
    private Text mViewNameField = null;
    private Text mViewPackageField = null;
    private Button mBrowsePackageButton = null;
    private List mSourcePathList = null;
    private String mComponentPackageName = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public ViewUsageWizardPage2(ViewUsageWizardData data, DevelopmentObject object) {
        super(PAGENAME);
        this.setTitle(this.TITLE);
        this.setDescription(this.DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_VIEW_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mViewUsageWizardData = data;
        this.mObject = object;
        this.mComponentPackageName = ServicesVSH.getItsComponent(this.mObject).getPackage();
        this.mViewUsageWizardData.setViewPackage(this.mComponentPackageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        wizardPane.addTextLabel(this.VIEW_NAME);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mViewNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mViewNameField.addModifyListener((ModifyListener)new ViewNameModifyListener());
        GridData viewGridData = new GridData(1808);
        viewGridData.widthHint = 270;
        this.mViewNameField.setLayoutData((Object)viewGridData);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(this.VIEW_PACKAGE);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mViewPackageField = wizardPane.addTextField(this.mViewUsageWizardData.getViewPackage(), false, gridLayoutData);
        this.mViewPackageField.addModifyListener((ModifyListener)new ViewPackageModifyListener());
        GridData packageGridData = new GridData(1808);
        packageGridData.widthHint = 270;
        this.mViewPackageField.setLayoutData((Object)packageGridData);
        this.mBrowsePackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mBrowsePackageButton.addSelectionListener((SelectionListener)new BrowsePackageButtonListener());
        wizardPane.addTextLabel(this.SOURCE_FOLDER);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.mViewUsageWizardData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mViewUsageWizardData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 40;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        this.mSourcePathList.setSelection(preselectionIndex);
        wizardPane.addPlaceholder();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public IWizardPage getPreviousPage() {
        if (this.isPageComplete()) {
            this.setPageComplete(false);
        }
        this.mViewUsageWizardData.setShouldFinish(false);
        return this.mViewUsageWizardData.getPage1();
    }

    public void resetFields() {
        if (this.mViewNameField.getText().length() > 0) {
            this.mViewNameField.setText("");
            this.mViewUsageWizardData.setViewName("");
        }
        this.mViewPackageField.setText(ServicesVSH.getItsComponent(this.mObject).getPackage());
        this.mViewUsageWizardData.setViewPackage(ServicesVSH.getItsComponent(this.mObject).getPackage());
        this.setErrorMessage(null);
    }

    public void handlePageCompletion() {
        this.setErrorMessage(null);
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
        }
        this.mViewUsageWizardData.setShouldFinish(true);
        this.setPageComplete(true);
        this.mViewUsageWizardData.setShouldCreateView();
        this.mViewUsageWizardData.setViewName(this.mViewNameField.getText());
        this.mViewUsageWizardData.setViewPackage(this.mViewPackageField.getText());
        this.mViewUsageWizardData.setSelectedRoot(this.mViewUsageWizardData.getTemporaryRoot());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        Component component = ServicesVSH.getItsComponent(this.mObject);
        String nameInput = this.mViewNameField.getText();
        String packageInput = this.mViewPackageField.getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.mViewNameField);
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, this.VIEW));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        if (component.hasView(packageInput, nameInput)) {
            this.setErrorMessage(mTPool.getText(13, nameInput, packageInput));
            return false;
        }
        String viewControllerName = NamingService.getViewControllerName((String)nameInput);
        boolean controllerExists = ControllerService.doesAnyControllerExist((Component)component, (String)viewControllerName);
        if (controllerExists) {
            this.setErrorMessage(mCPool.getText(41, (Object)nameInput));
            return false;
        }
        IStatus status = ServicesCreation.isValidViewCreationPath((Metamodel)component.getMetamodel(), (String)nameInput, (String)packageInput, (SourcePathIdentifier)this.mViewUsageWizardData.getTemporarySourcePathIdentifier());
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.mViewPackageField);
        IStatus validatedStatus = CheckServices.isValidPackage((String)this.mViewPackageField.getText());
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidSourcePathField() {
        return this.mSourcePathList.getItemCount() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mViewNameField.setFocus();
        }
    }

    class BrowsePackageButtonListener
    extends SelectionAdapter {
        BrowsePackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot sourceRoot = ViewUsageWizardPage2.this.mViewUsageWizardData.getTemporaryRoot();
            String packageName = ViewUsageWizardPage2.this.mViewUsageWizardData.getViewPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            if ((packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)ViewUsageWizardPage2.this.getShell())) != null) {
                ViewUsageWizardPage2.this.mViewPackageField.setText(packageFragment.getElementName());
            }
            if (ViewUsageWizardPage2.this.isValidPackageField() && ViewUsageWizardPage2.this.isValidNameField() && ViewUsageWizardPage2.this.mSourcePathList.getItemCount() > 0) {
                ViewUsageWizardPage2.this.handlePageCompletion();
            } else {
                ViewUsageWizardPage2.this.setPageComplete(false);
            }
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = ViewUsageWizardPage2.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = ViewUsageWizardPage2.this.mViewUsageWizardData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                ViewUsageWizardPage2.this.mViewUsageWizardData.setTemporaryRoot(selectedRoot);
                if (ViewUsageWizardPage2.this.isValidSourcePathField() && ViewUsageWizardPage2.this.isValidNameField() && ViewUsageWizardPage2.this.isValidPackageField()) {
                    ViewUsageWizardPage2.this.handlePageCompletion();
                } else {
                    ViewUsageWizardPage2.this.setPageComplete(false);
                }
            }
        }
    }

    class ViewPackageModifyListener
    implements ModifyListener {
        ViewPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ViewUsageWizardPage2.this.isValidPackageField() && ViewUsageWizardPage2.this.isValidNameField() && ViewUsageWizardPage2.this.mSourcePathList.getItemCount() > 0) {
                ViewUsageWizardPage2.this.handlePageCompletion();
            } else {
                ViewUsageWizardPage2.this.setPageComplete(false);
            }
        }
    }

    class ViewNameModifyListener
    implements ModifyListener {
        ViewNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ViewUsageWizardPage2.this.isValidNameField() && ViewUsageWizardPage2.this.isValidPackageField() && ViewUsageWizardPage2.this.mSourcePathList.getItemCount() > 0) {
                ViewUsageWizardPage2.this.handlePageCompletion();
            } else {
                ViewUsageWizardPage2.this.setPageComplete(false);
            }
        }
    }
}

