/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.viewset;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.viewset.Placeholder;
import com.sap.ide.metamodel.webdynpro.framework.viewsetdefinition.ViewsetDefinition;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesVSH;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.viewset.ViewsetWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ViewsetWizardPage
extends WizardPage {
    private final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGENAME = mTPool.getText(302);
    private final String PAGETITLE = mTPool.getText(302);
    private final String DESCRIPTION = mTPool.getText(200);
    private final String VIEWSET = this.mCPool.getText(105);
    private final String SAMPLE = mTPool.getText(453);
    private final String GRID_LAYOUT = this.mCPool.getText(304);
    private final String TAB_LAYOUT = this.mCPool.getText(305);
    private final String T_LAYOUT = this.mCPool.getText(306);
    private final String T90_LAYOUT = this.mCPool.getText(307);
    private final String T180_LAYOUT = this.mCPool.getText(308);
    private final String T270_LAYOUT = this.mCPool.getText(309);
    private ViewsetWizardData mViewsetWizardData = null;
    private DevelopmentObject mObject = null;
    private Combo mViewsetDefinitionCombo = null;
    private Text mNameField = null;
    private static Image mGridLayoutImage;
    private static Image mTabImage;
    private static Image mTImage;
    private static Image mT90Image;
    private static Image mT180Image;
    private static Image mT270Image;
    private static Color WHITE;
    private Canvas imageCanvas = null;

    public ViewsetWizardPage(ViewsetWizardData data, DevelopmentObject object) {
        super(PAGENAME);
        this.setTitle(this.PAGETITLE);
        this.setDescription(this.DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_VIEWSET_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mViewsetWizardData = data;
        this.mObject = object;
        this.setPageComplete(false);
        mGridLayoutImage = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.IMG_GRID_LAYOUT);
        mTabImage = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.IMG_TAB_LAYOUT);
        mTImage = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.IMG_T_LAYOUT);
        mT90Image = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.IMG_T90_LAYOUT);
        mT180Image = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.IMG_T180_LAYOUT);
        mT270Image = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.IMG_T270_LAYOUT);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)2);
        wizardPane.addTextLabel(TextPool.getInstance().getText(402));
        this.mNameField = wizardPane.addTextField("", false, wizardPane.createGridLayoutData(4, 2, true, false));
        GridData viewsetGridData = new GridData(1808);
        viewsetGridData.widthHint = 200;
        this.mNameField.setLayoutData((Object)viewsetGridData);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        wizardPane.addTextLabel(TextPool.getInstance().getText(440));
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        String preselection = "";
        if (this.mViewsetWizardData.getViewsetDefinitionNames().length > 0) {
            preselection = this.mViewsetWizardData.getViewsetDefinitionNames()[0];
        } else {
            this.setErrorMessage(mTPool.getText(39));
            preselection = "";
        }
        this.mViewsetDefinitionCombo = wizardPane.addComboBox(this.mViewsetWizardData.getViewsetDefinitionNames(), preselection, true, gridLayoutData);
        GridData viewsetDefGridData = new GridData(1808);
        viewsetDefGridData.widthHint = 200;
        this.mViewsetDefinitionCombo.setLayoutData((Object)viewsetDefGridData);
        this.mViewsetDefinitionCombo.addSelectionListener((SelectionListener)new ViewsetDefinitionSelectionListener());
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addHorizontalSeparator();
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addTextLabel(this.SAMPLE);
        ISimplePane picturePane = wizardPane.addSimplePane(wizardPane.createGridLayoutData(4, 4, false, false, 1, 3));
        Composite pictureComposite = picturePane.getComposite();
        GridLayout pictureLayout = new GridLayout();
        pictureComposite.setLayout((Layout)pictureLayout);
        this.imageCanvas = new Canvas(pictureComposite, 0);
        GridLayout canvasLayout = new GridLayout();
        this.imageCanvas.setLayout((Layout)canvasLayout);
        this.imageCanvas.setBackground(WHITE);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 100;
        gridData.heightHint = 80;
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                String[] definitions = ViewsetWizardPage.this.mViewsetWizardData.getViewsetDefinitionNames();
                ViewsetDefinition definition = ViewsetWizardPage.this.mViewsetWizardData.getSelectedViewsetDefinition();
                if (definition == null) {
                    return;
                }
                String name = definition.getName();
                if (name.equals(ViewsetWizardPage.this.GRID_LAYOUT)) {
                    event.gc.drawImage(mGridLayoutImage, 10, 0);
                } else if (name.equals(ViewsetWizardPage.this.TAB_LAYOUT)) {
                    event.gc.drawImage(mTabImage, 10, 0);
                } else if (name.equals(ViewsetWizardPage.this.T_LAYOUT)) {
                    event.gc.drawImage(mTImage, 10, 0);
                } else if (name.equals(ViewsetWizardPage.this.T90_LAYOUT)) {
                    event.gc.drawImage(mT90Image, 10, 0);
                } else if (name.equals(ViewsetWizardPage.this.T180_LAYOUT)) {
                    event.gc.drawImage(mT180Image, 10, 0);
                } else if (name.equals(ViewsetWizardPage.this.T270_LAYOUT)) {
                    event.gc.drawImage(mT270Image, 10, 0);
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mNameField.setFocus();
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ViewsetWizardPage.this.mNameField.getText().length() > 0) {
                if (CheckServices.isValidIdentifier((String)ViewsetWizardPage.this.mNameField.getText())) {
                    Window window = null;
                    if (ViewsetWizardPage.this.mObject instanceof Placeholder) {
                        window = ServicesVSH.getWindow((DevelopmentObject)((Placeholder)ViewsetWizardPage.this.mObject));
                    } else if (ViewsetWizardPage.this.mObject instanceof Window) {
                        window = (Window)ViewsetWizardPage.this.mObject;
                    }
                    if (window != null) {
                        if (ServicesVSH.hasViewset(window, ViewsetWizardPage.this.mNameField.getText())) {
                            ViewsetWizardPage.this.setPageComplete(false);
                            ViewsetWizardPage.this.setErrorMessage(TextPool.getInstance().getText(4, ViewsetWizardPage.this.mNameField.getText(), window.getName()));
                        } else {
                            ViewsetWizardPage.this.setErrorMessage(null);
                            if (!ViewsetWizardPage.this.mViewsetDefinitionCombo.getText().equals("")) {
                                ViewsetWizardPage.this.setPageComplete(true);
                                ViewsetWizardPage.this.mViewsetWizardData.setViewsetName(ViewsetWizardPage.this.mNameField.getText());
                            }
                        }
                    }
                } else {
                    ViewsetWizardPage.this.setPageComplete(false);
                    ViewsetWizardPage.this.setErrorMessage(CoreTextPool.getInstance().getText(2, (Object)ViewsetWizardPage.this.mNameField.getText()));
                }
            } else {
                ViewsetWizardPage.this.setPageComplete(false);
                ViewsetWizardPage.this.setErrorMessage(TextPool.getInstance().getText(1, ViewsetWizardPage.this.VIEWSET));
            }
        }
    }

    class ViewsetDefinitionSelectionListener
    implements SelectionListener {
        ViewsetDefinitionSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ViewsetWizardPage.this.mViewsetWizardData.setSelectedViewsetDefinitionIndex(ViewsetWizardPage.this.mViewsetDefinitionCombo.getSelectionIndex());
            ViewsetWizardPage.this.imageCanvas.redraw();
        }
    }
}

