/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.viewcontainer;

import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.viewcontainer.ViewContainerWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.viewdesigner.ServicesCreation;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ViewContainerWizardPage
extends WizardPage {
    private final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGENAME = mTPool.getText(315);
    private String PAGETITLE = mTPool.getText(315);
    private String DESCRIPTION = mTPool.getText(222);
    private final String VIEWCONTAINER_NAME = mTPool.getText(410);
    private ViewContainerWizardData mViewContainerWizardData = null;
    private Text mNameField = null;

    public ViewContainerWizardPage(ViewContainerWizardData data) {
        super(PAGENAME);
        this.setTitle(this.PAGETITLE);
        this.setDescription(this.DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_VIEW_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mViewContainerWizardData = data;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        wizardPane.addTextLabel(this.VIEWCONTAINER_NAME);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 270;
        this.mNameField.setLayoutData((Object)gridData);
    }

    public void handlePageCompletion() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
        this.mViewContainerWizardData.setViewContainerName(this.mNameField.getText());
    }

    private boolean isValidNameField() {
        String nameInput = this.mNameField.getText();
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, CoreTextPool.getInstance().getText(140)));
            return false;
        }
        if (!CheckServices.isValidIdentifier((String)nameInput)) {
            this.setErrorMessage(this.mCPool.getText(2, (Object)nameInput));
            return false;
        }
        boolean isOK = ServicesCreation.isNameAvailableForElement((String)nameInput, (View)this.mViewContainerWizardData.getParentView());
        if (!isOK) {
            this.setErrorMessage(this.mCPool.getText(49, (Object)nameInput));
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mNameField.setFocus();
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ViewContainerWizardPage.this.isValidNameField()) {
                ViewContainerWizardPage.this.handlePageCompletion();
            } else {
                ViewContainerWizardPage.this.setPageComplete(false);
            }
        }
    }
}

