/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.refactor.window;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.refactoring.MDORefactoringTask;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.NavigationLinks;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.webdynpro.generation.eclipse.deletion.DeletionService;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.ServiceApplicationModelerPlugin;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.controllereditor.implementation.AmbiguousImportsException;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameContentProvider;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;

public class RenameWindowWizard
extends RenameWizard {
    private static final TextPool mTPool = TextPool.getInstance();
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private Window mOldWindow = null;
    private boolean mClosedSuccessfully = false;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard;

    public RenameWindowWizard(Window window) {
        super((DevelopmentObject)window);
        this.mOldWindow = window;
    }

    public RenameWindowWizard(Window window, String newName, String newPackage) {
        super((DevelopmentObject)window, newName, newPackage);
        this.mOldWindow = window;
    }

    protected IStatus doSpecialRefactoringPreparation(RefactoringRequest request, DevelopmentObject developmentObject, String newName, String newPackage, SourcePathIdentifier identifier) {
        String pluginID = ServiceApplicationModelerPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        if (developmentObject instanceof Window) {
            try {
                Window window = (Window)developmentObject;
                NavigationLinks links = window.getNavigationLinks();
                MDORefactoringTask linkTask = (MDORefactoringTask)request.createRefactoringTask((DevelopmentObject)links);
                linkTask.setNewSourcePathIdentifier(identifier);
                linkTask.setNewName(newName);
                linkTask.setNewPackage(newPackage);
                InterfaceView interfaceView = window.getInterfaceView();
                String oldIntViewName = interfaceView.getName();
                int nameLength = developmentObject.getName().length();
                String IntViewPostfix = oldIntViewName.substring(nameLength);
                String newIntViewName = newName + IntViewPostfix;
                MDORefactoringTask interfaceViewTask = (MDORefactoringTask)request.createRefactoringTask((DevelopmentObject)interfaceView);
                interfaceViewTask.setNewSourcePathIdentifier(identifier);
                interfaceViewTask.setNewName(newIntViewName);
                interfaceViewTask.setNewPackage(newPackage);
                Controller intViewController = interfaceView.getViewController();
                MDORefactoringTask intViewControllerTask = (MDORefactoringTask)request.createRefactoringTask((DevelopmentObject)intViewController);
                intViewControllerTask.setNewSourcePathIdentifier(identifier);
                intViewControllerTask.setNewName(newIntViewName);
                intViewControllerTask.setNewPackage(newPackage);
            }
            catch (RuntimeException e) {
                ServiceApplicationModelerPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard == null ? (class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard = RenameWindowWizard.class$("com.sap.ide.webdynpro.service.applicationmodeler.wizards.refactor.window.RenameWindowWizard")) : class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard, "DoSpecialRefactoringPreparation", "RubtimeException ocurred", e, true);
                return new Status(4, pluginID, 4, mCPool.getText(36), (Throwable)e);
            }
        }
        return new Status(0, pluginID, 0, "", null);
    }

    protected String verifyDevelopmentobjectName(String nameInput, String packageInput) {
        RenameWizardData mRenameWizardData = this.getWizardData();
        Window window = null;
        Component parentComponent = null;
        DevelopmentObject developmentObject = mRenameWizardData.getObjectToRefactor();
        if (!(developmentObject instanceof Window)) {
            return "wrong type";
        }
        window = (Window)developmentObject;
        parentComponent = window.getComponent();
        if (parentComponent == null) {
            return "Parent not found";
        }
        if (!parentComponent.hasWindow(packageInput, nameInput)) {
            boolean windowExists = parentComponent.getRoot().getMetamodel().objectExists(packageInput, nameInput, WebDynproMDOEnum.WINDOW);
            if (windowExists) {
                return mTPool.getText(6, nameInput, packageInput);
            }
            String intViewCtrlName = NamingService.getInterfaceViewName((String)nameInput);
            boolean controllerExists = ControllerService.doesAnyControllerExist((Component)parentComponent, (String)intViewCtrlName);
            if (!controllerExists) {
                IStatus status = ServicesCreation.isValidWindowCreationPath(mRenameWizardData.getObjectToRefactor().getMetamodel(), nameInput, packageInput, mRenameWizardData.getTemporarySourcePathIdentifier());
                if (status.getSeverity() == 0) {
                    return null;
                }
                return status.getMessage();
            }
            return mCPool.getText(41, (Object)intViewCtrlName);
        }
        return mTPool.getText(5, nameInput, parentComponent.getName());
    }

    protected IStructuredContentProvider getContentProvider() {
        return new RenameContentProvider();
    }

    protected void deleteImplementation(DevelopmentObject developmentObject) {
        if (developmentObject instanceof Window) {
            Controller controller = ((Window)developmentObject).getInterfaceView().getViewController();
            DeletionService deletionService = new DeletionService(this.getWizardData().getEclipseProject());
            deletionService.deleteController(controller, true);
        }
    }

    protected void generateImplementation(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        if (developmentObject instanceof Window) {
            Controller controller = ((Window)developmentObject).getInterfaceView().getViewController();
            ControllerService.createControllerImplementation((Controller)controller, (ProgressMonitorDialog)dialog);
        }
    }

    protected void organizeImports(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        Controller controller;
        if (developmentObject instanceof Window && (controller = ((Window)developmentObject).getInterfaceView().getViewController()).getCodeBody() != null) {
            dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(214));
            ImplementationService implService = new ImplementationService(controller);
            this.doOrganizeImports(implService, dialog.getProgressMonitor());
        }
    }

    private void doOrganizeImports(ImplementationService implService, IProgressMonitor monitor) {
        try {
            implService.organizeImports(true, monitor);
        }
        catch (AmbiguousImportsException ambiguousImportsException) {
            // empty catch block
        }
    }

    protected IStatus doAdditionalTasksBeforeRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        String PLUGIN_ID = ServiceApplicationModelerPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(215));
        if (!(developmentObject instanceof Window)) {
            return new Status(4, PLUGIN_ID, -1, "Wrong type in RenameWindowWizard", null);
        }
        Window window = (Window)developmentObject;
        this.mClosedSuccessfully = CreationWithUI.closeNavigationModeler(window);
        if (this.mClosedSuccessfully) {
            return new Status(0, PLUGIN_ID, 0, "Closed successfully", null);
        }
        ServiceApplicationModelerPlugin.internalWarning(class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard == null ? (class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard = RenameWindowWizard.class$("com.sap.ide.webdynpro.service.applicationmodeler.wizards.refactor.window.RenameWindowWizard")) : class$com$sap$ide$webdynpro$service$applicationmodeler$wizards$refactor$window$RenameWindowWizard, "doAdditionalTasksBeforeRefactoring", "NavigationModeler couldn't be closed, because it wasn't open, or due to an unknown error", null);
        return new Status(0, PLUGIN_ID, 0, "Navigation Modeler not closed", null);
    }

    protected void doAdditionalTasksInMidOfRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        ServicesDeletion.deleteDiagram((MainDevelopmentObject)this.mOldWindow);
    }

    protected void doAdditionalTasksAfterRefactoring(DevelopmentObject developmentObject, ProgressMonitorDialog dialog) {
        if (!(developmentObject instanceof Window)) {
            return;
        }
        Window window = (Window)developmentObject;
        if (this.mClosedSuccessfully) {
            dialog.getProgressMonitor().setTaskName(CoreTextPool.getInstance().getText(216));
            CreationWithUI.openNavigationModeler(window);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

