/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.componentinterfacedefinition;

import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.componentinterfacedefinition.CreateComponentInterfaceDefinitionWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ComponentInterfaceDefinitionWizardPage
extends WizardPage {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGENAME = mTPool.getText(310);
    private String TITLE = PAGENAME;
    private String DESCRIPTION = mTPool.getText(214);
    private final String CID = mCPool.getText(130);
    private final String NAME = mTPool.getText(400);
    private final String PACKAGE = mTPool.getText(420);
    private final String SOURCE_FOLDER = mCPool.getText(207);
    private final String BROWSE = mCPool.getText(208);
    private CreateComponentInterfaceDefinitionWizardData mCreateComponentInterfaceDefinitionWizardData = null;
    private WebDynproRoot mWebDynproRoot = null;
    private Text mNameField = null;
    private Text mPackageField = null;
    private Button mBrowsePackageButton = null;
    private List mSourcePathList = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public ComponentInterfaceDefinitionWizardPage(CreateComponentInterfaceDefinitionWizardData data, WebDynproRoot webDynproRoot) {
        super(PAGENAME);
        this.setTitle(this.TITLE);
        this.setDescription(this.DESCRIPTION);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_COMPONENT_INTERFACE_DEFINITION_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mCreateComponentInterfaceDefinitionWizardData = data;
        this.mWebDynproRoot = webDynproRoot;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        wizardPane.addTextLabel(this.NAME);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        GridData viewGridData = new GridData(1808);
        viewGridData.widthHint = 270;
        this.mNameField.setLayoutData((Object)viewGridData);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(this.PACKAGE);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mPackageField = wizardPane.addTextField(this.mCreateComponentInterfaceDefinitionWizardData.getPackage(), false, gridLayoutData);
        this.mPackageField.addModifyListener((ModifyListener)new PackageModifyListener());
        GridData packageGridData = new GridData(1808);
        packageGridData.widthHint = 270;
        this.mPackageField.setLayoutData((Object)packageGridData);
        this.mBrowsePackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mBrowsePackageButton.addSelectionListener((SelectionListener)new BrowsePackageButtonListener());
        wizardPane.addTextLabel(this.SOURCE_FOLDER);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.mCreateComponentInterfaceDefinitionWizardData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mCreateComponentInterfaceDefinitionWizardData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 40;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        this.mSourcePathList.setSelection(preselectionIndex);
    }

    public void handlePageCompletion() {
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.mCreateComponentInterfaceDefinitionWizardData.setName(this.mNameField.getText());
        this.mCreateComponentInterfaceDefinitionWizardData.setPackage(this.mPackageField.getText());
        this.mCreateComponentInterfaceDefinitionWizardData.setSelectedRoot(this.mCreateComponentInterfaceDefinitionWizardData.getTemporaryRoot());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String nameInput = this.mNameField.getText();
        String packageInput = this.mPackageField.getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.mNameField);
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, this.CID));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        if (this.mWebDynproRoot.hasComponentInterfaceDefinition(packageInput, nameInput)) {
            this.setErrorMessage(mTPool.getText(34, nameInput));
            return false;
        }
        IStatus status = ServicesCreation.isValidCIDCreationPath(this.mWebDynproRoot.getMetamodel(), nameInput, packageInput, this.mCreateComponentInterfaceDefinitionWizardData.getTemporarySourcePathIdentifier());
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.mPackageField);
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidSourcePathField() {
        return this.mSourcePathList.getItemCount() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mNameField.setFocus();
        }
    }

    class BrowsePackageButtonListener
    extends SelectionAdapter {
        BrowsePackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot sourceRoot = ComponentInterfaceDefinitionWizardPage.this.mCreateComponentInterfaceDefinitionWizardData.getTemporaryRoot();
            String packageName = ComponentInterfaceDefinitionWizardPage.this.mCreateComponentInterfaceDefinitionWizardData.getPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            if ((packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)ComponentInterfaceDefinitionWizardPage.this.getShell())) != null) {
                ComponentInterfaceDefinitionWizardPage.this.mPackageField.setText(packageFragment.getElementName());
            }
            if (ComponentInterfaceDefinitionWizardPage.this.isValidPackageField() && ComponentInterfaceDefinitionWizardPage.this.isValidNameField() && ComponentInterfaceDefinitionWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ComponentInterfaceDefinitionWizardPage.this.handlePageCompletion();
            } else {
                ComponentInterfaceDefinitionWizardPage.this.setPageComplete(false);
            }
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = ComponentInterfaceDefinitionWizardPage.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = ComponentInterfaceDefinitionWizardPage.this.mCreateComponentInterfaceDefinitionWizardData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                ComponentInterfaceDefinitionWizardPage.this.mCreateComponentInterfaceDefinitionWizardData.setTemporaryRoot(selectedRoot);
                if (ComponentInterfaceDefinitionWizardPage.this.isValidSourcePathField() && ComponentInterfaceDefinitionWizardPage.this.isValidNameField() && ComponentInterfaceDefinitionWizardPage.this.isValidPackageField()) {
                    ComponentInterfaceDefinitionWizardPage.this.handlePageCompletion();
                } else {
                    ComponentInterfaceDefinitionWizardPage.this.setPageComplete(false);
                }
            }
        }
    }

    class PackageModifyListener
    implements ModifyListener {
        PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ComponentInterfaceDefinitionWizardPage.this.isValidPackageField() && ComponentInterfaceDefinitionWizardPage.this.isValidNameField() && ComponentInterfaceDefinitionWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ComponentInterfaceDefinitionWizardPage.this.handlePageCompletion();
            } else {
                ComponentInterfaceDefinitionWizardPage.this.setPageComplete(false);
            }
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ComponentInterfaceDefinitionWizardPage.this.isValidNameField() && ComponentInterfaceDefinitionWizardPage.this.isValidPackageField() && ComponentInterfaceDefinitionWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ComponentInterfaceDefinitionWizardPage.this.handlePageCompletion();
            } else {
                ComponentInterfaceDefinitionWizardPage.this.setPageComplete(false);
            }
        }
    }
}

