/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.component;

import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.service.applicationmodeler.ServiceApplicationModelerPlugin;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.component.ComponentWizardData;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ComponentWizardPage
extends WizardPage {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private final String COMPONENT = mCPool.getText(111);
    private final String COMPONENT_NAME = mTPool.getText(409);
    private final String COMPONENT_PACKAGE = mTPool.getText(411);
    private final String WINDOW = mCPool.getText(113);
    private final String WINDOW_NAME = mTPool.getText(404);
    private final String WINDOW_PACKAGE = mTPool.getText(421);
    private final String SOURCE_FOLDER = mCPool.getText(207);
    private final String BROWSE = mCPool.getText(208);
    private final String PACKAGE_SELECTION = mCPool.getText(209);
    private final String CHOOSE = mCPool.getText(210);
    private final String NO_PACKAGES = mCPool.getText(211);
    private final String VIEW_NAME = com.sap.ide.webdynpro.service.viewdesigner.TextPool.getInstance().getText(403);
    private final String VIEW_PACKAGE = com.sap.ide.webdynpro.service.viewdesigner.TextPool.getInstance().getText(404);
    private static final String pageName = mTPool.getText(312);
    private String pageTitle = pageName;
    private String pageDescription = mTPool.getText(216);
    private ComponentWizardData mComponentWizardData = null;
    private WebDynproRoot mWebDynproRoot = null;
    private Text mComponentNameField = null;
    private Text mComponentPackageField = null;
    private Text mWindowNameField = null;
    private Text mWindowPackageField = null;
    private Text mViewNameField = null;
    private Text mViewPackageField = null;
    private Button mBrowseComponentPackageButton = null;
    private Button mBrowseWindowPackageButton = null;
    private Button mBrowseViewPackageButton = null;
    private List mSourcePathList = null;
    private Button mCreateViewButton = null;
    private boolean mDeleteComponentNameMessage = true;
    private boolean mDeleteComponentPackageMessage = true;
    private boolean mDeleteWindowNameMessage = true;
    private boolean mDeleteWindowPackageMessage = true;
    private boolean mDeleteViewNameMessage = true;
    private boolean mDeleteViewPackageMessage = true;

    public ComponentWizardPage(ComponentWizardData data, WebDynproRoot webDynproRoot) {
        super(pageName);
        this.setTitle(this.pageTitle);
        this.setDescription(this.pageDescription);
        ImageDescriptor imageDescriptor = SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_COMPONENT_BANNER);
        this.setImageDescriptor(imageDescriptor);
        this.mComponentWizardData = data;
        this.mWebDynproRoot = webDynproRoot;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        wizardPane.addTextLabel(mTPool.getText(409));
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mComponentNameField = wizardPane.addTextField(this.mComponentWizardData.getComponentName(), false, gridLayoutData);
        this.mComponentNameField.addModifyListener((ModifyListener)new ComponentNameModifyListener());
        GridData componentGridData = new GridData(1808);
        componentGridData.widthHint = 270;
        this.mComponentNameField.setLayoutData((Object)componentGridData);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(this.COMPONENT_PACKAGE);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mComponentPackageField = wizardPane.addTextField(this.mComponentWizardData.getComponentPackage(), false, gridLayoutData);
        this.mComponentPackageField.addModifyListener((ModifyListener)new ComponentPackageModifyListener());
        GridData packageGridData = new GridData(1808);
        packageGridData.widthHint = 270;
        this.mComponentPackageField.setLayoutData((Object)packageGridData);
        this.mBrowseComponentPackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mBrowseComponentPackageButton.addSelectionListener((SelectionListener)new BrowseComponentPackageButtonListener());
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addHorizontalSeparator();
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addTextLabel(this.SOURCE_FOLDER);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.mComponentWizardData.getAllValidRoots();
        String[] items = new String[roots.length];
        IPackageFragmentRoot selectedRoot = this.mComponentWizardData.getSelectedRoot();
        int preselectionIndex = 0;
        int i = 0;
        while (i < roots.length) {
            items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            if (roots[i].equals(selectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 20;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.addSelectionListener((SelectionListener)new SourceSelectionListener());
        this.mSourcePathList.setSelection(0);
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addHorizontalSeparator();
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addTextLabel(mTPool.getText(404));
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mWindowNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mWindowNameField.addModifyListener((ModifyListener)new WindowNameModifyListener());
        GridData windowGridData = new GridData(1808);
        windowGridData.widthHint = 270;
        this.mWindowNameField.setLayoutData((Object)windowGridData);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(mTPool.getText(421));
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mWindowPackageField = wizardPane.addTextField(this.mComponentWizardData.getWindowPackage(), false, gridLayoutData);
        this.mWindowPackageField.addModifyListener((ModifyListener)new WindowPackageModifyListener());
        GridData windowPackageGridData = new GridData(1808);
        windowPackageGridData.widthHint = 270;
        this.mWindowPackageField.setLayoutData((Object)windowPackageGridData);
        this.mBrowseWindowPackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mBrowseWindowPackageButton.addSelectionListener((SelectionListener)new BrowseWindowPackageButtonListener());
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addHorizontalSeparator();
        wizardPane.addPlaceholder(100, 3);
        gridLayoutData = wizardPane.createGridLayoutData(4, 2, 2, 1);
        this.mCreateViewButton = wizardPane.addCheckBox(mTPool.getText(446), true, gridLayoutData);
        this.mCreateViewButton.addSelectionListener((SelectionListener)new CreateViewButtonSelectionListener());
        wizardPane.addPlaceholder();
        wizardPane.addPlaceholder(100, 3);
        wizardPane.addTextLabel(this.VIEW_NAME);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mViewNameField = wizardPane.addTextField("", false, gridLayoutData);
        this.mViewNameField.addModifyListener((ModifyListener)new ViewNameModifyListener());
        GridData viewGridData = new GridData(1808);
        viewGridData.widthHint = 270;
        this.mViewNameField.setLayoutData((Object)viewGridData);
        wizardPane.addPlaceholder();
        wizardPane.addTextLabel(this.VIEW_PACKAGE);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mViewPackageField = wizardPane.addTextField("", false, gridLayoutData);
        this.mViewPackageField.addModifyListener((ModifyListener)new ViewPackageModifyListener());
        GridData viewPackageGridData = new GridData(1808);
        viewPackageGridData.widthHint = 270;
        this.mViewPackageField.setLayoutData((Object)viewPackageGridData);
        this.mBrowseViewPackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mBrowseViewPackageButton.addSelectionListener((SelectionListener)new BrowseViewPackageButtonListener());
    }

    public void updateUi() {
        this.mComponentNameField.setText(this.mComponentWizardData.getComponentName());
        this.mComponentPackageField.setText(this.mComponentWizardData.getComponentPackage());
        this.mWindowNameField.setText(this.mComponentWizardData.getWindowName());
        this.mWindowPackageField.setText(this.mComponentWizardData.getWindowPackage());
        this.mViewNameField.setText(this.mComponentWizardData.getViewName());
        this.mViewPackageField.setText(this.mComponentWizardData.getViewPackage());
    }

    public void handlePageCompletion() {
        this.setErrorMessage(null);
        this.setPageComplete(true);
        if (this.mDeleteComponentNameMessage && this.mDeleteWindowNameMessage && this.mDeleteViewNameMessage && this.mDeleteComponentPackageMessage && this.mDeleteWindowPackageMessage && this.mDeleteViewPackageMessage) {
            this.setMessage(null);
        }
        this.mComponentWizardData.setComponentName(this.mComponentNameField.getText());
        this.mComponentWizardData.setComponentPackage(this.mComponentPackageField.getText());
        this.mComponentWizardData.setWindowName(this.mWindowNameField.getText());
        this.mComponentWizardData.setWindowPackage(this.mWindowPackageField.getText());
        this.mComponentWizardData.setSelectedRoot(this.mComponentWizardData.getTemporaryRoot());
        this.mComponentWizardData.setViewName(this.mViewNameField.getText());
        this.mComponentWizardData.setViewPackage(this.mViewPackageField.getText());
    }

    private boolean isValidComponentNameField() {
        this.mDeleteComponentNameMessage = true;
        String nameInput = this.mComponentNameField.getText();
        String packageInput = this.mComponentPackageField.getText();
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, this.COMPONENT));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteComponentNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        nameInput = CheckServices.checkFirstCharacter((Text)this.mComponentNameField);
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        if (this.mWebDynproRoot.hasComponent(packageInput, nameInput)) {
            this.setErrorMessage(TextPool.getInstance().getText(37, nameInput, packageInput));
            return false;
        }
        IStatus componentStatus = ServicesCreation.isValidComponentCreationPath(this.mWebDynproRoot.getMetamodel(), nameInput, packageInput, this.mComponentWizardData.getTemporarySourcePathIdentifier());
        if (componentStatus.getSeverity() == 4) {
            this.setErrorMessage(componentStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean modelExistsInPackage(String packageName) {
        Model[] models = null;
        try {
            models = this.mWebDynproRoot.getModels();
        }
        catch (LoadException e) {
            ServiceApplicationModelerPlugin.internalError(((Object)((Object)this)).getClass(), "modelsExistInPackage", "Exception occured", e, false);
            return false;
        }
        int i = 0;
        while (i < models.length) {
            if (models[i].getPackage().equals(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidComponentPackageField() {
        this.mDeleteComponentPackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.mComponentPackageField);
        if (this.modelExistsInPackage(packageInput)) {
            this.setErrorMessage("The package contains a Model.");
            return false;
        }
        IStatus validatedStatus = CheckServices.isValidPackage((String)this.mComponentPackageField.getText());
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeleteComponentPackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidWindowNameField() {
        this.mDeleteWindowNameMessage = true;
        String nameInput = this.mWindowNameField.getText();
        String packageInput = this.mWindowPackageField.getText();
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, this.WINDOW));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteWindowNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        nameInput = CheckServices.checkFirstCharacter((Text)this.mWindowNameField);
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        IStatus windowStatus = ServicesCreation.isValidWindowCreationPath(this.mWebDynproRoot.getMetamodel(), nameInput, packageInput, this.mComponentWizardData.getTemporarySourcePathIdentifier());
        if (windowStatus.getSeverity() == 4) {
            this.setErrorMessage(windowStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidWindowPackageField() {
        this.mDeleteWindowPackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.mWindowPackageField);
        if (this.modelExistsInPackage(packageInput)) {
            this.setErrorMessage("The package contains a Model.");
            return false;
        }
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeleteWindowPackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidViewNameField() {
        this.mDeleteViewNameMessage = true;
        String nameInput = this.mViewNameField.getText();
        String packageInput = this.mViewPackageField.getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.mViewNameField);
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mTPool.getText(1, mCPool.getText(104)));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteViewNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        IStatus windowStatus = ServicesCreation.isValidWindowCreationPath(this.mWebDynproRoot.getMetamodel(), nameInput, packageInput, this.mComponentWizardData.getTemporarySourcePathIdentifier());
        if (windowStatus.getSeverity() == 4) {
            this.setErrorMessage(windowStatus.getMessage());
            return false;
        }
        if (nameInput.equals(this.mComponentNameField.getText())) {
            this.setErrorMessage(mCPool.getText(48));
            return false;
        }
        return true;
    }

    private boolean isValidViewPackageField() {
        this.mDeleteViewPackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.mViewPackageField);
        if (this.modelExistsInPackage(packageInput)) {
            this.setErrorMessage("The package contains a Model.");
            return false;
        }
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeleteViewPackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidSourcePathField() {
        return this.mSourcePathList.getItemCount() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mComponentNameField.setFocus();
        }
    }

    class CreateViewButtonSelectionListener
    implements SelectionListener {
        CreateViewButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (!button.getSelection()) {
                ComponentWizardPage.this.mViewNameField.setEnabled(false);
                ComponentWizardPage.this.mViewPackageField.setEnabled(false);
                ComponentWizardPage.this.mBrowseViewPackageButton.setEnabled(false);
                ComponentWizardPage.this.mComponentWizardData.setIsCreateEmptyComponentSelected(true);
            } else {
                ComponentWizardPage.this.mViewNameField.setEnabled(true);
                ComponentWizardPage.this.mViewPackageField.setEnabled(true);
                ComponentWizardPage.this.mBrowseViewPackageButton.setEnabled(true);
                ComponentWizardPage.this.mComponentWizardData.setIsCreateEmptyComponentSelected(false);
            }
        }
    }

    class BrowseViewPackageButtonListener
    extends SelectionAdapter {
        BrowseViewPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragmentRoot sourceRoot = ComponentWizardPage.this.mComponentWizardData.getTemporaryRoot();
            String viewPackageName = ComponentWizardPage.this.mComponentWizardData.getViewPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)viewPackageName, (IPackageFragmentRoot)sourceRoot);
            }
            IPackageFragment packageFragment = null;
            if (sourceRoot != null) {
                packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)ComponentWizardPage.this.getShell());
            }
            if (packageFragment != null) {
                ComponentWizardPage.this.mViewPackageField.setText(packageFragment.getElementName());
            }
            if (ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class BrowseWindowPackageButtonListener
    extends SelectionAdapter {
        BrowseWindowPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragmentRoot sourceRoot = ComponentWizardPage.this.mComponentWizardData.getTemporaryRoot();
            String windowPackageName = ComponentWizardPage.this.mComponentWizardData.getWindowPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)windowPackageName, (IPackageFragmentRoot)sourceRoot);
            }
            IPackageFragment packageFragment = null;
            if (sourceRoot != null) {
                packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)ComponentWizardPage.this.getShell());
            }
            if (packageFragment != null) {
                ComponentWizardPage.this.mWindowPackageField.setText(packageFragment.getElementName());
            }
            if (ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0 && ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidViewPackageField()) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class BrowseComponentPackageButtonListener
    extends SelectionAdapter {
        BrowseComponentPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragmentRoot sourceRoot = ComponentWizardPage.this.mComponentWizardData.getTemporaryRoot();
            String packageName = ComponentWizardPage.this.mComponentWizardData.getComponentPackage();
            IPackageFragment preselectedPackage = null;
            if (sourceRoot != null) {
                preselectedPackage = ServicesEclipse.getPackageInSourceRoot((String)packageName, (IPackageFragmentRoot)sourceRoot);
            }
            IPackageFragment packageFragment = null;
            if (sourceRoot != null) {
                packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)sourceRoot, (IPackageFragment)preselectedPackage, (Shell)ComponentWizardPage.this.getShell());
            }
            if (packageFragment != null) {
                ComponentWizardPage.this.mComponentPackageField.setText(packageFragment.getElementName());
            }
            if (ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0 && ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidViewPackageField()) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = ComponentWizardPage.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot[] allRoots = ComponentWizardPage.this.mComponentWizardData.getAllValidRoots();
                IPackageFragmentRoot selectedRoot = allRoots[selectionIndex];
                ComponentWizardPage.this.mComponentWizardData.setTemporaryRoot(selectedRoot);
                if (ComponentWizardPage.this.isValidSourcePathField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidViewPackageField()) {
                    ComponentWizardPage.this.handlePageCompletion();
                } else {
                    ComponentWizardPage.this.setPageComplete(false);
                }
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class ViewPackageModifyListener
    implements ModifyListener {
        ViewPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class ViewNameModifyListener
    implements ModifyListener {
        ViewNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class WindowPackageModifyListener
    implements ModifyListener {
        WindowPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0 && ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidViewNameField()) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class WindowNameModifyListener
    implements ModifyListener {
        WindowNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0 && ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidViewNameField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField()) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class ComponentPackageModifyListener
    implements ModifyListener {
        ComponentPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ComponentWizardPage.this.mWindowPackageField.setText(ComponentWizardPage.this.mComponentPackageField.getText());
            ComponentWizardPage.this.mViewPackageField.setText(ComponentWizardPage.this.mComponentPackageField.getText());
            if (ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0 && ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidViewNameField()) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }

    class ComponentNameModifyListener
    implements ModifyListener {
        ComponentNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ComponentWizardPage.this.mWindowNameField.setText(ComponentWizardPage.this.mComponentNameField.getText());
            ComponentWizardPage.this.mViewNameField.setText(ComponentWizardPage.this.mComponentNameField.getText() + "View");
            if (ComponentWizardPage.this.isValidComponentNameField() && ComponentWizardPage.this.isValidComponentPackageField() && ComponentWizardPage.this.isValidWindowPackageField() && ComponentWizardPage.this.isValidWindowNameField() && ComponentWizardPage.this.mSourcePathList.getItemCount() > 0 && ComponentWizardPage.this.isValidViewPackageField() && ComponentWizardPage.this.isValidViewNameField()) {
                ComponentWizardPage.this.handlePageCompletion();
            } else {
                ComponentWizardPage.this.setPageComplete(false);
            }
        }
    }
}

