/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.component;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.services.GenerationPathManager;
import com.sap.ide.webdynpro.service.applicationmodeler.ServiceApplicationModelerPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ComponentWizardData {
    private WebDynproRoot mWebDynproRoot = null;
    private String mComponentName = "";
    private String mComponentPackage = "";
    private String mWindowName = "";
    private String mWindowPackage = "";
    private String mViewName = "";
    private String mViewPackage = "";
    private IPackageFragmentRoot[] mAllValidRoots = null;
    private IPackageFragmentRoot mSelectedRoot = null;
    private SourcePathIdentifier mSelectedSourcePathId = null;
    private IPackageFragmentRoot mTemporaryRoot = null;
    private SourcePathIdentifier mTemporarySourcePathId = null;
    private boolean mIsCreateEmptyComponentSelected = false;

    public ComponentWizardData(WebDynproRoot webDynproRoot) {
        this.mWebDynproRoot = webDynproRoot;
        this.initializeData();
    }

    private void initializeData() {
        String sourceText = "";
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = this.mWebDynproRoot.getMetamodel().getName();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        IPackageFragmentRoot[] allValidRoots = GenerationPathManager.getValidSourceRoots((IProject)eclipseProject);
        this.setAllValidRoots(allValidRoots);
        if (allValidRoots.length > 0) {
            this.setSelectedRoot(allValidRoots[0]);
            this.setTemporaryRoot(allValidRoots[0]);
        } else {
            ServiceApplicationModelerPlugin.internalError(this.getClass(), "initiaizeData()", "The project '" + eclipseProject.getName() + "' has no source folder. Please add a source folder or choose 'Use Project as source folder' in your project properties.", null, false);
        }
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String name) {
        this.mComponentName = name;
    }

    public String getComponentPackage() {
        return this.mComponentPackage;
    }

    public void setComponentPackage(String componentPackage) {
        this.mComponentPackage = componentPackage.toLowerCase();
    }

    public String getWindowName() {
        return this.mWindowName;
    }

    public void setWindowName(String name) {
        this.mWindowName = name;
    }

    public String getWindowPackage() {
        return this.mWindowPackage;
    }

    public void setWindowPackage(String windowPackage) {
        this.mWindowPackage = windowPackage.toLowerCase();
    }

    public void setAllValidRoots(IPackageFragmentRoot[] allValidRoots) {
        this.mAllValidRoots = allValidRoots;
    }

    public IPackageFragmentRoot[] getAllValidRoots() {
        return this.mAllValidRoots;
    }

    public void setSelectedRoot(IPackageFragmentRoot selectedRoot) {
        this.mSelectedRoot = selectedRoot;
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mWebDynproRoot.getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(this.mSelectedRoot.getPath());
        this.mSelectedSourcePathId = manager.getSourcePathIdentifier(sourcePath);
    }

    public IPackageFragmentRoot getSelectedRoot() {
        return this.mSelectedRoot;
    }

    public SourcePathIdentifier getSelectedSourcePathIdentifier() {
        return this.mSelectedSourcePathId;
    }

    public void setTemporaryRoot(IPackageFragmentRoot temporaryRoot) {
        this.mTemporaryRoot = temporaryRoot;
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mWebDynproRoot.getMetamodel().getName());
        IPath sourcePath = manager.makePathAbsolute(this.mTemporaryRoot.getPath());
        this.mTemporarySourcePathId = manager.getSourcePathIdentifier(sourcePath);
    }

    public IPackageFragmentRoot getTemporaryRoot() {
        return this.mTemporaryRoot;
    }

    public SourcePathIdentifier getTemporarySourcePathIdentifier() {
        return this.mTemporarySourcePathId;
    }

    protected void setIsCreateEmptyComponentSelected(boolean isCreateEmptyComponentSelected) {
        this.mIsCreateEmptyComponentSelected = isCreateEmptyComponentSelected;
    }

    public boolean isCreateEmptyComponentSelected() {
        return this.mIsCreateEmptyComponentSelected;
    }

    public void setViewPackage(String viewPackage) {
        this.mViewPackage = viewPackage.toLowerCase();
    }

    public String getViewPackage() {
        return this.mViewPackage;
    }

    public void setViewName(String viewName) {
        this.mViewName = viewName;
    }

    public String getViewName() {
        return this.mViewName;
    }
}

