/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.wizards.component;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.webdynpro.service.applicationmodeler.ServiceApplicationModelerPlugin;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.component.ComponentWizardData;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.component.ComponentWizardPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ComponentWizard
extends Wizard
implements INewWizard {
    private final TextPool mTPool = TextPool.getInstance();
    private final String COMPONENTWIZARD = this.mTPool.getText(507);
    private WebDynproRoot mWebDynproRoot = null;
    private Component mComponent = null;
    private Window mDefaultWindow = null;
    private ComponentWizardData mComponentWizardData = null;
    private ComponentWizardPage mComponentWizardPage = null;

    public ComponentWizard(WebDynproRoot webDynproRoot) {
        this.mWebDynproRoot = webDynproRoot;
        this.mComponentWizardData = new ComponentWizardData(webDynproRoot);
        this.setWindowTitle(this.mTPool.getText(312));
    }

    public ComponentWizardData getComponentWizardData() {
        return this.mComponentWizardData;
    }

    public void updateUi() {
        this.mComponentWizardPage.updateUi();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        try {
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            String componentPackage = this.mComponentWizardData.getComponentPackage();
            String componentName = this.mComponentWizardData.getComponentName();
            String windowPackage = this.mComponentWizardData.getWindowPackage();
            String windowName = this.mComponentWizardData.getWindowName();
            IPackageFragmentRoot packageFragmentRoot = this.mComponentWizardData.getSelectedRoot();
            MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mWebDynproRoot.getMetamodel().getName());
            IPath sourcePath = manager.makePathAbsolute(packageFragmentRoot.getPath());
            SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
            IStatus componentStatus = ServicesCreation.isValidComponentCreationPath(this.mWebDynproRoot.getMetamodel(), componentName, componentPackage, identifier);
            IStatus windowStatus = ServicesCreation.isValidWindowCreationPath(this.mWebDynproRoot.getMetamodel(), windowName, windowPackage, identifier);
            if (componentStatus.getSeverity() == 4 || windowStatus.getSeverity() == 4) {
                page.setErrorMessage(componentStatus.getMessage());
                return false;
            }
            String componentError = ServicesCreation.checkComponentOnFileSystem(componentName, componentPackage, this.mWebDynproRoot.getMetamodel());
            if (componentError != null) {
                page.setErrorMessage(componentError);
                return false;
            }
            String windowError = ServicesCreation.checkWindowOnFileSystem(windowName, windowPackage, this.mWebDynproRoot.getMetamodel());
            if (windowError != null) {
                page.setErrorMessage(windowError);
                return false;
            }
            if (this.mComponentWizardData.isCreateEmptyComponentSelected()) {
                this.mComponent = ServicesCreation.createComponent(this.mWebDynproRoot, componentPackage, componentName, windowPackage, windowName, identifier);
            } else {
                String viewPackage = this.mComponentWizardData.getViewPackage();
                String viewName = this.mComponentWizardData.getViewName();
                this.mComponent = ServicesCreation.createHelloWorldComponent(this.mWebDynproRoot, componentPackage, componentName, windowPackage, windowName, viewPackage, viewName, identifier);
            }
            if (this.mComponent != null) {
                return true;
            }
            ServiceApplicationModelerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish", "Wizard cannot be finished due to Component creation error.", null, false);
            return false;
        }
        catch (Throwable e) {
            ServiceApplicationModelerPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish", "Exception occured", e, false);
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mComponentWizardPage = new ComponentWizardPage(this.mComponentWizardData, this.mWebDynproRoot);
        this.addPage((IWizardPage)this.mComponentWizardPage);
    }

    public Component getComponent() {
        return this.mComponent;
    }
}

