/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.paste;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.dialogs.CopyWindowDialog;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class WindowPasteHandler
extends WebDynproObjectPasteHandler {
    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof Component) {
            return new MainDevelopmentObject[]{(Component)newParent};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects != null && clipboardObjects.length == 3 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.WINDOW && clipboardObjects[1].getType() == WebDynproDevelopmentObjectEnum.INTERFACEVIEW && clipboardObjects[2].getType() == WebDynproDevelopmentObjectEnum.CONTROLLER) {
            ClipboardObject windowObject = clipboardObjects[0];
            ClipboardObject ifViewObject = clipboardObjects[1];
            ClipboardObject ifViewControllerObject = clipboardObjects[2];
            Component component = null;
            if (newParent instanceof Component) {
                component = (Component)newParent;
            } else if (newParent instanceof WebDynproRoot) {
                DevelopmentObject originalObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(windowObject.getParent().getOriginalKey());
                if (originalObject == null) {
                    throw new OriginalObjectNotExistingException(windowObject);
                }
                component = (Component)originalObject;
            } else {
                return false;
            }
            String newName = null;
            String newPackage = null;
            IPackageFragmentRoot newRoot = null;
            String windowName = windowObject.getNewName();
            if (component.getName().equals(windowName) && windowObject.getParent() != null) {
                windowName = windowObject.getParent().getNewName();
            }
            String windowPackage = this.getPreselectedPackage(windowObject, newParent);
            SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
            IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
            IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
            ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
            CopyWindowDialog dialog = CreationWithUI.displayCopyWindowDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), windowName, windowPackage, clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent));
            if (dialog == null) {
                return false;
            }
            newName = dialog.getName();
            newPackage = dialog.getPackage();
            newRoot = dialog.getSourceRoot();
            windowName = newName;
            windowPackage = newPackage;
            windowObject.setNewName(windowName);
            windowObject.setNewPackage(windowPackage);
            newName = NamingService.getInterfaceViewName((String)windowName);
            ifViewObject.setNewName(newName);
            ifViewObject.setNewPackage(windowPackage);
            newName = NamingService.getInterfaceViewControllerName((String)ifViewObject.getNewName());
            newPackage = ifViewObject.getNewPackage();
            ifViewControllerObject.setNewName(newName);
            ifViewControllerObject.setNewPackage(newPackage);
            this.storeMapping(ifViewControllerObject, newName, newPackage, newRoot, pasteManager);
            ClipboardObject[] children = windowObject.getChildren();
            int i = 0;
            while (i < children.length) {
                ClipboardObject child = children[i];
                if (child.getType() == WebDynproDevelopmentObjectEnum.NAVIGATIONLINKS) {
                    child.setNewName(windowName);
                    child.setNewPackage(windowPackage);
                }
                ++i;
            }
            if (dialog.getSourceRoot() != null) {
                this.setPasteProcessSourcePathIdentifier(pasteManager, dialog.getSourceRoot(), newParent);
            }
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            IPasteHandler handler = pasteManager.getPasteHandler(ifViewObject);
            if (handler != null) {
                boolean cancelled;
                boolean bl = cancelled = !handler.refactorBeforeExecution(new ClipboardObject[]{ifViewObject, ifViewControllerObject}, newParent, scope, pasteManager);
                if (cancelled) {
                    return false;
                }
            }
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        IPasteHandler handler;
        if (newObjects != null && newObjects.length == 3 && newObjects[0] instanceof Window && newObjects[1] instanceof InterfaceView && newObjects[2] instanceof Controller && (handler = pasteManager.getPasteHandler(newObjects[1])) != null) {
            handler.refactorAfterExecution(new DevelopmentObject[]{newObjects[1], newObjects[2]}, newParent, scope, pasteManager);
        }
    }
}

