/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.paste;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.dialogs.CopyComponentDialog;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteManager;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandler;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ComponentPasteHandler
extends WebDynproObjectPasteHandler {
    private boolean mAreUsagesExcluded = false;

    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        return PasteHandler.EMPTY_MDO_ARRAY;
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects != null && clipboardObjects.length == 1 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.COMPONENT) {
            ClipboardObject componentObject = clipboardObjects[0];
            SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
            IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
            IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
            ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
            String newName = null;
            String newPackage = null;
            IPackageFragmentRoot newRoot = null;
            CopyComponentDialog dialog = CreationWithUI.displayCopyComponentDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), componentObject.getNewName(), componentObject.getNewPackage(), clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent));
            if (dialog == null) {
                return false;
            }
            newName = dialog.getName();
            newPackage = dialog.getPackage();
            newRoot = dialog.getSourceRoot();
            componentObject.setNewName(newName);
            componentObject.setNewPackage(newPackage);
            ClipboardObject compControllerObject = this.getComponentControllerObject(componentObject, pasteManager.getClipboard());
            if (compControllerObject != null) {
                newName = NamingService.getComponentControllerName((String)componentObject.getNewName());
                compControllerObject.setNewName(newName);
                compControllerObject.setNewPackage(newPackage);
            }
            if (dialog.getSourceRoot() != null) {
                this.setPasteProcessSourcePathIdentifier(pasteManager, dialog.getSourceRoot(), newParent);
            }
            this.storeMapping(componentObject, newName, newPackage, newRoot, pasteManager);
            this.storeMapping(compControllerObject, newName, newPackage, newRoot, pasteManager);
            if (!this.mAreUsagesExcluded) {
                this.excludeForeignComponentUsages(newParent, scope, pasteManager);
                this.mAreUsagesExcluded = true;
            }
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            ClipboardObject[] children = componentObject.getChildren();
            int i = 0;
            while (i < children.length) {
                ClipboardObject child = children[i];
                IPasteHandler handler = pasteManager.getPasteHandler(child);
                ClipboardObject[] relevantChildren = MDOPasteManager.computeRelevantObjects((MetamodelClipboard)pasteManager.getClipboard(), (ClipboardObject[])children, (int)i);
                if (handler != null && relevantChildren != null && relevantChildren.length > 0) {
                    boolean cancelled;
                    boolean bl = cancelled = !handler.refactorBeforeExecution(relevantChildren, newParent, scope, pasteManager);
                    if (cancelled) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newObjects != null && newObjects.length == 1 && newObjects[0] instanceof Component) {
            Component component = (Component)newObjects[0];
            this.copyFolderStructure(component, pasteManager);
            Vector<Object> childObjects = new Vector<Object>();
            Controller[] controllers = component.getControllers();
            View[] views = component.getViews();
            ComponentInterfaceImplementation cii = component.getComponentInterface();
            Window[] windows = component.getWindows();
            childObjects.addAll(Arrays.asList(controllers));
            childObjects.addAll(Arrays.asList(views));
            childObjects.add(cii);
            childObjects.addAll(Arrays.asList(windows));
            DevelopmentObject[] children = childObjects.toArray(new DevelopmentObject[childObjects.size()]);
            int i = 0;
            while (i < children.length) {
                DevelopmentObject child = children[i];
                IPasteHandler handler = pasteManager.getPasteHandler(child);
                DevelopmentObject[] relevantChildren = MDOPasteManager.computeRelevantObjects((MetamodelClipboard)pasteManager.getClipboard(), (DevelopmentObject[])children, (int)i);
                if (handler != null && relevantChildren != null && relevantChildren.length > 0) {
                    handler.refactorAfterExecution(relevantChildren, newParent, scope, pasteManager);
                }
                ++i;
            }
        }
    }

    private ClipboardObject getComponentControllerObject(ClipboardObject componentObject, MetamodelClipboard clipboard) throws PasteHandlerException {
        int i = 0;
        while (i < componentObject.getChildren().length) {
            ClipboardObject child = componentObject.getChildren()[i];
            if (child.getType() == WebDynproDevelopmentObjectEnum.CONTROLLER) {
                DevelopmentObject originalObject = clipboard.getSourceMetamodel().getObjectFromKey(child.getOriginalKey());
                if (originalObject == null) {
                    throw new OriginalObjectNotExistingException(child);
                }
                Controller controller = (Controller)originalObject;
                if (controller.getType() == ControllerTypeEnum.COMPONENT) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    private void excludeForeignComponentUsages(MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (scope != 3) {
            return;
        }
        Hashtable availableUsedComponents = new Hashtable();
        Vector componentsInClipboard = new Vector();
        Vector corruptUsages = new Vector();
        ClipboardObject[] rootObjects = pasteManager.getRootObjects();
        int i = 0;
        while (i < rootObjects.length) {
            ClipboardObject object = rootObjects[i];
            availableUsedComponents.putAll(this.findOldReferencedComponents(object, pasteManager, corruptUsages));
            ++i;
        }
        int i2 = 0;
        while (i2 < rootObjects.length) {
            ClipboardObject object = rootObjects[i2];
            componentsInClipboard.addAll(this.findComponentsInClipboard(object, pasteManager));
            ++i2;
        }
        Iterator iter = availableUsedComponents.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ComponentInterface componentIf = (ComponentInterface)entry.getKey();
            ClipboardObject usageObject = (ClipboardObject)entry.getValue();
            DevelopmentObject newRefToCompIf = this.convertOldToNewReference(this.getNewMetamodel(newParent), (DevelopmentObject)componentIf);
            usageObject.setExcluded(newRefToCompIf == null && !componentsInClipboard.contains(componentIf));
        }
        Iterator iter2 = corruptUsages.iterator();
        while (iter2.hasNext()) {
            ClipboardObject usage = (ClipboardObject)iter2.next();
            usage.setExcluded(true);
        }
        if (!corruptUsages.isEmpty()) {
            this.logWarningForCorruptUsages(corruptUsages, pasteManager);
        }
    }

    private List findComponentsInClipboard(ClipboardObject object, IPasteManager pasteManager) throws PasteHandlerException {
        Vector<ComponentInterfaceImplementation> result = new Vector<ComponentInterfaceImplementation>();
        if (object.getType() == WebDynproDevelopmentObjectEnum.COMPONENT) {
            Component originalObject = (Component)pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(object.getOriginalKey());
            if (originalObject == null) {
                throw new OriginalObjectNotExistingException(object);
            }
            result.add(originalObject.getComponentInterface());
        }
        return result;
    }

    private Map findOldReferencedComponents(ClipboardObject object, IPasteManager pasteManager, List corruptUsages) throws PasteHandlerException {
        Hashtable<ComponentInterface, ClipboardObject> result = new Hashtable<ComponentInterface, ClipboardObject>();
        int i = 0;
        while (i < object.getChildren().length) {
            ClipboardObject child = object.getChildren()[i];
            if (child.getType() == WebDynproDevelopmentObjectEnum.COMPONENTUSAGE) {
                DevelopmentObject originalObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(child.getOriginalKey());
                if (originalObject == null) {
                    throw new OriginalObjectNotExistingException(child);
                }
                ComponentUsage usage = (ComponentUsage)originalObject;
                ComponentInterface usedComp = usage.getUsedComponent();
                if (usedComp != null) {
                    result.put(usedComp, child);
                } else {
                    corruptUsages.add(child);
                }
            }
            result.putAll(this.findOldReferencedComponents(child, pasteManager, corruptUsages));
            ++i;
        }
        return result;
    }

    private void logWarningForCorruptUsages(List corruptUsages, IPasteManager pasteManager) {
        StringBuffer usages = new StringBuffer();
        Iterator iter = corruptUsages.iterator();
        while (iter.hasNext()) {
            ClipboardObject usageObject = (ClipboardObject)iter.next();
            usages.append(usageObject.getNewName());
            if (!iter.hasNext()) continue;
            usages.append(", ");
        }
        TextPool textPool = TextPool.getInstance();
        pasteManager.getLog().addEntry(2, textPool.getText(40, usages), false);
    }

    private void copyFolderStructure(Component component, IPasteManager manager) {
        Component oldComponent = (Component)this.getOldMDO((MainDevelopmentObject)component, manager);
        PARService.copyComponentFilesAndFolders((Component)oldComponent, (Component)component, (IProgressMonitor)manager.getSharedMonitor());
    }
}

