/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.paste;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.dialogs.CopyComponentInterfaceDefinitionDialog;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteHandler;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ComponentInterfaceDefinitionPasteHandler
extends WebDynproObjectPasteHandler {
    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        return PasteHandler.EMPTY_MDO_ARRAY;
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects != null && clipboardObjects.length == 1 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.COMPONENTINTERFACEDEFINITION) {
            ClipboardObject cidObject = clipboardObjects[0];
            String newName = null;
            String newPackage = null;
            IPackageFragmentRoot newRoot = null;
            SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
            IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
            IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
            ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
            CopyComponentInterfaceDefinitionDialog dialog = CreationWithUI.displayCopyComponentInterfaceDefinitionDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), cidObject.getNewName(), cidObject.getNewPackage(), clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent));
            if (dialog == null) {
                return false;
            }
            newName = dialog.getName();
            newPackage = dialog.getPackage();
            newRoot = dialog.getSourceRoot();
            cidObject.setNewName(newName);
            cidObject.setNewPackage(newPackage);
            if (newRoot != null) {
                this.setPasteProcessSourcePathIdentifier(pasteManager, newRoot, newParent);
            }
            this.storeMapping(cidObject, newName, newPackage, newRoot, pasteManager);
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            ClipboardObject[] children = cidObject.getChildren();
            int i = 0;
            while (i < children.length) {
                ClipboardObject child = children[i];
                IPasteHandler handler = pasteManager.getPasteHandler(child);
                ClipboardObject[] relevantChildren = MDOPasteManager.computeRelevantObjects((MetamodelClipboard)pasteManager.getClipboard(), (ClipboardObject[])children, (int)i);
                if (handler != null && relevantChildren != null && relevantChildren.length > 0) {
                    boolean cancelled;
                    boolean bl = cancelled = !handler.refactorBeforeExecution(relevantChildren, newParent, scope, pasteManager);
                    if (cancelled) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newObjects != null && newObjects.length == 1 && newObjects[0] instanceof ComponentInterfaceDefinition) {
            ComponentInterfaceDefinition cid = (ComponentInterfaceDefinition)newObjects[0];
            this.copyFolderStructure(cid, pasteManager);
            InterfaceView[] interfaceViews = cid.getInterfaceViews();
            Controller[] controllers = cid.getControllers();
            Model[] usedModels = cid.getUsedModels();
            Vector<Object> childObjects = new Vector<Object>();
            childObjects.addAll(Arrays.asList(interfaceViews));
            childObjects.addAll(Arrays.asList(controllers));
            childObjects.addAll(Arrays.asList(usedModels));
            DevelopmentObject[] children = childObjects.toArray(new DevelopmentObject[childObjects.size()]);
            int i = 0;
            while (i < children.length) {
                DevelopmentObject child = children[i];
                IPasteHandler handler = pasteManager.getPasteHandler(child);
                DevelopmentObject[] relevantChildren = MDOPasteManager.computeRelevantObjects((MetamodelClipboard)pasteManager.getClipboard(), (DevelopmentObject[])children, (int)i);
                if (handler != null && relevantChildren != null && relevantChildren.length > 0) {
                    handler.refactorAfterExecution(relevantChildren, newParent, scope, pasteManager);
                }
                ++i;
            }
        }
    }

    private void copyFolderStructure(ComponentInterfaceDefinition cid, IPasteManager manager) {
        ComponentInterfaceDefinition oldCid = (ComponentInterfaceDefinition)this.getOldMDO((MainDevelopmentObject)cid, manager);
        PARService.copyComponentInterfaceDefinitionFilesAndFolders((ComponentInterfaceDefinition)oldCid, (ComponentInterfaceDefinition)cid, (IProgressMonitor)manager.getSharedMonitor());
    }
}

