/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.dialogs;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesCreation;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.refac.RefactoringServices;
import com.sap.ide.webdynpro.ui.dialog.WDCopyDialog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyWindowDialog
extends WDCopyDialog {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String WINDOW = mCPool.getText(113);
    private static final String COPY_WINDOW = mCPool.getText(155, (Object)WINDOW);
    private String mWindowName = null;
    private String mWindowPackage = null;
    private IPackageFragmentRoot mPreselectedRoot = null;
    private Metamodel mMetamodel = null;
    private boolean mEnableSourceFolderList = true;
    private ClipboardObject[] mClipboardObjects = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public CopyWindowDialog(IPackageFragmentRoot[] allValidRoots, IPackageFragmentRoot preselectedRoot, Metamodel metamodel, String windowName, String windowPackage, ClipboardObject[] clipboardObjects, boolean enableSourceFolderList) {
        super(allValidRoots, COPY_WINDOW, "");
        this.mPreselectedRoot = preselectedRoot;
        this.mMetamodel = metamodel;
        this.mWindowName = windowName;
        this.mWindowPackage = windowPackage;
        this.mClipboardObjects = clipboardObjects;
        this.mEnableSourceFolderList = enableSourceFolderList;
    }

    protected void initializeListeners() {
        this.getNameField().addModifyListener((ModifyListener)new ComponentNameModifyListener());
        this.getPackageField().addModifyListener((ModifyListener)new ComponentPackageModifyListener());
        this.getBrowsePackageButton().addSelectionListener((SelectionListener)new BrowseComponentPackageButtonListener());
        this.getSourcePathListField().addSelectionListener((SelectionListener)new ComponentSourceSelectionListener());
    }

    protected void initializeFields() {
        if (this.mWindowName != null) {
            String oldName = this.mWindowName;
            String searchName = this.mWindowName;
            int nr = 0;
            while (this.mMetamodel.objectExists(this.mWindowPackage, searchName, WebDynproMDOEnum.WINDOW)) {
                String number = "_" + nr++;
                if (nr == 1) {
                    number = "";
                }
                searchName = "Copy" + number + "_of_" + oldName;
                this.setMessage(mCPool.getText(310));
            }
            this.getNameField().setText(searchName);
            this.getNameField().setSelection(0, searchName.length());
            this.setName(this.getNameField().getText());
        }
        if (this.mWindowPackage != null) {
            this.getPackageField().setText(this.mWindowPackage);
            this.setPackage(this.mWindowPackage);
        }
        int preselectionIndex = 0;
        IPackageFragmentRoot[] roots = this.getAllValidRoots();
        if (roots == null || roots.length <= 0) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            if (this.mPreselectedRoot != null && roots[i].equals(this.mPreselectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.getSourcePathListField().setSelection(preselectionIndex);
        this.setSourceRoot(roots[preselectionIndex]);
        this.getSourcePathListField().setEnabled(this.mEnableSourceFolderList);
    }

    public void handlePageCompletion() {
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(true);
        this.setName(this.getNameField().getText());
        this.setPackage(this.getPackageField().getText());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String nameInput = this.getNameField().getText();
        String packageInput = this.getPackageField().getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.getNameField());
        if (nameInput.length() <= 0) {
            this.setErrorMessage(mCPool.getText(20, (Object)WINDOW));
            return false;
        }
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)nameInput);
        if (!checkResult.isOk()) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)nameInput);
        if (lengthStatus.getSeverity() == 2) {
            this.setMessage(lengthStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (lengthStatus.getSeverity() == 4) {
            this.setErrorMessage(lengthStatus.getMessage());
            return false;
        }
        char c = nameInput.charAt(0);
        if (!Character.isUpperCase(c)) {
            this.setErrorMessage(mCPool.getText(17, (Object)nameInput));
            return false;
        }
        boolean existsInClip = RefactoringServices.nameExistsInClipboard((String)nameInput, (String)packageInput, (DevelopmentObjectEnum)WebDynproDevelopmentObjectEnum.WINDOW, (ClipboardObject[])this.mClipboardObjects);
        if (existsInClip) {
            this.setErrorMessage(mCPool.getText(33, (Object)nameInput, (Object)packageInput));
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.getPackageField());
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidSourceFolder() {
        if (this.getSourcePathListField().getItemCount() <= 0) {
            this.setErrorMessage(mCPool.getText(18));
            return false;
        }
        return true;
    }

    protected void okPressed() {
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)this.mMetamodel.getName());
        IPath sourcePath = manager.makePathAbsolute(this.getSourceRoot().getPath());
        SourcePathIdentifier identifier = manager.getSourcePathIdentifier(sourcePath);
        IStatus status = ServicesCreation.isValidWindowCreationPath(this.mMetamodel, this.getNameField().getText(), this.getPackageField().getText(), identifier);
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return;
        }
        String error = ServicesCreation.checkWindowOnFileSystem(this.getNameField().getText(), this.getPackageField().getText(), this.mMetamodel);
        if (error != null) {
            this.setErrorMessage(error);
            this.setPageComplete(false);
            return;
        }
        if (status.getSeverity() == 0 && error == null) {
            super.okPressed();
        }
    }

    class BrowseComponentPackageButtonListener
    extends SelectionAdapter {
        BrowseComponentPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)CopyWindowDialog.this.getSourceRoot(), (Shell)CopyWindowDialog.this.getShell());
            if (packageFragment != null) {
                CopyWindowDialog.this.getPackageField().setText(packageFragment.getElementName());
            }
            if (CopyWindowDialog.this.isValidPackageField() && CopyWindowDialog.this.isValidNameField() && CopyWindowDialog.this.isValidSourceFolder()) {
                CopyWindowDialog.this.handlePageCompletion();
            } else {
                CopyWindowDialog.this.setPageComplete(false);
            }
        }
    }

    class ComponentSourceSelectionListener
    implements SelectionListener {
        ComponentSourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = CopyWindowDialog.this.getSourcePathListField().getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot selectedRoot = CopyWindowDialog.this.getAllValidRoots()[selectionIndex];
                CopyWindowDialog.this.setSourceRoot(selectedRoot);
            }
        }
    }

    class ComponentPackageModifyListener
    implements ModifyListener {
        ComponentPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (CopyWindowDialog.this.isValidPackageField() && CopyWindowDialog.this.isValidNameField() && CopyWindowDialog.this.isValidSourceFolder()) {
                CopyWindowDialog.this.handlePageCompletion();
            } else {
                CopyWindowDialog.this.setPageComplete(false);
            }
        }
    }

    class ComponentNameModifyListener
    implements ModifyListener {
        ComponentNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (CopyWindowDialog.this.isValidNameField() && CopyWindowDialog.this.isValidPackageField() && CopyWindowDialog.this.isValidSourceFolder()) {
                CopyWindowDialog.this.handlePageCompletion();
            } else {
                CopyWindowDialog.this.setPageComplete(false);
            }
        }
    }
}

