/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationmodeler.check;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.component.NavigationLinks;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.navigation.NavigationLink;
import com.sap.ide.metamodel.webdynpro.component.navigation.NavigationTargetReference;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.ViewContainer;
import com.sap.ide.metamodel.webdynpro.component.viewset.Placeholder;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewContainerAssignment;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.metamodel.webdynpro.component.viewset.Viewset;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewsetHierarchyNode;
import com.sap.ide.metamodel.webdynpro.repository.WindowRepositoryManager;
import com.sap.ide.webdynpro.checklayer.RepairResult;
import com.sap.ide.webdynpro.checklayer.window.WindowChecker;
import com.sap.ide.webdynpro.service.applicationmodeler.ServiceApplicationModelerPlugin;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import java.util.ArrayList;

public class WindowRepairer {
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$applicationmodeler$check$WindowRepairer;

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByWindowReparation(Window window) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(WindowRepositoryManager.getRepositioryObject((Window)window, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static void repair(Window window, RepairResult repairResult) {
        WindowRepairer.repairLinks(window, repairResult);
        WindowRepairer.repairViewsetHierarchy(window, repairResult);
    }

    public static void repairLinks(Window window, RepairResult repairResult) {
        NavigationLinks linkContainer = window.getNavigationLinks();
        if (linkContainer == null) {
            return;
        }
        NavigationLink[] navigationLinks = linkContainer.getNavigationLinks();
        int i = 0;
        while (i < navigationLinks.length) {
            WindowRepairer.repairNavigationLink(navigationLinks[i], repairResult);
            ++i;
        }
    }

    private static void repairNavigationLink(NavigationLink navigationLink, RepairResult repairResult) {
        if (navigationLink.getSource() == null || navigationLink.getSourceViewUsage() == null) {
            ServicesDeletion.deleteNavigationLink(navigationLink);
            repairResult.addEntry((DevelopmentObject)navigationLink, true, "deleted NavigationLink ");
            return;
        }
        NavigationTargetReference[] targetReferences = navigationLink.getTargetReferences();
        int i = 0;
        while (i < targetReferences.length) {
            NavigationTargetReference targetReference = targetReferences[i];
            if (targetReference.getTarget() == null || targetReference.getTargetViewUsage() == null) {
                ServicesDeletion.deleteTargetReference(targetReference);
                repairResult.addEntry((DevelopmentObject)targetReference, true, "deleted NavigationTargetReference ");
            }
            ++i;
        }
    }

    public static void repairViewsetHierarchy(Window window, RepairResult repairResult) {
        ViewsetHierarchyNode[] rootNodes = window.getViewsetHierarchyRootNodes();
        if (rootNodes.length <= 0) {
            return;
        }
        int i = 0;
        while (i < rootNodes.length) {
            WindowRepairer.repairViewsetHierarchyNode(rootNodes[i], repairResult);
            ++i;
        }
    }

    public static void repairViewsetHierarchyNode(ViewsetHierarchyNode node, RepairResult repairResult) {
        Placeholder[] placeholders = node.getViewAreas();
        int i = 0;
        while (i < placeholders.length) {
            Placeholder placeholder = placeholders[i];
            ViewsetHierarchyNode[] embeddedNodes = placeholder.getEmbeddedNodes();
            int j = 0;
            while (j < embeddedNodes.length) {
                WindowRepairer.repairViewsetHierarchyNode(embeddedNodes[j], repairResult);
                ++j;
            }
            ++i;
        }
        if (node instanceof ViewUsage) {
            ViewUsage viewUsage = (ViewUsage)node;
            if (viewUsage.getView() == null) {
                ServicesDeletion.deleteViewUsage(viewUsage, false);
                repairResult.addEntry((DevelopmentObject)viewUsage, true, "deleted ViewUsage ");
            } else if (viewUsage.getView() instanceof View) {
                WindowRepairer.repairViewContainerAssignments(viewUsage, repairResult);
            }
        } else if (node instanceof Viewset) {
            // empty if block
        }
    }

    private static void repairViewContainerAssignments(ViewUsage viewUsage, RepairResult repairResult) {
        Placeholder[] placeHolders = viewUsage.getViewAreas();
        int i = 0;
        while (i < placeHolders.length) {
            ViewContainerAssignment viewContainerAssignment = (ViewContainerAssignment)placeHolders[i];
            if (viewContainerAssignment.getViewContainer() == null) {
                boolean successful = true;
                try {
                    viewContainerAssignment.delete();
                }
                catch (DeleteException e) {
                    ServiceApplicationModelerPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationmodeler$check$WindowRepairer == null ? WindowRepairer.class$("com.sap.ide.webdynpro.service.applicationmodeler.check.WindowRepairer") : class$com$sap$ide$webdynpro$service$applicationmodeler$check$WindowRepairer, "updateViewUsages", "deleting ViewContainerAssignment failed", e, false);
                    successful = false;
                }
                repairResult.addEntry((DevelopmentObject)viewUsage, successful, "deleted ViewContainerAssignment " + viewContainerAssignment.getName());
            }
            ++i;
        }
        View view = (View)viewUsage.getView();
        ViewContainer[] viewContainers = view.getViewContainers();
        int i2 = 0;
        while (i2 < viewContainers.length) {
            if (!WindowChecker.hasViewContainerAssignment((ViewUsage)viewUsage, (ViewContainer)viewContainers[i2])) {
                ViewContainerAssignment viewContainerAssignment = null;
                try {
                    viewContainerAssignment = viewUsage.createViewArea(viewContainers[i2].getName());
                }
                catch (CreateException e) {
                    ServiceApplicationModelerPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationmodeler$check$WindowRepairer == null ? WindowRepairer.class$("com.sap.ide.webdynpro.service.applicationmodeler.check.WindowRepairer") : class$com$sap$ide$webdynpro$service$applicationmodeler$check$WindowRepairer, "repairViewContainerAssignments", "error on creating ViewContainerAssignment", e, false);
                }
                if (viewContainerAssignment != null) {
                    viewContainerAssignment.setViewContainer(viewContainers[i2]);
                    repairResult.addEntry((DevelopmentObject)viewUsage, true, "created ViewContainerAssignment " + viewContainerAssignment.getName());
                }
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

