/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.wizard.internal;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.GenericJavaTypeChooser;
import com.tssap.j2ee.ui.core.listener.ButtonEvAdapter;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.j2ee.util.wizard.WizardMsg;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class NewWebTypeWizardPage
extends NewTypeWizardPage {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$wizard$internal$NewWebTypeWizardPage == null ? (class$com$tssap$j2ee$ui$web$wizard$internal$NewWebTypeWizardPage = NewWebTypeWizardPage.class$("com.tssap.j2ee.ui.web.wizard.internal.NewWebTypeWizardPage")) : class$com$tssap$j2ee$ui$web$wizard$internal$NewWebTypeWizardPage));
    protected static final int SERVLET = 0;
    protected static final int LISTENER = 1;
    protected static final int FILTER = 2;
    protected String RESOURCENAME;
    protected String RESOURCETYPE;
    protected String RESOURCESUPERCLASS = "Superclass";
    protected String RESOURCEPACKAGE;
    private static final String WEBPROJECT = "Web Project";
    protected static final String SELECT = "please select";
    public static final String DEF_PACKAGE = "<default>";
    private int wizardType;
    private Label resourceNameLabel;
    protected Text resourceNameText;
    private Label resourceTypeLabel;
    protected Combo resourceTypeCombo;
    private String[] typeItems;
    private Label webProjectsLabel;
    protected Combo webProjectsCombo;
    private String[] webProjectItems;
    protected Text resourcePackText;
    private Label resourcePackLabel;
    private Button browseButton;
    protected Text superClassText;
    private Label superClassLabel;
    private Button browseButton1;
    private IPackageFragment resourcePackage;
    protected IStructuredSelection selection;
    private boolean projectSelected;
    private IWebProject webProject;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$wizard$internal$NewWebTypeWizardPage;

    public NewWebTypeWizardPage(String name, int type) {
        super(true, name);
        this.wizardType = type;
        switch (type) {
            case 0: {
                this.setTitle(WizardMsg.getString((String)"NewServlet.pageTitle"));
                this.setDescription(WizardMsg.getString((String)"NewServlet.description"));
                break;
            }
            case 1: {
                this.setTitle(WizardMsg.getString((String)"NewListener.pageTitle"));
                this.setDescription(WizardMsg.getString((String)"NewListener.description"));
                break;
            }
            case 2: {
                this.setTitle(WizardMsg.getString((String)"NewFilter.pageTitle"));
                this.setDescription(WizardMsg.getString((String)"NewFilter.description"));
                break;
            }
        }
    }

    public abstract void createControl(Composite var1);

    public void init(IStructuredSelection _selection) {
        this.selection = _selection;
        this.doStatusUpdate();
    }

    protected void createResourceTypeControl(IGridLayoutPane pane) {
        this.resourceTypeLabel = pane.addTextLabel(this.RESOURCETYPE, pane.createGridLayoutData(4, 2, true, false, 2, 1));
        this.resourceTypeCombo = pane.addComboBox(this.typeItems, "", true, pane.createGridLayoutData(4, 2, true, false, 6, 1));
        if (this.typeItems.length > 0) {
            this.resourceTypeCombo.setText(this.typeItems[0]);
        }
        this.resourceTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebTypeWizardPage.this.resourceTypeSelected();
            }
        });
        this.enableTypeControls(this.projectSelected);
    }

    protected void createWebProjectControl(IGridLayoutPane pane) {
        Object elem;
        IWebModule[] projects = J2eeProjectManager.getWebModules();
        this.webProjectItems = new String[projects.length + 1];
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                this.webProjectItems[i] = projects[i].getName();
                ++i;
            }
            this.webProjectItems[this.webProjectItems.length - 1] = SELECT;
        } else {
            this.webProjectItems[0] = "";
        }
        IJavaProject selectedProject = null;
        Object object = elem = this.selection != null ? this.selection.getFirstElement() : null;
        if (elem == null) {
            this.selection = UIPlugin.getSelection();
            if (this.selection != null) {
                elem = this.selection.getFirstElement();
            }
        }
        try {
            if (this.selection != null && elem != null && elem instanceof Element) {
                Element element = (Element)elem;
                if (J2eeElementManager.isWebProject((Element)element)) {
                    this.setSelectedProject(J2eeElementManager.getWebProject((Element)element));
                    selectedProject = this.webProject.getJavaProject();
                } else if (J2eeElementManager.isWebProject((Element)element.getModel())) {
                    IJavaElement javaEl;
                    IResource obj;
                    this.setSelectedProject(J2eeElementManager.getWebProject((Element)element.getModel()));
                    selectedProject = this.webProject.getJavaProject();
                    if (J2eeElementManager.isPackageFragmentFolder((Element)element) && (obj = J2eeElementManager.getResourceToElement((Element)element)) instanceof IFolder && (javaEl = JavaCore.create((IFolder)((IFolder)obj))) instanceof IPackageFragment) {
                        this.setResourcePackage((IPackageFragment)javaEl);
                    }
                }
            }
        }
        catch (Exception e) {
            tracer.error("", (Throwable)e);
        }
        this.webProjectsLabel = pane.addTextLabel(WEBPROJECT, pane.createGridLayoutData(4, 2, true, false, 2, 1));
        if (selectedProject != null) {
            this.webProjectsCombo = pane.addComboBox(this.webProjectItems, selectedProject.getElementName(), true, pane.createGridLayoutData(4, 2, true, false, 6, 1));
            this.projectSelected = true;
            this.webProjectSelected();
        } else {
            this.webProjectsCombo = pane.addComboBox(this.webProjectItems, SELECT, true, pane.createGridLayoutData(4, 2, true, false, 6, 1));
            this.webProjectSelected();
        }
        this.webProjectsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebTypeWizardPage.this.webProjectSelected();
            }
        });
    }

    protected void createResourceNameControl(IGridLayoutPane pane) {
        this.resourceNameLabel = pane.addTextLabel(this.RESOURCENAME, pane.createGridLayoutData(4, 2, true, false, 2, 1));
        this.resourceNameText = pane.addTextField("", pane.createGridLayoutData(4, 2, true, false, 6, 1));
        this.resourceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWebTypeWizardPage.this.resourceNameChanged();
            }
        });
    }

    protected void createResourcePackageControl(IGridLayoutPane pane) {
        this.resourcePackLabel = pane.addTextLabel(this.RESOURCEPACKAGE, pane.createGridLayoutData(4, 2, true, false, 2, 1));
        this.resourcePackText = pane.addTextField("", pane.createGridLayoutData(4, 2, true, false, 5, 1));
        this.browseButton = pane.addPushButton("Browse", pane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTUtils.choosePackageFromDialog((Shell)NewWebTypeWizardPage.this.getShell(), (IJavaProject)NewWebTypeWizardPage.this.getWebProject().getJavaProject(), null, (boolean)false);
                if (fragment != null) {
                    String packageName = fragment.getElementName();
                    if (packageName.length() == 0) {
                        packageName = NewWebTypeWizardPage.DEF_PACKAGE;
                    }
                    NewWebTypeWizardPage.this.resourcePackText.setText(packageName);
                    NewWebTypeWizardPage.this.setResourcePackage(fragment);
                }
            }
        });
        this.resourcePackText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWebTypeWizardPage.this.resourcePackageChanged();
            }
        });
        this.enablePackageControls(this.projectSelected);
        if (this.resourcePackage != null) {
            this.resourcePackText.setText(this.resourcePackage.getElementName());
        }
    }

    protected void createSuperClassControl(IGridLayoutPane pane) {
        this.superClassLabel = pane.addTextLabel(this.RESOURCESUPERCLASS, pane.createGridLayoutData(4, 2, true, false, 2, 1));
        this.superClassText = pane.addTextField("", pane.createGridLayoutData(4, 2, true, false, 5, 1));
        this.browseButton1 = pane.addPushButton("Browse", pane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.browseButton1.addSelectionListener((SelectionListener)new ButtonEvAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = NewWebTypeWizardPage.this.createSuperclassChooser();
                NewWebTypeWizardPage.this.superClassSelected(type);
            }
        });
        this.superClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWebTypeWizardPage.this.updateStatus();
            }
        });
        this.enableSuperClassControls(this.projectSelected);
    }

    public IType createSuperclassChooser() {
        IJavaProject[] thisJavaPrjAr = new IJavaProject[]{this.getWebProject().getJavaProject()};
        GenericJavaTypeChooser gjtc = new GenericJavaTypeChooser(thisJavaPrjAr);
        IType ret = gjtc.getTypedSelection(null, this.getShell());
        return ret;
    }

    protected void enableSuperClassControls(boolean flag) {
        if (this.superClassText != null && this.superClassLabel != null && this.browseButton1 != null) {
            this.superClassText.setEnabled(flag);
            this.superClassLabel.setEnabled(flag);
            this.browseButton1.setEnabled(flag);
        }
    }

    protected void enableTypeControls(boolean flag) {
        if (this.resourceTypeCombo != null && this.resourceTypeLabel != null) {
            this.resourceTypeCombo.setEnabled(flag);
            this.resourceTypeLabel.setEnabled(flag);
        }
    }

    private void enablePackageControls(boolean flag) {
        if (this.resourcePackText != null && this.resourcePackLabel != null && this.browseButton != null) {
            this.resourcePackText.setEnabled(flag);
            this.resourcePackLabel.setEnabled(flag);
            this.browseButton.setEnabled(flag);
        }
    }

    public void clearTypeSelection() {
        if (this.resourceTypeCombo != null) {
            this.resourceTypeCombo.select(0);
        }
    }

    protected IPackageFragment getResourcePackage() {
        if (this.resourcePackage == null) {
            this.resourcePackage = JDTUtils.getPackageFragmentByName((IJavaProject)this.webProject.getJavaProject(), (String)this.resourcePackText.getText());
        }
        return this.resourcePackage;
    }

    protected String getResourceType() {
        return this.typeItems[this.resourceTypeCombo.getSelectionIndex()];
    }

    public void setResourcePackage(IPackageFragment _package) {
        this.resourcePackage = _package;
    }

    public void setSelectedProject(IWebProject project) {
        this.webProject = project;
    }

    public IWebProject getWebProject() {
        return this.webProject;
    }

    public void setTypeItems(String[] items) {
        this.typeItems = items;
    }

    public String getResourceName() {
        return this.resourceNameText.getText();
    }

    public String getResourceSuperClass() {
        return this.superClassText.getText();
    }

    protected void resourceTypeSelected() {
        this.updateStatus();
    }

    protected void superClassSelected(IType type) {
        if (type != null) {
            this.superClassText.setText(type.getFullyQualifiedName());
        }
    }

    protected void resourceNameChanged() {
        this.updateStatus();
    }

    protected void resourcePackageChanged() {
        this.updateStatus();
    }

    protected void webProjectSelected() {
        this.webProject = J2eeProjectManager.getWebModule((String)this.webProjectItems[this.webProjectsCombo.getSelectionIndex()]);
        boolean selected = !this.webProjectsCombo.getItem(this.webProjectsCombo.getSelectionIndex()).equals(SELECT);
        this.enablePackageControls(selected);
        this.enableSuperClassControls(selected);
        this.enableTypeControls(selected);
        this.updateStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateStatus() {
        if (this.webProjectsCombo != null && this.resourceNameText != null) {
            if (this.webProjectsCombo.getItem(this.webProjectsCombo.getSelectionIndex()).equals(SELECT)) {
                this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid Web project", null));
                return false;
            }
            if (this.resourceNameText.getText() == null || this.resourceNameText.getText().equals("") || this.resourceNameText.getText().indexOf(".") >= 0) {
                this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid resource name", null));
                return false;
            }
            if (!JavaConventions.validateJavaTypeName((String)this.resourceNameText.getText()).isOK()) {
                IStatus val = JavaConventions.validateJavaTypeName((String)this.resourceNameText.getText());
                if (val.getSeverity() == 4) {
                    this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.error.InvalidTypeName", (Object)val.getMessage()), null));
                    return false;
                }
                if (val.getSeverity() == 2) {
                    this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.TypeNameDiscouraged", (Object)val.getMessage()), null));
                    return false;
                }
                return false;
            }
            if (this.resourcePackText.getText() == null || this.resourcePackText.getText().equals("")) {
                this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid resource package", null));
                return false;
            }
            if (this.resourcePackText.getText().equals(DEF_PACKAGE)) {
                this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid resource package, <default> is not supported yet", null));
                return false;
            }
            if (!(this.wizardType != 1 && this.wizardType != 2 || this.superClassText.getText().equals(""))) {
                IStatus tempST = JavaConventions.validateJavaTypeName((String)this.superClassText.getText());
                if (!tempST.isOK()) {
                    this.updateStatus((IStatus)new Status(2, "com.tssap.j2ee.ui", 2, WizardMsg.getString((String)"NewFilterOrListener.superclassError"), null));
                    return false;
                }
                try {
                    if (!JDTUtils.checkClassExistence((String)this.superClassText.getText(), (boolean)false)) {
                        this.updateStatus((IStatus)new Status(2, "com.tssap.j2ee.ui", 2, WizardMsg.getString((String)"NewFilterOrListener.superclassError"), null));
                        return false;
                    }
                    this.updateStatus((IStatus)new Status(0, "com.tssap.j2ee.ui", 0, "", null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String text = this.resourceNameText.getText();
                switch (this.wizardType) {
                    case 0: {
                        if (!text.equals("GenericServlet") && !text.equals("HttpServlet")) break;
                        this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid resource name, " + text + " is a reserved typename", null));
                        return false;
                    }
                    case 1: {
                        if (!text.equals("HttpSessionAttributeListener") && !text.equals("HttpSessionListener") && !text.equals("ServletContextAttributeListener") && !text.equals("ServletContextListener")) break;
                        this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid resource name, " + text + " is a reserved typename", null));
                        return false;
                    }
                    case 2: {
                        if (!text.equals("Filter")) break;
                        this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "please select a valid resource name, " + text + " is a reserved typename", null));
                        return false;
                    }
                }
                try {
                    String resName = this.resourcePackText.getText() + "." + this.resourceNameText.getText();
                    IJavaProject jPrj = JavaCore.create((IProject)this.getWebProject().getProject().getProject());
                    if (jPrj.findType(resName) != null) {
                        this.updateStatus((IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "Class already exists", null));
                        return false;
                    }
                }
                catch (JavaModelException e) {
                    tracer.error("", (Throwable)e);
                }
            }
        }
        this.updateStatus((IStatus)new Status(0, "com.tssap.j2ee.ui", 0, "", null));
        return true;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{new Status(0, "com.tssap.j2ee.ui", 0, "", null)};
        this.updateStatus(status);
    }

    protected IPackageFragment createTypePackage() {
        IPackageFragment ret = null;
        String text = this.resourcePackText.getText();
        if (text.equals(DEF_PACKAGE)) {
            text = "";
        }
        if (StringUtils.isPackage((String)text)) {
            ret = JDTUtils.getPackageFragmentByName((IJavaProject)this.getWebProject().getJavaProject(), (String)text);
            if (ret == null) {
                IPackageFragmentRoot[] allRoots = JDTUtils.getSrcPackageFragmentRoots((IJavaProject)this.getWebProject().getJavaProject());
                if (allRoots == null || allRoots.length <= 0) {
                    return null;
                }
                ret = JDTUtils.createPackage((String)text, (IPackageFragmentRoot)allRoots[0]);
                if (ret == null || !ret.exists()) {
                    return null;
                }
            }
            this.resourcePackText.setText(ret.getElementName());
            this.resourcePackage = ret;
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)"ERROR", (String)"No valid Package", (IStatus)new Status(4, "com.tssap.j2ee.ui", 4, "no valid package", null));
        }
        this.updateStatus();
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

