/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.wizard.internal;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.web.wizard.internal.WebProjectsContentsProvider;
import com.tssap.j2ee.util.wizard.WizardMsg;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewWebFileWizardPage
extends WizardPage {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$wizard$internal$NewWebFileWizardPage == null ? (class$com$tssap$j2ee$ui$web$wizard$internal$NewWebFileWizardPage = NewWebFileWizardPage.class$("com.tssap.j2ee.ui.web.wizard.internal.NewWebFileWizardPage")) : class$com$tssap$j2ee$ui$web$wizard$internal$NewWebFileWizardPage));
    private static final String WEBAP = "WEB Assembly Project: ";
    protected static final int JSP = 0;
    protected static final int HTML = 1;
    private TreeViewer treeViewer;
    protected String FILENAME;
    protected Text folderNameText;
    protected Text fileNameText;
    protected Label fileNameLabel;
    private IWebProject webProject;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$wizard$internal$NewWebFileWizardPage;

    public NewWebFileWizardPage(String pageName, int type) {
        super(pageName);
        switch (type) {
            case 0: {
                this.setTitle(WizardMsg.getString((String)"NewJSPFile.pageTitle"));
                this.setDescription(WizardMsg.getString((String)"NewJSPFile.description"));
                break;
            }
            case 1: {
                this.setTitle(WizardMsg.getString((String)"NewHTMLFile.pageTitle"));
                this.setDescription(WizardMsg.getString((String)"NewHTMLFile.description"));
                break;
            }
        }
        this.updateStatus();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        IGridLayoutPane pane = PaneFactory.createGridLayoutPaneEqualCols((Composite)composite, (int)1);
        GridData data = new GridData(1808);
        data.widthHint = 150;
        pane.getComposite().setLayoutData((Object)data);
        this.createFolderControls(pane);
        this.createWebProjectsTreeViewer(pane);
        this.createFileNameControls(pane);
        pane.addPlaceholder();
        this.setControl((Control)composite);
        this.fileNameText.setFocus();
    }

    private void createFolderControls(IGridLayoutPane pane) {
        pane.addTextLabel("Select a folder :");
        this.folderNameText = pane.addTextField(true, pane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.folderNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWebFileWizardPage.this.folderNameChanged();
            }
        });
    }

    private void createFileNameControls(IGridLayoutPane pane) {
        pane.addPlaceholder();
        IGridLayoutPane textPane = pane.addGridLayoutPane(2, pane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.fileNameLabel = textPane.addTextLabel(this.FILENAME);
        this.fileNameText = textPane.addTextField(false, textPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWebFileWizardPage.this.fileNameChanged();
            }
        });
    }

    private void createWebProjectsTreeViewer(IGridLayoutPane pane) {
        Object elem;
        DrillDownComposite drillDown = new DrillDownComposite(pane.getComposite(), 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 150;
        spec.heightHint = 200;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        WebProjectsContentsProvider cp = new WebProjectsContentsProvider();
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter(){});
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof IProject) {
                    NewWebFileWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)((IProject)selection.getFirstElement()).getFolder("webContent")));
                } else {
                    NewWebFileWizardPage.this.containerSelectionChanged((IContainer)selection.getFirstElement());
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        IStructuredSelection selection = ((BasicNewResourceWizard)this.getWizard()).getSelection();
        if (selection == null) {
            selection = UIPlugin.getSelection();
        }
        Object object = elem = selection != null ? selection.getFirstElement() : null;
        if (elem == null && selection != null) {
            elem = selection.getFirstElement();
        }
        try {
            if (selection != null && elem != null) {
                if (elem instanceof Element) {
                    Element element = (Element)elem;
                    if (J2eeElementManager.isWebProject((Element)element.getModel()) && J2eeElementManager.isWebFolder((Element)element)) {
                        IResource obj = J2eeElementManager.getResourceToElement((Element)element);
                        if (obj instanceof IFolder) {
                            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)((IFolder)obj)));
                        }
                    } else {
                        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)J2eeElementManager.getWebProject((Element)element.getModel()).getProject().findMember("webContent")));
                    }
                } else {
                    this.treeViewer.setSelection((ISelection)selection);
                }
            } else if (J2eeProjectManager.getWebModules() != null && J2eeProjectManager.getWebModules().length > 0) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)J2eeProjectManager.getWebModules()[0].getProject().findMember("webContent")));
            }
        }
        catch (Exception e) {
            tracer.error("", (Throwable)e);
        }
        this.treeViewer.expandToLevel(1);
    }

    public void containerSelectionChanged(IContainer container) {
        if (container == null || !(container instanceof IFolder)) {
            this.folderNameText.setText("");
        } else {
            this.folderNameText.setText(container.getFullPath().makeRelative().toString());
            this.webProject = J2eeProjectManager.getWebModule((String)container.getProject().getName());
        }
    }

    protected void fileNameChanged() {
        this.updateStatus();
    }

    protected void folderNameChanged() {
        this.updateStatus();
    }

    protected void updateStatus(boolean correct, String message) {
        this.setPageComplete(correct);
        if (correct) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(message);
        }
    }

    protected void updateStatus() {
        if (this.folderNameText == null || this.folderNameText.getText().equals("")) {
            this.updateStatus(false, "Please select a folder");
        } else if (this.fileNameText == null || this.fileNameText.getText().equals("")) {
            this.updateStatus(false, "Please enter a file name");
        } else {
            IStatus st = this.validateInput();
            this.updateStatus(st.isOK(), st.getMessage());
        }
    }

    protected abstract IStatus validateInput();

    protected String getFileName() {
        return this.fileNameText.getText();
    }

    protected String getFileContainerProjectRelative() {
        String wholePath = this.folderNameText.getText();
        return wholePath.substring(wholePath.indexOf("/") + 1);
    }

    protected IPath getFileContainerFullPath() {
        String wholePath = this.folderNameText.getText();
        return this.getWebProject().getProject().getFullPath().append(wholePath.substring(wholePath.indexOf("/") + 1));
    }

    protected IWebProject getWebProject() {
        return this.webProject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

