/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.wizard;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.IListener;
import com.tssap.j2ee.model.web.IListenerCreationData;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.model.web.impl.ListenerCreationData;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.util.ReferenceUtil;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.j2ee.ui.web.wizard.internal.ListenerWizardMainPage;
import com.tssap.j2ee.util.wizard.WizardMsg;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.util.action.predefined.OpenInEditorAction;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ListenerWizard
extends Wizard
implements INewWizard {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$wizard$ListenerWizard == null ? (class$com$tssap$j2ee$ui$web$wizard$ListenerWizard = ListenerWizard.class$("com.tssap.j2ee.ui.web.wizard.ListenerWizard")) : class$com$tssap$j2ee$ui$web$wizard$ListenerWizard));
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private ListenerWizardMainPage mainPage;
    private ListenerCreationData data;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$wizard$ListenerWizard;

    public void addPages() {
        super.addPages();
        this.mainPage = new ListenerWizardMainPage("New Listener Wizard");
        this.mainPage.init(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(WizardMsg.getString((String)"NewListener.windowTitle"));
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDesc((String)"listenerLarge"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.data = this.mainPage.finish();
        if (this.data == null) {
            return false;
        }
        WorkspaceModifyOperation op1 = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor _monitor) throws CoreException {
                ListenerWizard.this.createListener(_monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op1);
        }
        catch (InterruptedException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public void createListener(IProgressMonitor monitor) {
        monitor.beginTask("Listener creation ... ", 100);
        monitor.done();
        ModelAccess.runCommandLater((Runnable)new Runnable(){

            public void run() {
                IWebProject webProject = ListenerWizard.this.data.getWebProject();
                try {
                    IResource parentResource = null;
                    boolean wsMonitorDeaktiv = false;
                    if (DTRUtils.isTeamProviderAvailable((IProject)webProject.getProject())) {
                        try {
                            parentResource = ListenerWizard.this.data.getListenerPackage().getCorrespondingResource();
                            if (parentResource != null) {
                                wsMonitorDeaktiv = DTRUtils.setWorkspaceMonitor((IResource[])new IResource[]{parentResource}, (boolean)false, (int)2);
                            }
                        }
                        catch (JavaModelException e1) {
                            tracer.error("", (Throwable)e1);
                        }
                    }
                    IListener listener = webProject.createListener((IListenerCreationData)ListenerWizard.this.data);
                    if (wsMonitorDeaktiv) {
                        DTRUtils.setWorkspaceMonitor((IResource[])new IResource[]{parentResource}, (boolean)true, (int)2);
                    }
                    if (listener != null && DTRUtils.isTeamProviderAvailable((IProject)webProject.getProject())) {
                        DTRUtils.doAddToVCS((IResource[])new IFile[]{listener.getFile()}, (IProject)webProject.getProject(), (String)"Listener", (String)listener.getName(), (String)"Add To source control");
                    }
                    if (listener != null) {
                        ReferenceUtil.addWebObjectsToDescriptor((IWebSource)listener);
                        OpenInEditorAction.openInEditor((IFile)listener.getFile(), (boolean)true);
                    }
                }
                catch (J2eeCreateException e) {
                    String excMsg = e.getMessage();
                    if (excMsg == null) {
                        excMsg = "";
                    }
                    MessageDialog.openError((Shell)ListenerWizard.this.getShell(), (String)"Creation Error", (String)("Not able to create Listener! \n\r" + excMsg));
                    tracer.error("", (Throwable)e);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

