/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.wizard;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.IHtmlFile;
import com.tssap.j2ee.model.web.IHtmlFileCreationData;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.impl.HtmlFileCreationData;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.j2ee.ui.web.wizard.internal.HTMLWizardMainPage;
import com.tssap.j2ee.util.wizard.WizardMsg;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.util.action.predefined.OpenInEditorAction;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class HTMLWizard
extends BasicNewResourceWizard {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$wizard$HTMLWizard == null ? (class$com$tssap$j2ee$ui$web$wizard$HTMLWizard = HTMLWizard.class$("com.tssap.j2ee.ui.web.wizard.HTMLWizard")) : class$com$tssap$j2ee$ui$web$wizard$HTMLWizard));
    private HTMLWizardMainPage mainPage;
    private IWorkbench workbench;
    private HtmlFileCreationData data;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$wizard$HTMLWizard;

    public void addPages() {
        this.mainPage = new HTMLWizardMainPage("New HTML File Wizard");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(WizardMsg.getString((String)"NewHTMLFile.windowTitle"));
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDesc((String)"htmlLarge"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.data = this.mainPage.finish();
        WorkspaceModifyOperation op1 = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor _monitor) throws CoreException {
                HTMLWizard.this.createHTMLFile(_monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op1);
        }
        catch (InterruptedException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public void createHTMLFile(IProgressMonitor monitor) {
        monitor.beginTask("Html creation ... ", 100);
        monitor.done();
        ModelAccess.runCommandLater((Runnable)new Runnable(){

            public void run() {
                IWebProject webProject = HTMLWizard.this.data.getWebProject();
                if (webProject == null) {
                    return;
                }
                try {
                    IFolder parentResource = null;
                    boolean wsMonitorDeaktiv = false;
                    if (DTRUtils.isTeamProviderAvailable((IProject)webProject.getProject()) && (parentResource = webProject.getProject().getFolder("webContent")) != null) {
                        wsMonitorDeaktiv = DTRUtils.setWorkspaceMonitor((IResource[])new IResource[]{parentResource}, (boolean)false, (int)Integer.MAX_VALUE);
                    }
                    IHtmlFile htmlFile = webProject.createHtmlFile((IHtmlFileCreationData)HTMLWizard.this.data);
                    if (wsMonitorDeaktiv) {
                        DTRUtils.setWorkspaceMonitor((IResource[])new IResource[]{parentResource}, (boolean)true, (int)Integer.MAX_VALUE);
                    }
                    if (htmlFile != null && DTRUtils.isTeamProviderAvailable((IProject)webProject.getProject())) {
                        DTRUtils.doAddToVCS((IResource[])new IFile[]{htmlFile.getFile()}, (IProject)webProject.getProject(), (String)"htmlFile", (String)htmlFile.getName(), (String)"Add To source control");
                    }
                    if (htmlFile != null) {
                        OpenInEditorAction.openInEditor((IFile)htmlFile.getFile(), (boolean)true);
                    }
                }
                catch (J2eeCreateException e) {
                    String excMsg = e.getMessage();
                    if (excMsg == null) {
                        excMsg = "";
                    }
                    MessageDialog.openError((Shell)HTMLWizard.this.getShell(), (String)"Creation Error", (String)("Not able to create HTML File! \n\r" + excMsg));
                    tracer.error("", (Throwable)e);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

