/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.webobjects;

import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.web.dd.IFilter;
import com.tssap.j2ee.model.web.dd.IInitParam;
import com.tssap.j2ee.model.web.dd.IListener;
import com.tssap.j2ee.model.web.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsTreeContentProvider;
import com.tssap.util.ui.ILabel;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class WebObjectsTreeLabelProvider
extends LabelProvider {
    private static Image FILTER_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"Filter_15x16.gif");
    private static Image LISTENER_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"Listener_15x16.gif");
    private static Image JSP_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"JSP_15x16.gif");
    private static Image SERVLET_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"Servlet_15x16.gif");
    private static Image PARAM_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"InitParameter.gif");
    private static Image SECURITY_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"SecurityRole.gif");
    private static Image FOLDER_IMG = SapIdeUtilImages.getImageFromIconsDirectory((String)"com.tssap.j2ee.ui", (String)"fldr_obj.gif");

    public Image getImage(Object element) {
        Image retImage = super.getImage(element);
        if (element instanceof ILabel) {
            retImage = ((ILabel)element).getImage();
        } else if (element instanceof IServlet) {
            IServlet servlet = (IServlet)element;
            retImage = servlet.getServletClass() != null ? SERVLET_IMG : JSP_IMG;
        } else if (element instanceof IFilter) {
            retImage = FILTER_IMG;
        } else if (element instanceof IListener) {
            retImage = LISTENER_IMG;
        } else if (element instanceof WebObjectsTreeContentProvider.InitParamsNode) {
            retImage = FOLDER_IMG;
        } else if (element instanceof WebObjectsTreeContentProvider.SecurityRoleRefNode) {
            retImage = FOLDER_IMG;
        } else if (element instanceof TreeNode) {
            if (((TreeNode)element).getIdentifiable() instanceof IInitParam) {
                retImage = PARAM_IMG;
            } else if (((TreeNode)element).getIdentifiable() instanceof ISecurityRoleRef) {
                retImage = SECURITY_IMG;
            }
        }
        return retImage;
    }

    public String getText(Object element) {
        String retText = super.getText(element);
        if (element instanceof ILabel) {
            retText = ((ILabel)element).getName();
        } else if (element instanceof IServlet) {
            retText = MutableUtil.mutableToValue((IMutable)((IServlet)element).getServletName());
        } else if (element instanceof IFilter) {
            retText = MutableUtil.mutableToValue((IMutable)((IFilter)element).getFilterName());
        } else if (element instanceof IListener) {
            String listenerClass = MutableUtil.mutableToValue((IMutable)((IListener)element).getListenerClass());
            retText = listenerClass.substring(listenerClass.lastIndexOf(".") + 1, listenerClass.length());
        } else if (element instanceof TreeNode) {
            if (((TreeNode)element).getIdentifiable() instanceof IInitParam) {
                IInitParam param = (IInitParam)((TreeNode)element).getIdentifiable();
                retText = MutableUtil.mutableToValue((IMutable)param.getParamName());
            } else if (((TreeNode)element).getIdentifiable() instanceof ISecurityRoleRef) {
                ISecurityRoleRef role = (ISecurityRoleRef)((TreeNode)element).getIdentifiable();
                retText = MutableUtil.mutableToValue((IMutable)role.getRoleName());
            }
        } else if (element instanceof WebObjectsTreeContentProvider.InitParamsNode) {
            retText = ((WebObjectsTreeContentProvider.InitParamsNode)element).getName();
        } else if (element instanceof WebObjectsTreeContentProvider.SecurityRoleRefNode) {
            retText = ((WebObjectsTreeContentProvider.SecurityRoleRefNode)element).getName();
        }
        return retText;
    }
}

