/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.webobjects;

import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.impl.dom.TagImpl;
import com.tssap.j2ee.model.web.dd.IInitParam;
import com.tssap.j2ee.model.web.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.Folder;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.IWebAppHolder;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsPage;
import com.tssap.util.ui.IFolder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class WebObjectsTreeContentProvider
implements ITreeContentProvider,
IWebAppHolder {
    protected static final Object[] EMPTY_OBJ_AR = new Object[0];
    private InitParamsFactory paramsFolderFactory = new InitParamsFactory();
    private SecurityRefFactory securityFolderFactory = new SecurityRefFactory(this);
    private IWebApp myWebApp;
    private Object[] topElements = new Object[]{new WebObjectsPage.FilterNode(this), new WebObjectsPage.ListenerNode(this), new WebObjectsPage.JspNode(this), new WebObjectsPage.ServletNode(this)};

    public Object[] getChildren(Object parentElement) {
        Object[] ret = EMPTY_OBJ_AR;
        if (parentElement instanceof IFolder) {
            ret = ((IFolder)parentElement).getChildren();
        } else if (parentElement instanceof IServlet) {
            IServlet servlet = (IServlet)parentElement;
            InitParamsNode initParams = this.paramsFolderFactory.getInstance(servlet);
            initParams.setServlet(servlet);
            SecurityRoleRefNode secRefs = this.securityFolderFactory.getInstance(servlet);
            secRefs.setServlet(servlet);
            ret = new Object[]{initParams, secRefs};
        } else if (parentElement instanceof InitParamsNode) {
            ArrayList paramNodesArL = ((InitParamsNode)parentElement).getTreeNodesArrayList();
            ret = paramNodesArL.toArray(new Object[paramNodesArL.size()]);
        } else if (parentElement instanceof SecurityRoleRefNode) {
            ArrayList securityNodesArL = ((SecurityRoleRefNode)parentElement).getTreeNodesArrayList();
            ret = securityNodesArL.toArray(new Object[securityNodesArL.size()]);
        }
        return ret;
    }

    public Object getParent(Object element) {
        TagImpl ret = null;
        if (element instanceof TagImpl) {
            TagImpl elementImpl = (TagImpl)element;
            ret = elementImpl.getParentTagImpl();
        } else if (element instanceof TreeNode) {
            ret = ((TreeNode)element).getFolder();
        }
        return ret;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.topElements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IWebApp) {
            this.setWebApp((IWebApp)newInput);
        }
    }

    public IWebApp getWebApp() {
        return this.myWebApp;
    }

    private void setWebApp(IWebApp webApp) {
        this.myWebApp = webApp;
    }

    public static class SecurityRoleRefNode
    implements Folder {
        IServlet servlet;
        ArrayList treeNodesArL = null;
        ArrayList roleArL = null;
        IWebApp myWebApp;

        public SecurityRoleRefNode(IWebApp myWeb) {
            this.myWebApp = myWeb;
        }

        public String getName() {
            return "security-role-ref";
        }

        private void createTreeNodes() {
            ISecurityRoleRef[] secRole = this.getServlet().getSecurityRoleRefs();
            if (this.roleArL == null) {
                this.roleArL = new ArrayList();
            }
            if (this.treeNodesArL == null) {
                this.treeNodesArL = new ArrayList();
            }
            int i = 0;
            while (i < secRole.length) {
                if (!this.roleArL.contains(secRole[i])) {
                    this.roleArL.add(secRole[i]);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setFolder((Folder)this);
                    treeNode.setIdentifiable((IIdentifiable)secRole[i]);
                    this.treeNodesArL.add(treeNode);
                }
                ++i;
            }
        }

        public IServlet getServlet() {
            return this.servlet;
        }

        public void setServlet(IServlet servlet) {
            this.servlet = servlet;
        }

        protected TreeNode getTreeNode(ISecurityRoleRef role) {
            TreeNode roleTreeNode;
            block2: {
                roleTreeNode = null;
                if (!this.roleArL.contains(role)) {
                    this.createTreeNodes();
                }
                int i = this.treeNodesArL.size() - 1;
                if (i < 0) break block2;
                if (this.treeNodesArL.get(i) != null && ((TreeNode)this.treeNodesArL.get(i)).getIdentifiable().equals(role)) {
                    roleTreeNode = (TreeNode)this.treeNodesArL.get(i);
                }
            }
            return roleTreeNode;
        }

        public ArrayList getTreeNodesArrayList() {
            this.createTreeNodes();
            return this.treeNodesArL;
        }

        public void removeTreeNode(TreeNode treeNode) {
            ((AbstractCollection)this.treeNodesArL).remove(treeNode);
        }

        public IWebApp getMyWebApp() {
            return this.myWebApp;
        }
    }

    public static class InitParamsNode
    implements Folder {
        IServlet servlet;
        ArrayList treeNodesArL = null;
        ArrayList initParamArL = null;

        public String getName() {
            return "init-parameter";
        }

        private void createTreeNodes() {
            IInitParam[] initParam = this.getServlet().getInitParams();
            if (this.initParamArL == null) {
                this.initParamArL = new ArrayList();
            }
            if (this.treeNodesArL == null) {
                this.treeNodesArL = new ArrayList();
            }
            int i = 0;
            while (i < initParam.length) {
                if (!this.initParamArL.contains(initParam[i])) {
                    this.initParamArL.add(initParam[i]);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setFolder((Folder)this);
                    treeNode.setIdentifiable((IIdentifiable)initParam[i]);
                    this.treeNodesArL.add(treeNode);
                }
                ++i;
            }
        }

        public ArrayList getTreeNodesArrayList() {
            this.createTreeNodes();
            return this.treeNodesArL;
        }

        protected TreeNode getTreeNode(IInitParam param) {
            TreeNode paramTreeNode;
            block2: {
                paramTreeNode = null;
                if (!this.initParamArL.contains(param)) {
                    this.createTreeNodes();
                }
                int i = this.treeNodesArL.size() - 1;
                if (i < 0) break block2;
                if (this.treeNodesArL.get(i) != null && ((TreeNode)this.treeNodesArL.get(i)).getIdentifiable().equals(param)) {
                    paramTreeNode = (TreeNode)this.treeNodesArL.get(i);
                }
            }
            return paramTreeNode;
        }

        public void removeTreeNode(TreeNode node) {
            ((AbstractCollection)this.treeNodesArL).remove(node);
        }

        public IServlet getServlet() {
            return this.servlet;
        }

        public void setServlet(IServlet servlet) {
            this.servlet = servlet;
        }
    }

    private class SecurityRefFactory {
        private HashMap paramsHashMap = new HashMap();
        IWebAppHolder myWebHolder;

        public SecurityRefFactory(IWebAppHolder myWebHolder) {
            this.myWebHolder = myWebHolder;
        }

        public SecurityRoleRefNode getInstance(IServlet servlet) {
            SecurityRoleRefNode ret = (SecurityRoleRefNode)this.paramsHashMap.get(servlet);
            if (ret == null) {
                if (this.myWebHolder != null) {
                    ret = new SecurityRoleRefNode(this.myWebHolder.getWebApp());
                }
                this.paramsHashMap.put(servlet, ret);
            }
            return ret;
        }
    }

    private class InitParamsFactory {
        private HashMap paramsHashMap = new HashMap();

        private InitParamsFactory() {
        }

        public InitParamsNode getInstance(IServlet servlet) {
            InitParamsNode ret = (InitParamsNode)this.paramsHashMap.get(servlet);
            if (ret == null) {
                ret = new InitParamsNode();
                this.paramsHashMap.put(servlet, ret);
            }
            return ret;
        }
    }
}

