/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.webobjects;

import com.tssap.j2ee.model.web.dd.IFilter;
import com.tssap.j2ee.model.web.dd.IInitParam;
import com.tssap.j2ee.model.web.dd.IListener;
import com.tssap.j2ee.model.web.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableFilterUI;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableListenerUI;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableParamUI;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableSecRoleRefUI;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableServletUI;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.IWebAppHolder;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsAddRemoveCallback;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsTreeContentProvider;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsTreeLabelProvider;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.DefaultTreeFolder;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class WebObjectsPage
extends WebEditorPage
implements IModifiedCallback {
    private static final int NUM_OF_COLS = 1;
    private static final String PAGE_NAME = "Web Objects";
    private TreeSelectorEditorComponent treeEditor;

    public WebObjectsPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.getTreeSelector().setTreeInput((Object)webApp);
        InnerReusableManager.webApp = webApp;
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.getTreeEditor().aboutToLeave();
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected Control createControls(IGridLayoutPane grid) {
        TreeSelector treeSelector = new TreeSelector();
        this.treeEditor = new TreeSelectorEditorComponent(treeSelector);
        this.setTreeEditor(this.treeEditor);
        if (treeSelector != null) {
            treeSelector.setSplitterWeight(2);
        }
        treeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        WebObjectsTreeContentProvider cp = new WebObjectsTreeContentProvider();
        this.treeEditor.setTreeContentProvider((ITreeContentProvider)cp);
        this.treeEditor.setTreeLabelProvider((ILabelProvider)new WebObjectsTreeLabelProvider());
        this.treeEditor.setAddRemoveCallback((IAddRemoveCallback)new WebObjectsAddRemoveCallback(this.getUnderlyingFile().getProject(), cp));
        this.treeEditor.setReusableManager((IReuseableManager)new InnerReusableManager());
        this.treeEditor.setModifiedCallback((IModifiedCallback)this);
    }

    private TreeSelectorEditorComponent getTreeEditor() {
        return this.treeEditor;
    }

    private TreeSelector getTreeSelector() {
        return this.getTreeEditor().getTreeSelector();
    }

    private void setTreeEditor(TreeSelectorEditorComponent treeEditor) {
        this.treeEditor = treeEditor;
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeItem[] selectedItems = this.getTreeSelector().getTreeViewer().getTree().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            TreeItem selectedItem = selectedItems[i];
            this.getTreeSelector().getTreeViewer().refresh(selectedItem.getData(), true);
            ++i;
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.treeEditor != null) {
            this.treeEditor.setEditable(editable);
        }
    }

    private static class InnerReusableManager
    implements IReuseableManager {
        public static IWebApp webApp = null;

        private InnerReusableManager() {
        }

        public IReuseable getReusable(Object obj) {
            if (obj instanceof IServlet) {
                return new ReusableServletUI(webApp);
            }
            if (obj instanceof IFilter) {
                return new ReusableFilterUI();
            }
            if (obj instanceof IListener) {
                return new ReusableListenerUI();
            }
            if (obj instanceof TreeNode) {
                if (((TreeNode)obj).getIdentifiable() instanceof IInitParam) {
                    return new ReusableParamUI();
                }
                if (((TreeNode)obj).getIdentifiable() instanceof ISecurityRoleRef) {
                    return new ReusableSecRoleRefUI();
                }
            }
            return null;
        }
    }

    public static class JspNode
    extends FolderNode {
        public JspNode(IWebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String getName() {
            return "JSPs" + this.getNameAddition();
        }

        public Object[] getChildren() {
            Object[] ret = super.getChildren();
            if (this.getWebApp() != null) {
                IServlet[] servlets = this.getWebApp().getServlets();
                ArrayList<IServlet> realJspList = new ArrayList<IServlet>();
                int s = 0;
                while (s < servlets.length) {
                    IServlet iServlet = servlets[s];
                    if (iServlet.getJspFile() != null) {
                        realJspList.add(iServlet);
                    }
                    ++s;
                }
                ret = realJspList.toArray(new IServlet[0]);
            }
            return ret;
        }
    }

    public static class ServletNode
    extends FolderNode {
        public ServletNode(IWebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String getName() {
            return "Servlets" + this.getNameAddition();
        }

        public Object[] getChildren() {
            Object[] ret = super.getChildren();
            if (this.getWebApp() != null) {
                IServlet[] servlets = this.getWebApp().getServlets();
                ArrayList<IServlet> realServletList = new ArrayList<IServlet>();
                int s = 0;
                while (s < servlets.length) {
                    IServlet iServlet = servlets[s];
                    if (iServlet.getServletClass() != null) {
                        realServletList.add(iServlet);
                    }
                    ++s;
                }
                ret = realServletList.toArray(new IServlet[0]);
            }
            return ret;
        }
    }

    public static class ListenerNode
    extends FolderNode {
        public ListenerNode(IWebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String getName() {
            return "Listeners" + this.getNameAddition();
        }

        public Object[] getChildren() {
            Object[] ret = super.getChildren();
            if (this.getWebApp() != null) {
                ret = this.getWebApp().getListeners();
            }
            return ret;
        }
    }

    public static class FilterNode
    extends FolderNode {
        public FilterNode(IWebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String getName() {
            return "Filters" + this.getNameAddition();
        }

        public Object[] getChildren() {
            Object[] ret = super.getChildren();
            if (this.getWebApp() != null) {
                ret = this.getWebApp().getFilters();
            }
            return ret;
        }
    }

    public static abstract class FolderNode
    extends DefaultTreeFolder {
        private IWebAppHolder webAppHolder;

        public FolderNode(IWebAppHolder webAppHolder) {
            this.setWebAppHolder(webAppHolder);
        }

        public FolderNode() {
        }

        protected IWebApp getWebApp() {
            IWebApp ret = null;
            if (this.getWebAppHolder() != null) {
                ret = this.getWebAppHolder().getWebApp();
            }
            return ret;
        }

        protected String getNameAddition() {
            String ret = "";
            if (this.getWebApp() != null) {
                int childCount = this.getChildren().length;
                ret = ret + " (" + childCount + ")";
            }
            return ret;
        }

        private IWebAppHolder getWebAppHolder() {
            return this.webAppHolder;
        }

        private void setWebAppHolder(IWebAppHolder webAppHolder) {
            this.webAppHolder = webAppHolder;
        }
    }
}

