/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.webobjects;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.model.web.dd.IFilter;
import com.tssap.j2ee.model.web.dd.IInitParam;
import com.tssap.j2ee.model.web.dd.IListener;
import com.tssap.j2ee.model.web.dd.IParamName;
import com.tssap.j2ee.model.web.dd.IParamValue;
import com.tssap.j2ee.model.web.dd.IRoleName;
import com.tssap.j2ee.model.web.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.IWebAppHolder;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsTreeContentProvider;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import org.eclipse.core.resources.IProject;

public class WebObjectsAddRemoveCallback
implements IAddRemoveCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$webobjects$WebObjectsAddRemoveCallback == null ? (class$com$tssap$j2ee$ui$web$editor$internal$webobjects$WebObjectsAddRemoveCallback = WebObjectsAddRemoveCallback.class$("com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsAddRemoveCallback")) : class$com$tssap$j2ee$ui$web$editor$internal$webobjects$WebObjectsAddRemoveCallback));
    private IProject project;
    private IWebAppHolder webAppHolder;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$webobjects$WebObjectsAddRemoveCallback;

    public WebObjectsAddRemoveCallback(IProject project, IWebAppHolder webAppHolder) {
        this.project = project;
        this.webAppHolder = webAppHolder;
    }

    public boolean canAddElement(Object currentSelection) {
        boolean flag = false;
        if (currentSelection instanceof WebObjectsTreeContentProvider.InitParamsNode) {
            flag = true;
        } else if (currentSelection instanceof WebObjectsTreeContentProvider.SecurityRoleRefNode) {
            flag = true;
        }
        return flag;
    }

    public Object addElement(Object currentSelection) {
        IServlet servlet;
        TreeNode obj = null;
        IWebModule webAppPrj = J2eeProjectManager.getWebModule((String)this.project.getName());
        boolean isDC = J2eeProjectManager.isComponentProject((IJ2eeProject)webAppPrj);
        if (currentSelection instanceof WebObjectsTreeContentProvider.InitParamsNode) {
            IServlet servlet2 = ((WebObjectsTreeContentProvider.InitParamsNode)currentSelection).getServlet();
            if (servlet2 != null) {
                try {
                    WebObjectsTreeContentProvider.InitParamsNode node = (WebObjectsTreeContentProvider.InitParamsNode)currentSelection;
                    IInitParam initParam = servlet2.createInitParam(null);
                    IParamName name = initParam.createParamName(null);
                    name.setValue("<specify init parameter name>");
                    IParamValue value = initParam.createParamValue(null);
                    value.setValue("<specify init parameter value>");
                    obj = node.getTreeNode(initParam);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("Tags <description>, <role-name> and/or <role-link> could not be created.", e);
                }
            }
        } else if (currentSelection instanceof WebObjectsTreeContentProvider.SecurityRoleRefNode && (servlet = ((WebObjectsTreeContentProvider.SecurityRoleRefNode)currentSelection).getServlet()) != null) {
            try {
                WebObjectsTreeContentProvider.SecurityRoleRefNode node = (WebObjectsTreeContentProvider.SecurityRoleRefNode)currentSelection;
                ISecurityRoleRef ref = servlet.createSecurityRoleRef(null);
                IRoleName roleName = ref.createRoleName(null);
                roleName.setValue("<...>");
                obj = node.getTreeNode(ref);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("Tags <description>, <role-name> and/or <role-link> could not be created.", e);
            }
        }
        return obj;
    }

    public boolean canRemoveElement(Object currentSelection) {
        boolean ret = false;
        if (currentSelection instanceof TreeNode) {
            ret = true;
        }
        return ret;
    }

    public boolean removeElement(Object currentSelection) {
        boolean ret = false;
        if (currentSelection == null) {
            return ret;
        }
        IWebApp webApp = this.webAppHolder.getWebApp();
        if (currentSelection instanceof TreeNode) {
            if (((TreeNode)currentSelection).getIdentifiable() instanceof IInitParam) {
                IServlet servlet = ((WebObjectsTreeContentProvider.InitParamsNode)((TreeNode)currentSelection).getFolder()).getServlet();
                IInitParam param = (IInitParam)((TreeNode)currentSelection).getIdentifiable();
                servlet.removeInitParam(param);
                ((TreeNode)currentSelection).getFolder().removeTreeNode((TreeNode)currentSelection);
                ret = true;
            } else if (((TreeNode)currentSelection).getIdentifiable() instanceof ISecurityRoleRef) {
                IServlet servlet = ((WebObjectsTreeContentProvider.SecurityRoleRefNode)((TreeNode)currentSelection).getFolder()).getServlet();
                ISecurityRoleRef ref = (ISecurityRoleRef)((TreeNode)currentSelection).getIdentifiable();
                servlet.removeSecurityRoleRef(ref);
                ((TreeNode)currentSelection).getFolder().removeTreeNode((TreeNode)currentSelection);
                ret = true;
            }
        }
        return ret;
    }

    private void addWebSourceToModel(IWebSource[] ws) {
        IWebApp webApp = this.webAppHolder.getWebApp();
        int i = 0;
        while (i < ws.length) {
            if (ws[i] instanceof IServerSource) {
                this.addServerSource((IServerSource)ws[i], webApp);
            } else if (ws[i] instanceof IClientSource) {
                this.addClientSource((IClientSource)ws[i], webApp);
            }
            ++i;
        }
    }

    private void addServerSource(IServerSource serverSource, IWebApp webApp) {
        String name = serverSource.getName();
        String className = serverSource.getIType().getFullyQualifiedName();
        try {
            switch (serverSource.getType()) {
                case 3: {
                    IServlet servlet = webApp.createServlet(null);
                    servlet.createServletName(null).setValue(name);
                    servlet.createServletClass(null).setValue(className);
                    break;
                }
                case 1: {
                    IFilter filter = webApp.createFilter(null);
                    filter.createFilterName(null).setValue(name);
                    filter.createFilterClass(null).setValue(className);
                    break;
                }
                case 2: {
                    IListener listener = webApp.createListener(null);
                    listener.createListenerClass(null).setValue(className);
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "addServerSource(serverSource, webApp)", " Error: Illegal Argument provided (serverSource - type). ");
                    break;
                }
            }
        }
        catch (J2eeCreateException e) {
            this.handleJ2eeCreateException("Tag <listener>, <filter> or <servlet> could not be created.", e);
        }
    }

    private void addClientSource(IClientSource clientSource, IWebApp webApp) {
        if (clientSource.getType() == 10) {
            String name = clientSource.getFile().getName();
            String jspFile = clientSource.getFile().getProjectRelativePath().toString();
            try {
                IServlet servlet = webApp.createServlet(null);
                servlet.createServletName(null).setValue(name);
                servlet.createJspFile(null).setValue(jspFile);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("Tag <servlet> could not be created.", e);
            }
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(this.getClass() + " Error: " + msg + ". " + e.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

