/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.ISecurityConstraint;
import com.tssap.j2ee.model.web.dd.IWebResourceCollection;
import com.tssap.j2ee.ui.web.editor.internal.WebResourceCollectionWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class WebResourceCollectionEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$WebResourceCollectionEditorComponent == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$WebResourceCollectionEditorComponent = WebResourceCollectionEditorComponent.class$("com.tssap.j2ee.ui.web.editor.internal.ui.WebResourceCollectionEditorComponent")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$WebResourceCollectionEditorComponent));
    private IModifiedCallback myModifyCallback;
    private Text webResourceNameField;
    private Text descriptionField;
    private IWebResourceCollection webResourceCollection;
    private final String WEB_RESOURCE_NAME = "Web Resource Name";
    private ISecurityConstraint securityConstraint;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$WebResourceCollectionEditorComponent;

    public WebResourceCollectionEditorComponent(ISecurityConstraint securityConstraint) {
        this.securityConstraint = securityConstraint;
    }

    public WebResourceCollectionEditorComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        if (this.webResourceCollection != null) {
            if (this.webResourceCollection.getWebResourceName() != null && this.getWebResourceNameField() != null) {
                this.getWebResourceNameField().setText(this.webResourceCollection.getWebResourceName().getValue());
            }
            if (this.webResourceCollection.getDescription() != null && this.getDescriptionField() != null) {
                this.getDescriptionField().setText(this.webResourceCollection.getDescription().getValue());
            }
        }
        this.stopRefreshingUI();
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        this.webResourceCollection = (IWebResourceCollection)this.getData();
        if (this.webResourceCollection != null) {
            this.refreshResourceNameFromUI();
            if (this.getDescriptionField() != null && !this.getDescriptionField().getText().trim().equals("")) {
                if (this.webResourceCollection.getDescription() == null) {
                    try {
                        this.webResourceCollection.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> for <web-resource-collection> could not be created.", e);
                    }
                }
                this.webResourceCollection.getDescription().setValue(this.getDescriptionField().getText().trim());
            }
        }
    }

    private void refreshResourceNameFromUI() {
        this.webResourceCollection = (IWebResourceCollection)this.getData();
        if (this.getWebResourceNameField() != null && !this.getWebResourceNameField().getText().trim().equals("")) {
            this.webResourceCollection.getWebResourceName().setValue(this.getWebResourceNameField().getText().trim());
        }
    }

    public void setData(Object data) {
        if (!(data instanceof WebResourceCollectionWrapper)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof IWebResourceCollection");
        }
        this.webResourceCollection = ((WebResourceCollectionWrapper)data).getWebResourceCollection();
    }

    public Object getData() {
        return this.webResourceCollection;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        return null;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Web Resource Name", userArea.createGridLayoutData(4, 4, true, false));
        this.webResourceNameField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false));
        userArea.addTextLabel("Description", userArea.createGridLayoutData(4, 4, true, false));
        this.descriptionField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, true));
        this.setWebResourceNameField(this.webResourceNameField);
        this.setDescriptionField(this.descriptionField);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionField().addModifyListener(this.getModifyAdapterSingleton());
        this.getWebResourceNameField().addModifyListener((ModifyListener)new WebResourceNameModifyAdapter());
    }

    protected void handleResourceNameEvent() {
        this.refreshResourceNameFromUI();
        super.handleEvent();
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private Text getDescriptionField() {
        return this.descriptionField;
    }

    private Text getWebResourceNameField() {
        return this.webResourceNameField;
    }

    private void setDescriptionField(Text text) {
        this.descriptionField = text;
    }

    private void setWebResourceNameField(Text text) {
        this.webResourceNameField = text;
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WebResourceNameModifyAdapter
    implements ModifyListener {
        private WebResourceNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            WebResourceCollectionEditorComponent.this.handleResourceNameEvent();
        }
    }
}

