/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IServletMapping;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.widgets.Text;

public class ServletMappingEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$ServletMappingEditorComponent == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$ServletMappingEditorComponent = ServletMappingEditorComponent.class$("com.tssap.j2ee.ui.web.editor.internal.ui.ServletMappingEditorComponent")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$ServletMappingEditorComponent));
    private IModifiedCallback myModifyCallback;
    private IServletMapping servletMapping;
    private Text servletNameTextfield;
    private Text urlPatternTextField;
    private IWebApp webApp;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$ServletMappingEditorComponent;

    public ServletMappingEditorComponent(IWebApp webApp) {
        this.webApp = webApp;
    }

    public ServletMappingEditorComponent(String title) {
        super(title);
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Servlet Name ");
        this.servletNameTextfield = userArea.addTextField(true, userArea.createGridLayoutData(4, 4, true, false));
        userArea.addTextLabel("URL Pattern");
        this.urlPatternTextField = userArea.addTextField(false, userArea.createGridLayoutData(4, 4, true, false));
        this.setServletNameTextfield(this.servletNameTextfield);
        this.setUrlPatternTextField(this.urlPatternTextField);
        this.getUrlPatternTextField().addModifyListener(this.getModifyAdapterSingleton());
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        if ((IServletMapping)this.getData() != null && !this.getUrlPatternTextField().getText().trim().equals("")) {
            if (((IServletMapping)this.getData()).getUrlPattern() == null) {
                try {
                    ((IServletMapping)this.getData()).createUrlPattern(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<url-pattern> could not be created.", e);
                }
            }
            ((IServletMapping)this.getData()).getUrlPattern().setValue(this.getUrlPatternTextField().getText().trim());
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        if (this.getData() instanceof IServletMapping) {
            this.servletMapping = (IServletMapping)this.getData();
            if (this.servletMapping != null) {
                this.getServletNameTextfield().setText(this.servletMapping.getServletName().getValue());
                this.getUrlPatternTextField().setText(this.servletMapping.getUrlPattern().getValue());
            }
        }
        this.stopRefreshingUI();
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private Text getServletNameTextfield() {
        return this.servletNameTextfield;
    }

    private Text getUrlPatternTextField() {
        return this.urlPatternTextField;
    }

    public void setServletNameTextfield(Text text) {
        this.servletNameTextfield = text;
    }

    public void setUrlPatternTextField(Text text) {
        this.urlPatternTextField = text;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getServletNameTextfield() != null) {
            this.getServletNameTextfield().setEditable(false);
        }
    }

    public Object getData() {
        return this.servletMapping;
    }

    public void setData(Object data) {
        if (!(data instanceof IServletMapping)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof IServletMapping");
        }
        this.servletMapping = (IServletMapping)data;
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getUrlPatternTextField().getText().equals("")) {
            status.setError("Please assign a value to URL Pattern.");
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

