/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.ICreateMutableCallback;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.web.dd.IAuthConstraint;
import com.tssap.j2ee.model.web.dd.IHttpMethod;
import com.tssap.j2ee.model.web.dd.IRoleName;
import com.tssap.j2ee.model.web.dd.ISecurityConstraint;
import com.tssap.j2ee.model.web.dd.IUrlPattern;
import com.tssap.j2ee.model.web.dd.IUserDataConstraint;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.model.web.dd.IWebResourceCollection;
import com.tssap.j2ee.ui.Folder;
import com.tssap.j2ee.ui.SecurityRolesDialog;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.web.editor.internal.BaseFolder;
import com.tssap.j2ee.ui.web.editor.internal.SecurityConstraintsReuseableManager;
import com.tssap.j2ee.ui.web.editor.internal.WebResourceCollectionTreeCP;
import com.tssap.j2ee.ui.web.editor.internal.WebResourceCollectionWrapper;
import com.tssap.j2ee.ui.web.editor.internal.WebSecurityConstraintsWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.list.IListElement;
import com.tssap.util.ui.reuse.list.IListSelectorCallback;
import com.tssap.util.ui.reuse.list.ListComponent;
import com.tssap.util.ui.reuse.list.ListElement;
import com.tssap.util.ui.reuse.list.ListSelectorCallback;
import com.tssap.util.ui.reuse.text.AbstractTextAdapter;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class SecurityConstraintEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$SecurityConstraintEditorComponent == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$SecurityConstraintEditorComponent = SecurityConstraintEditorComponent.class$("com.tssap.j2ee.ui.web.editor.internal.ui.SecurityConstraintEditorComponent")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$SecurityConstraintEditorComponent));
    private ISecurityConstraint currentSecurityConstraint;
    private IModifiedCallback callback;
    private Text displayNameTextField;
    private Combo transportGuaranteeCombo;
    private Text descriptionTextPane;
    private Text authConstraintDescriptionTextField;
    private TransportGuaranteeComboAdapter transpGuaranteeAdapter;
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private WebResourceCollectionTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    private IResourceChooserCallback myResourceChooserCallback;
    private ListComponent roleNamesListComponent;
    private InnerRoleNamesAdapter roleNamesAdapter;
    private IWebResourceCollection webResourceCollection;
    private static final String DEFAULT_TEXT_ROLE_NAME = "new role name";
    private static final String DEFAULT_TEXT_URL_PATTERN = "new url pattern";
    private static final String DEFAULT_TEXT_HTTP_METHOD = "new http method";
    private static final List possibleTranspGuaranteeArl = new ArrayList();
    private IWebApp webApp = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$SecurityConstraintEditorComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper;

    public SecurityConstraintEditorComponent(IWebApp webApp) {
        this.webApp = webApp;
    }

    public SecurityConstraintEditorComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        ISecurityConstraint securityConstraint = (ISecurityConstraint)this.getData();
        if (securityConstraint != null) {
            if (this.getDisplayNameTextField() != null && securityConstraint.getDisplayName() != null) {
                this.getDisplayNameTextField().setText(securityConstraint.getDisplayName().getValue());
            }
            if (securityConstraint.getUserDataConstraint() != null) {
                if (securityConstraint.getUserDataConstraint().getDescription() != null && this.getDescriptionTextPane() != null) {
                    this.getDescriptionTextPane().setText(securityConstraint.getUserDataConstraint().getDescription().getValue());
                }
                if (securityConstraint.getUserDataConstraint().getTransportGuarantee() != null && this.getTransportGuaranteeCombo() != null) {
                    this.getTransportGuaranteeCombo().setText(securityConstraint.getUserDataConstraint().getTransportGuarantee().getValue());
                }
            }
            if (securityConstraint.getWebResourceCollections() != null && securityConstraint.getWebResourceCollections().length > 0) {
                this.myTreeSelector.setTreeInput((Object)securityConstraint);
            }
            if (securityConstraint.getAuthConstraint() != null) {
                if (securityConstraint.getAuthConstraint().getDescription() != null && this.getAuthConstraintDescriptionTextField() != null) {
                    this.getAuthConstraintDescriptionTextField().setText(securityConstraint.getAuthConstraint().getDescription().getValue());
                }
                if (securityConstraint.getAuthConstraint().getRoleNames() != null && securityConstraint.getAuthConstraint().getRoleNames().length > 0 && this.getRoleNamesListComponent() != null) {
                    this.getRoleNamesListComponent().getList().removeAll();
                    IRoleName[] roleNames = securityConstraint.getAuthConstraint().getRoleNames();
                    ListElement[] listElements = new ListElement[roleNames.length];
                    int i = 0;
                    while (i < roleNames.length) {
                        String roleName = roleNames[i] != null ? roleNames[i].getValue() : "";
                        listElements[i] = new ListElement(roleName, (Object)roleNames[i]);
                        ++i;
                    }
                    if (listElements.length > 0) {
                        this.getRoleNamesListComponent().setElements((IListElement[])listElements);
                        this.getRoleNamesListComponent().setSelection(0);
                    }
                }
            }
        }
        this.stopRefreshingUI();
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        if (this.getData() != null && this.getData() instanceof ISecurityConstraint) {
            ISecurityConstraint securityConstraint = (ISecurityConstraint)this.getData();
            this.refreshDisplayNameFromUI();
            IUserDataConstraint userDataConstraint = ((ISecurityConstraint)this.getData()).getUserDataConstraint();
            if (this.getTransportGuaranteeCombo().getText() != null && !this.getTransportGuaranteeCombo().getText().trim().equals("")) {
                if (userDataConstraint == null) {
                    try {
                        userDataConstraint = ((ISecurityConstraint)this.getData()).createUserDataConstraint(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<user-data-constraint> could not be created.", e);
                    }
                }
                if (userDataConstraint.getTransportGuarantee() == null) {
                    try {
                        userDataConstraint.createTransportGuarantee(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<transport-guarantee> could not be created.", e);
                    }
                }
                userDataConstraint.getTransportGuarantee().setValue(this.getTransportGuaranteeCombo().getText().trim());
            } else if (userDataConstraint != null) {
                securityConstraint.removeUserDataConstraint();
            }
            if (userDataConstraint != null) {
                if (this.getDescriptionTextPane().getText() != null && !this.getDescriptionTextPane().getText().trim().equals("")) {
                    if (userDataConstraint.getDescription() == null) {
                        try {
                            userDataConstraint.createDescription(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("user data constraint <description> could not be created.", e);
                        }
                    }
                    userDataConstraint.getDescription().setValue(this.getDescriptionTextPane().getText().trim());
                } else if (userDataConstraint.getDescription() != null) {
                    userDataConstraint.removeDescription();
                }
            }
            if (!this.getAuthConstraintDescriptionTextField().getText().trim().equals("") || this.getRoleNamesListComponent().getElements() != null && this.getRoleNamesListComponent().getElements().length > 0) {
                IAuthConstraint authConstraint = securityConstraint.getAuthConstraint();
                if (authConstraint == null) {
                    try {
                        authConstraint = securityConstraint.createAuthConstraint(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<auth-constraint> could not be created.", e);
                    }
                }
                if (!this.getAuthConstraintDescriptionTextField().getText().equals("")) {
                    if (authConstraint.getDescription() == null) {
                        try {
                            authConstraint.createDescription(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<description> could not be created.", e);
                        }
                    }
                    authConstraint.getDescription().setValue(this.getAuthConstraintDescriptionTextField().getText().trim());
                }
            }
        }
    }

    private void refreshDisplayNameFromUI() {
        ISecurityConstraint securityConstraint = (ISecurityConstraint)this.getData();
        if (this.getDisplayNameTextField().getText() != null && !this.getDisplayNameTextField().getText().trim().equals("")) {
            if (securityConstraint.getDisplayName() == null) {
                try {
                    securityConstraint.createDisplayName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<display-name> could not be created.", e);
                }
            }
            securityConstraint.getDisplayName().setValue(this.getDisplayNameTextField().getText().trim());
        } else if (securityConstraint.getDisplayName() != null) {
            securityConstraint.removeDisplayName();
        }
    }

    public void setData(Object data) {
        ISecurityConstraint contentData = null;
        if (data instanceof WebSecurityConstraintsWrapper) {
            contentData = ((WebSecurityConstraintsWrapper)data).getSecurityConstraint();
            this.webApp = ((WebSecurityConstraintsWrapper)data).getWebApp();
            if (contentData instanceof ISecurityConstraint) {
                this.currentSecurityConstraint = contentData;
                this.myTreeEditor.setTreeInput(this.getData());
            }
        } else if (data instanceof WebResourceCollectionWrapper) {
            contentData = ((WebResourceCollectionWrapper)data).getWebResourceCollection();
            this.currentSecurityConstraint = ((WebResourceCollectionWrapper)data).getSecurityConstraint();
            if (contentData instanceof IWebResourceCollection) {
                this.webResourceCollection = (IWebResourceCollection)contentData;
            }
        } else {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper = SecurityConstraintEditorComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper).getName());
        }
    }

    public Object getData() {
        return this.currentSecurityConstraint;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.callback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.callback;
    }

    public String okToLeave() {
        String message = null;
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        return status;
    }

    public void initContainer(IGridLayoutPane userArea) {
        ITabbedPane tabbedPane = userArea.addTabbedPane(userArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane generalTab = tabbedPane.addGridLayoutPaneAsTab("General", 1);
        generalTab.addTextLabel("Display Name");
        this.displayNameTextField = generalTab.addTextField("", generalTab.createGridLayoutData(4, 1, true, false));
        IGridLayoutPane userDataConstraintGroup = generalTab.addGridLayoutPane("User Data Constraint", 1, generalTab.createGridLayoutData(4, 4, true, true));
        String[] transpGuaranteeTypes = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
        possibleTranspGuaranteeArl.add(transpGuaranteeTypes[0]);
        possibleTranspGuaranteeArl.add(transpGuaranteeTypes[1]);
        possibleTranspGuaranteeArl.add(transpGuaranteeTypes[2]);
        userDataConstraintGroup.addTextLabel("Transport Guarantee");
        this.transportGuaranteeCombo = userDataConstraintGroup.addComboBox(transpGuaranteeTypes, "", true, userDataConstraintGroup.createGridLayoutData(4, 4, true, false, 1, 1));
        this.transpGuaranteeAdapter = new TransportGuaranteeComboAdapter();
        this.setTranspGuaranteeAdapter(this.transpGuaranteeAdapter);
        this.setTransportGuaranteeCombo(this.transportGuaranteeCombo);
        userDataConstraintGroup.addTextLabel("Description");
        this.descriptionTextPane = userDataConstraintGroup.addTextPane("", false, userDataConstraintGroup.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane webResourceCollectionTab = tabbedPane.addGridLayoutPaneAsTab("Web Resource Collection", 10);
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(1);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeContentProvider = new WebResourceCollectionTreeCP();
        this.myAddRemoveCallback = new WebResourceAddRemoveCallback();
        this.myTreeSelector.createPartControl(webResourceCollectionTab);
        IGridLayoutPane authConstraintTab = tabbedPane.addGridLayoutPaneAsTab("Auth Constraint", 1);
        authConstraintTab.addTextLabel("Description");
        this.authConstraintDescriptionTextField = authConstraintTab.addTextPane("", false, authConstraintTab.createGridLayoutData(4, 4, true, true));
        authConstraintTab.addTextLabel("Role Names", authConstraintTab.createGridLayoutData(4, 4, false, false, 2, 1));
        InnerRoleNamesAdapter roleNamesAdapter = new InnerRoleNamesAdapter();
        this.setRoleNamesListComponent(new ListComponent((IListSelectorCallback)roleNamesAdapter));
        this.setRoleNamesAdapter(roleNamesAdapter);
        this.getRoleNamesListComponent().createPartControl(authConstraintTab);
        this.decorateControls();
    }

    private void decorateControls() {
        this.myTreeEditor.setReusableManager((IReuseableManager)new SecurityConstraintsReuseableManager());
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.getAuthConstraintDescriptionTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getTransportGuaranteeCombo().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getDisplayNameTextField().addModifyListener((ModifyListener)new DisplayNameModifyAdapter());
        this.getRoleNamesListComponent().addModifyListener(this.getModifyAdapterSingleton());
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    protected void handleDisplayNameEvent() {
        this.refreshDisplayNameFromUI();
        super.handleEvent();
    }

    private TransportGuaranteeComboAdapter getTranspGuaranteeAdapter() {
        return this.transpGuaranteeAdapter;
    }

    private void setTranspGuaranteeAdapter(TransportGuaranteeComboAdapter adapter) {
        this.transpGuaranteeAdapter = adapter;
    }

    private Combo getTransportGuaranteeCombo() {
        return this.transportGuaranteeCombo;
    }

    private void setTransportGuaranteeCombo(Combo combo) {
        this.transportGuaranteeCombo = combo;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private IWebApp getWebApp() {
        return this.webApp;
    }

    private void setRoleNamesListComponent(ListComponent component) {
        this.roleNamesListComponent = component;
    }

    private ListComponent getRoleNamesListComponent() {
        return this.roleNamesListComponent;
    }

    private InnerRoleNamesAdapter getRoleNamesAdapter() {
        return this.roleNamesAdapter;
    }

    private void setRoleNamesAdapter(InnerRoleNamesAdapter adapter) {
        this.roleNamesAdapter = adapter;
    }

    private Text getAuthConstraintDescriptionTextField() {
        return this.authConstraintDescriptionTextField;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private Text getDisplayNameTextField() {
        return this.displayNameTextField;
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(this.isEditable());
        }
        if (this.getRoleNamesListComponent() != null) {
            this.getRoleNamesListComponent().setEditable(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        MySelectionConverter() {
        }

        public Object convertSelection(Object selectedObject) {
            ISecurityConstraint securityConstraint = null;
            if (selectedObject instanceof IWebResourceCollection) {
                securityConstraint = (ISecurityConstraint)SecurityConstraintEditorComponent.this.getData();
                return new WebResourceCollectionWrapper(securityConstraint, (IWebResourceCollection)selectedObject);
            }
            if (selectedObject instanceof WebResourceCollectionTreeCP.HttpMethodFolder || selectedObject instanceof WebResourceCollectionTreeCP.HttpMethodFolder) {
                return ((WebResourceCollectionTreeCP.HttpMethodFolder)selectedObject).getWebResourceCollection();
            }
            if (selectedObject instanceof TreeNode) {
                return ((TreeNode)selectedObject).getIdentifiable();
            }
            return null;
        }
    }

    private class HttpMethodsDialog {
        IWebResourceCollection webResourceCollection;

        public HttpMethodsDialog(IWebResourceCollection webResourceCollection) {
            this.webResourceCollection = webResourceCollection;
        }

        public Object[] getHttpMethodsFromSelectionDialog(boolean isSingleSelection) {
            String message = "";
            Object[] selectedHttpMethods = null;
            Object[] resultSelections = null;
            Object[] httpMethods = new String[]{"GET", "POST", "TRACE", "DELETE", "CONNECT", "PUT", "HEAD", "OPTIONS"};
            Shell shell = new Shell();
            ObjectSelectionDialog selectionDialog = new ObjectSelectionDialog(shell, "Choose HTTP methods", message);
            Object[] selectedElements = this.getReferencedHttpMethods();
            selectionDialog.setInitialSelections(selectedElements);
            selectionDialog.setSingleSelection(isSingleSelection);
            selectionDialog.setLabelProvider((ILabelProvider)new J2eeModelLabelProvider());
            selectedHttpMethods = selectionDialog.openDialog(httpMethods);
            if (selectedHttpMethods != null) {
                resultSelections = selectedHttpMethods;
            }
            return resultSelections;
        }

        private String[] getReferencedHttpMethods() {
            String[] selectedElements = null;
            if (this.webResourceCollection != null) {
                IHttpMethod[] httpMethods = this.webResourceCollection.getHttpMethods();
                selectedElements = new String[httpMethods.length];
                int i = 0;
                while (i < httpMethods.length) {
                    selectedElements[i] = httpMethods[i].getValue();
                    ++i;
                }
            }
            return selectedElements;
        }
    }

    private class InnerRoleNamesAdapter
    extends ListSelectorCallback {
        IAuthConstraint authConstraint = null;

        private InnerRoleNamesAdapter() {
        }

        public void elementAdded(IListElement element) {
        }

        public void elementRemoved(IListElement element) {
            this.authConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getAuthConstraint();
            if (this.authConstraint != null && element != null && element.getUserObject() instanceof IRoleName) {
                IRoleName roleName = (IRoleName)element.getUserObject();
                this.authConstraint.removeRoleName(roleName);
            }
            SecurityConstraintEditorComponent.this.dataModified(true);
        }

        public IListElement[] getNewElements() {
            ListElement[] ret = new ListElement[]{};
            this.authConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getAuthConstraint();
            SecurityRolesDialog securityRolesDialog = new SecurityRolesDialog(SecurityConstraintEditorComponent.this.getWebApp());
            Object[] resultSelections = securityRolesDialog.getRoleNamesFromSelectionDialog(false);
            IRoleName[] roleNameArr = null;
            if (this.authConstraint != null) {
                roleNameArr = this.authConstraint.getRoleNames();
            }
            ArrayList<Object> resultSelectionArL = new ArrayList<Object>();
            String selectedRoleName = null;
            if (resultSelections != null) {
                int i = 0;
                while (i < resultSelections.length) {
                    selectedRoleName = resultSelections[i].toString();
                    boolean roleNameExists = false;
                    if (roleNameArr != null && roleNameArr.length > 0) {
                        int j = 0;
                        while (j < roleNameArr.length && !roleNameExists) {
                            if (roleNameArr[j].getValue().equals(selectedRoleName)) {
                                roleNameExists = true;
                            }
                            ++j;
                        }
                    }
                    if (!roleNameExists) {
                        resultSelectionArL.add(resultSelections[i]);
                    }
                    ++i;
                }
                ret = new ListElement[resultSelectionArL.size()];
                resultSelections = resultSelectionArL.toArray();
                int i2 = 0;
                while (i2 < resultSelections.length) {
                    selectedRoleName = resultSelections[i2].toString();
                    ret[i2] = new ListElement(selectedRoleName);
                    if (SecurityConstraintEditorComponent.this.getData() != null && SecurityConstraintEditorComponent.this.getData() instanceof ISecurityConstraint) {
                        try {
                            if (((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getAuthConstraint() == null) {
                                ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).createAuthConstraint(null);
                            }
                        }
                        catch (J2eeCreateException ex) {
                            SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<auth-constraint> could not be created.", ex);
                        }
                        this.authConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getAuthConstraint();
                        if (this.authConstraint != null) {
                            IRoleName newRoleName = null;
                            try {
                                newRoleName = this.authConstraint.createRoleName(null);
                            }
                            catch (J2eeCreateException e) {
                                SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<role-name> could not be created.", e);
                            }
                            newRoleName.setValue(selectedRoleName);
                            ret[i2].setUserObject((Object)newRoleName);
                        }
                    }
                    ++i2;
                }
                SecurityConstraintEditorComponent.this.dataModified(true);
            }
            return ret;
        }
    }

    private class WebResourceAddRemoveCallback
    implements IAddRemoveCallback {
        private final String PREFIX = "WebResource";

        private WebResourceAddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            IWebResourceCollection ret = null;
            Object parent = SecurityConstraintEditorComponent.this.myTreeContentProvider.getParent(currentSelection);
            IWebResourceCollection webResourceCollection = null;
            ISecurityConstraint securityConstraint = null;
            if (currentSelection instanceof WebResourceCollectionTreeCP.WebResourceCollectionFolder) {
                securityConstraint = (ISecurityConstraint)SecurityConstraintEditorComponent.this.getData();
                ret = this.createWebResourceCollection(securityConstraint);
            } else if (currentSelection instanceof IWebResourceCollection) {
                securityConstraint = (ISecurityConstraint)SecurityConstraintEditorComponent.this.getData();
                ret = this.createWebResourceCollection(securityConstraint);
            } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IHttpMethod) {
                WebResourceCollectionTreeCP.HttpMethodFolder httpMethodsTreeFolder = (WebResourceCollectionTreeCP.HttpMethodFolder)((TreeNode)currentSelection).getFolder();
                webResourceCollection = httpMethodsTreeFolder.getWebResourceCollection();
                ret = this.createHttpMethods(webResourceCollection);
            } else if (currentSelection instanceof WebResourceCollectionTreeCP.HttpMethodFolder) {
                webResourceCollection = ((WebResourceCollectionTreeCP.HttpMethodFolder)currentSelection).getWebResourceCollection();
                ret = this.createHttpMethods(webResourceCollection);
            } else if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IUrlPattern) {
                WebResourceCollectionTreeCP.UrlPatternFolder urlPatternTreeFolder = (WebResourceCollectionTreeCP.UrlPatternFolder)((TreeNode)currentSelection).getFolder();
                webResourceCollection = urlPatternTreeFolder.getWebResourceCollection();
                ret = this.createUrlPattern(webResourceCollection);
            } else if (currentSelection instanceof WebResourceCollectionTreeCP.UrlPatternFolder) {
                webResourceCollection = ((WebResourceCollectionTreeCP.UrlPatternFolder)currentSelection).getWebResourceCollection();
                ret = this.createUrlPattern(webResourceCollection);
            }
            SecurityConstraintEditorComponent.this.dataModified(true);
            return ret;
        }

        private String getDefaultWebResourceName(ISecurityConstraint securityConstraint) {
            String defaultWebResourceName = "WebResource";
            int suffix = 0;
            IWebResourceCollection[] webResourceCollectionArr = null;
            if (securityConstraint != null) {
                webResourceCollectionArr = securityConstraint.getWebResourceCollections();
                if (webResourceCollectionArr != null) {
                    int i = 0;
                    while (i < webResourceCollectionArr.length) {
                        if (webResourceCollectionArr[i].getWebResourceName() != null && webResourceCollectionArr[i].getWebResourceName().getValue().equalsIgnoreCase(defaultWebResourceName)) {
                            defaultWebResourceName = "WebResource" + String.valueOf(++suffix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                }
                webResourceCollectionArr = null;
            }
            return defaultWebResourceName;
        }

        private IWebResourceCollection createWebResourceCollection(ISecurityConstraint securityConstraint) {
            IWebResourceCollection webResourceCollection = null;
            if (securityConstraint != null) {
                String defaultWebResourceName = this.getDefaultWebResourceName(securityConstraint);
                try {
                    webResourceCollection = securityConstraint.createWebResourceCollection(null);
                    webResourceCollection.createWebResourceName(null).setValue(defaultWebResourceName);
                }
                catch (J2eeCreateException e) {
                    SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<web-resource-collection> and/or <web-resource-name> could not be created.", e);
                }
            }
            return webResourceCollection;
        }

        private IHttpMethod createHttpMethods(IWebResourceCollection webResourceCollection) {
            HttpMethodsDialog httpMethodsDialog = new HttpMethodsDialog(webResourceCollection);
            Object[] resultSelections = httpMethodsDialog.getHttpMethodsFromSelectionDialog(false);
            IHttpMethod[] httpMethods = null;
            if (resultSelections != null) {
                httpMethods = new IHttpMethod[resultSelections.length];
                if (webResourceCollection != null && resultSelections != null && resultSelections.length > 0 && webResourceCollection != null) {
                    int i = 0;
                    while (i < resultSelections.length) {
                        IHttpMethod[] existingHttpMethods = webResourceCollection.getHttpMethods();
                        boolean httpMethodExists = false;
                        int j = 0;
                        while (j < existingHttpMethods.length && !httpMethodExists) {
                            if (existingHttpMethods[j].getValue().equals(resultSelections[i].toString())) {
                                httpMethodExists = true;
                            }
                            ++j;
                        }
                        if (!httpMethodExists) {
                            try {
                                httpMethods[i] = webResourceCollection.createHttpMethod(null);
                            }
                            catch (J2eeCreateException e) {
                                SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<http-method> could not be created.", e);
                            }
                            httpMethods[i].setValue(resultSelections[i].toString());
                        }
                        ++i;
                    }
                }
                return httpMethods[0];
            }
            return null;
        }

        private IUrlPattern createUrlPattern(IWebResourceCollection webResourceCollection) {
            IUrlPattern urlPattern = null;
            if (webResourceCollection != null) {
                try {
                    urlPattern = webResourceCollection.createUrlPattern(null);
                    urlPattern.setValue("*");
                }
                catch (J2eeCreateException e) {
                    SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<url-pattern> could not be created.", e);
                }
            }
            return urlPattern;
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null || currentSelection instanceof BaseFolder || currentSelection instanceof Folder || currentSelection instanceof IWebResourceCollection && ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getWebResourceCollections().length == 1) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = null;
            if (currentSelection instanceof IWebResourceCollection) {
                parentObj = SecurityConstraintEditorComponent.this.myTreeContentProvider.getParent(currentSelection);
            } else if (currentSelection instanceof TreeNode) {
                parentObj = ((TreeNode)currentSelection).getFolder();
            }
            IWebResourceCollection webResourceCollection = null;
            if (parentObj != null && parentObj instanceof BaseFolder) {
                ISecurityConstraint securityConstraint = ((BaseFolder)parentObj).getSecurityConstraint();
                if (currentSelection instanceof IWebResourceCollection) {
                    securityConstraint.removeWebResourceCollection((IWebResourceCollection)currentSelection);
                }
            } else if (parentObj instanceof WebResourceCollectionTreeCP.HttpMethodFolder) {
                webResourceCollection = ((WebResourceCollectionTreeCP.HttpMethodFolder)parentObj).getWebResourceCollection();
                if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IHttpMethod) {
                    webResourceCollection.removeHttpMethod((IHttpMethod)((TreeNode)currentSelection).getIdentifiable());
                    ((WebResourceCollectionTreeCP.HttpMethodFolder)parentObj).removeTreeNode((TreeNode)currentSelection);
                }
            } else if (parentObj instanceof WebResourceCollectionTreeCP.UrlPatternFolder) {
                webResourceCollection = ((WebResourceCollectionTreeCP.UrlPatternFolder)parentObj).getWebResourceCollection();
                if (currentSelection instanceof TreeNode && ((TreeNode)currentSelection).getIdentifiable() instanceof IUrlPattern) {
                    webResourceCollection.removeUrlPattern((IUrlPattern)((TreeNode)currentSelection).getIdentifiable());
                    ((WebResourceCollectionTreeCP.UrlPatternFolder)parentObj).removeTreeNode((TreeNode)currentSelection);
                }
            }
            SecurityConstraintEditorComponent.this.dataModified(true);
            return true;
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private ModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (SecurityConstraintEditorComponent.super.isRefreshingUI()) {
                return;
            }
            String newText = SecurityConstraintEditorComponent.this.getTransportGuaranteeCombo().getText();
            TransportGuaranteeComboAdapter adapter = SecurityConstraintEditorComponent.this.getTranspGuaranteeAdapter();
            if (adapter != null) {
                adapter.setSelection(newText);
            }
            SecurityConstraintEditorComponent.this.dataModified(true);
        }
    }

    private class DisplayNameModifyAdapter
    implements ModifyListener {
        private DisplayNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            SecurityConstraintEditorComponent.this.handleDisplayNameEvent();
        }
    }

    private class UserDataConstraintDescriptionTextAdapter
    extends AbstractTextAdapter {
        private UserDataConstraintDescriptionTextAdapter() {
        }

        public String getText() {
            String ret = "";
            if ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData() != null && ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint() != null) {
                ret = MutableUtil.mutableToValue((IMutable)((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint().getDescription());
            }
            return ret;
        }

        public void setText(String newText) {
            if (newText != null && newText.length() > 0) {
                if ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData() != null) {
                    IUserDataConstraint userDataConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint();
                    if (userDataConstraint == null) {
                        try {
                            userDataConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).createUserDataConstraint(null);
                            userDataConstraint.createTransportGuarantee(null).setValue("NONE");
                        }
                        catch (J2eeCreateException e) {
                            SecurityConstraintEditorComponent.this.handleJ2eeCreateException("Tag <transport-guarantee> could not be created.", e);
                        }
                    }
                    ICreateMutableCallback createCallback = new ICreateMutableCallback(){

                        public IMutable createMutable() throws J2eeCreateException {
                            return ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint().createDescription(null);
                        }
                    };
                    MutableUtil.toMutable((String)newText, (IMutable)((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint().getDescription(), (ICreateMutableCallback)createCallback);
                }
            } else {
                IUserDataConstraint userDataConstraint;
                ISecurityConstraint securityConstraint = (ISecurityConstraint)SecurityConstraintEditorComponent.this.getData();
                if (securityConstraint != null && securityConstraint.getUserDataConstraint() != null && (userDataConstraint = securityConstraint.getUserDataConstraint()).getTransportGuarantee() != null) {
                    if (userDataConstraint.getTransportGuarantee().getValue().equals("")) {
                        securityConstraint.removeUserDataConstraint();
                    } else {
                        userDataConstraint.removeDescription();
                    }
                }
            }
        }
    }

    private class TransportGuaranteeComboAdapter {
        private TransportGuaranteeComboAdapter() {
        }

        private String getSelection() {
            String ret = "";
            if ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData() != null && ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint() != null) {
                ret = MutableUtil.mutableToValue((IMutable)((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint().getTransportGuarantee());
            }
            if (ret == null || ret == "" || !possibleTranspGuaranteeArl.contains(ret)) {
                return "NONE";
            }
            return ret;
        }

        private void setSelection(String selection) {
            if (selection != null && selection.length() > 0 && (ISecurityConstraint)SecurityConstraintEditorComponent.this.getData() != null) {
                IUserDataConstraint userDataConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).getUserDataConstraint();
                if (userDataConstraint == null) {
                    try {
                        userDataConstraint = ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).createUserDataConstraint(null);
                    }
                    catch (J2eeCreateException e) {
                        SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<user-data-constraint> could not be created.", e);
                    }
                }
                if (userDataConstraint.getTransportGuarantee() == null) {
                    try {
                        userDataConstraint.createTransportGuarantee(null);
                    }
                    catch (J2eeCreateException e) {
                        SecurityConstraintEditorComponent.this.handleJ2eeCreateException("<transport-guarantee> could not be created.", e);
                    }
                }
                if (!SecurityConstraintEditorComponent.this.getTransportGuaranteeCombo().getText().equals("")) {
                    userDataConstraint.getTransportGuarantee().setValue(SecurityConstraintEditorComponent.this.getTransportGuaranteeCombo().getText());
                } else if (userDataConstraint.getDescription() != null && userDataConstraint.getDescription().getValue().equals("")) {
                    userDataConstraint.removeDescription();
                    userDataConstraint.removeTransportGuarantee();
                    ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).removeUserDataConstraint();
                } else if (userDataConstraint.getDescription() == null) {
                    userDataConstraint.removeTransportGuarantee();
                    ((ISecurityConstraint)SecurityConstraintEditorComponent.this.getData()).removeUserDataConstraint();
                } else if (userDataConstraint.getTransportGuarantee() != null) {
                    userDataConstraint.getTransportGuarantee().setValue("NONE");
                }
            }
        }
    }
}

