/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.web.dd.IIcon;
import com.tssap.j2ee.model.web.dd.ILargeIcon;
import com.tssap.j2ee.model.web.dd.IRunAs;
import com.tssap.j2ee.model.web.dd.ISecurityRole;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.ISmallIcon;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.SecurityRolesDialog;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableUI;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.chooser.IRadioChooser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class ReusableServletUI
extends ReusableUI {
    private static final String TXT_DUPLICATE_SERVLET_NAME = "Duplicate Servlet Name. Servlet name must be unique.";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableServletUI == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableServletUI = ReusableServletUI.class$("com.tssap.j2ee.ui.web.editor.internal.ui.ReusableServletUI")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableServletUI));
    private static final String TEXT_RUN_AS = "run-as";
    private static final String TEXT_ROLE_NAME = "role-name";
    private static final String TEXT_LOAD_ON_STARTUP = "load on startup";
    private static final String TEXT_DESCRIPTION = "Run-As Description";
    private IDDGeneralInfoComponent infoComponent;
    private InnerComponentAdapter infoComponentAdapter;
    private Text tfServletName;
    private Text tfServletSource;
    private Text tfLoadOnStartup;
    private Button cbRunAs;
    private Text tpRunAsDescription;
    private Text tfRoleName;
    private Button addRoleNameButton;
    private Button removeRoleNameButton;
    private IRadioChooser[] radioChoosers = new IRadioChooser[2];
    private IWebApp webApp = null;
    private boolean isDuplicateServletName = false;
    private static final int SERVLET_CLASS_CHOOSER = 0;
    private static final int JSP_FILE_CHOOSER = 1;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableServletUI;

    public ReusableServletUI(IWebApp webApp) {
        this.webApp = webApp;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IServlet servlet = this.getServlet();
        String text = this.tfServletName.getText().trim();
        if (servlet != null) {
            if (servlet.getServletName() != null) {
                servlet.getServletName().setValue(text);
            } else if (!text.equals("")) {
                try {
                    servlet.createServletName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("Servlet Name", e);
                }
                servlet.getServletName().setValue(text);
            }
            if (servlet.getRunAs() != null) {
                String runAsDescription = this.getTpRunAsDescription().getText().trim();
                if (runAsDescription != null && !runAsDescription.equals("")) {
                    if (servlet.getRunAs().getDescription() == null) {
                        try {
                            servlet.getRunAs().createDescription(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("description", e);
                        }
                    }
                    servlet.getRunAs().getDescription().setValue(runAsDescription);
                } else if (servlet.getRunAs().getDescription() != null) {
                    servlet.getRunAs().removeDescription();
                }
            }
            this.checkDuplicateServletName();
        }
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane classNamePane = userArea.addGridLayoutPane(3, userArea.createGridLayoutData(4, 4, true, false));
        classNamePane.addTextLabel("Name");
        this.tfServletName = classNamePane.addTextField(false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.tfServletName.addModifyListener((ModifyListener)new ServletNameModifyAdapter());
        this.setTfServletName(this.tfServletName);
        classNamePane.addTextLabel("Source");
        this.tfServletSource = classNamePane.addTextField(true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setTfServletSource(this.tfServletSource);
        userArea.addHorizontalSeparator();
        this.infoComponent = new DDGeneralInfoComponent("Information");
        this.infoComponentAdapter = new InnerComponentAdapter();
        this.infoComponent.setAdapter((IDDGeneralInfoComponentAdapter)this.infoComponentAdapter);
        IGridLayoutPane infoPane = userArea.addGridLayoutPane(this.infoComponent.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, false));
        this.infoComponent.createPartControl(infoPane);
        IGridLayoutPane gridPane = userArea.addGridLayoutPane(5, userArea.createGridLayoutData(4, 4, true, true));
        gridPane.addTextLabel(TEXT_LOAD_ON_STARTUP, gridPane.createGridLayoutData(4, 4, false, false, 1, 1));
        this.tfLoadOnStartup = gridPane.addTextField(false, gridPane.createGridLayoutData(4, 4, true, false, 4, 1));
        this.tfLoadOnStartup.addModifyListener((ModifyListener)new LoadOnStartupAndRoleNameModifyListener());
        this.cbRunAs = gridPane.addCheckBox(TEXT_RUN_AS, false, gridPane.createGridLayoutData(4, 4, false, false, 5, 1));
        SelectionListener runAsCheckboxSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReusableServletUI.this.runAsCbSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.cbRunAs.addSelectionListener(runAsCheckboxSelectionListener);
        gridPane.addTextLabel(TEXT_ROLE_NAME, gridPane.createGridLayoutData(4, 4, false, false, 1, 1));
        this.tfRoleName = gridPane.addTextField(true, gridPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.tfRoleName.addModifyListener((ModifyListener)new LoadOnStartupAndRoleNameModifyListener());
        this.addRoleNameButton = gridPane.addPushButton("Add", gridPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.removeRoleNameButton = gridPane.addPushButton("Remove", gridPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.addRoleNameButton.addSelectionListener((SelectionListener)new AddButtonListener());
        this.removeRoleNameButton.addSelectionListener((SelectionListener)new RemoveButtonListener());
        gridPane.addTextLabel(TEXT_DESCRIPTION, gridPane.createGridLayoutData(4, 4, false, false, 5, 1));
        this.tpRunAsDescription = gridPane.addTextPane("", false, gridPane.createGridLayoutData(4, 4, true, true, 5, 1));
        this.tpRunAsDescription.addModifyListener(this.getModifyAdapterSingleton());
    }

    private void runAsCbSelectionChanged(SelectionEvent e) {
        if (this.getAddRoleNameButton() != null && this.getRemoveRoleNameButton() != null && this.getTfRoleName() != null && this.getTpRunAsDescription() != null) {
            if (this.getCbRunAs().getSelection()) {
                this.getAddRoleNameButton().setEnabled(true);
                this.getRemoveRoleNameButton().setEnabled(true);
                this.getTpRunAsDescription().setEnabled(true);
            } else {
                this.getAddRoleNameButton().setEnabled(false);
                this.getRemoveRoleNameButton().setEnabled(false);
                this.getTfRoleName().setEnabled(false);
                this.getTpRunAsDescription().setEnabled(false);
                this.getTfRoleName().setText("");
                this.getTpRunAsDescription().setText("");
            }
        }
    }

    private boolean securityRolesAvailable(IWebApp webApp) {
        ISecurityRole[] webAppSecurityRoles;
        boolean hasSecRoles = false;
        if (webApp != null && (webAppSecurityRoles = webApp.getSecurityRoles()) != null && webAppSecurityRoles.length > 0) {
            hasSecRoles = true;
        }
        return hasSecRoles;
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IServlet servlet = this.getServlet();
        if (servlet != null) {
            if (servlet.getServletClass() != null) {
                this.tfServletSource.setText(servlet.getServletClass().getValue());
            }
            if (servlet.getJspFile() != null) {
                this.tfServletSource.setText(servlet.getJspFile().getValue());
            }
            this.tfServletName.setText(servlet.getServletName().getValue());
            this.infoComponent.initialize();
            if (servlet.getLoadOnStartup() != null) {
                if (!servlet.getLoadOnStartup().getValue().equals("")) {
                    this.getTfLoadOnStartup().setText(servlet.getLoadOnStartup().getValue());
                } else {
                    servlet.removeLoadOnStartup();
                }
            }
        }
        if (servlet.getRunAs() != null && servlet.getRunAs().getRoleName() != null && !servlet.getRunAs().getRoleName().getValue().equals("")) {
            IRunAs runAs = servlet.getRunAs();
            this.getCbRunAs().setSelection(true);
            this.getTfRoleName().setText(runAs.getRoleName().getValue());
            if (runAs.getDescription() != null && !runAs.getDescription().getValue().equals("")) {
                this.getTpRunAsDescription().setText(runAs.getDescription().getValue());
            } else if (runAs.getDescription() != null) {
                runAs.removeDescription();
            }
        } else {
            this.getCbRunAs().setSelection(false);
            this.getCbRunAs().setEnabled(this.securityRolesAvailable(this.getWebApp()));
            if (servlet.getRunAs() != null) {
                servlet.removeRunAs();
            }
        }
        this.updateEditableBehavior();
        this.stopRefreshingUI();
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private void handleServletNameChangedEvent() {
        this.refreshDataFromUI();
        super.handleEvent();
    }

    public IServlet getServlet() {
        IServlet ret = null;
        if (this.getData() instanceof IServlet) {
            ret = (IServlet)this.getData();
        }
        return ret;
    }

    public String acceptData(Object data) {
        String ret = null;
        if (ret == null && !(data instanceof IServlet)) {
            ret = "Not a Servlet";
        }
        return ret;
    }

    private IWebApp getWebApp() {
        return this.webApp;
    }

    private void setWebApp(IWebApp webApp) {
        this.webApp = webApp;
    }

    private Button getAddRoleNameButton() {
        return this.addRoleNameButton;
    }

    private Button getRemoveRoleNameButton() {
        return this.removeRoleNameButton;
    }

    private Text getTfLoadOnStartup() {
        return this.tfLoadOnStartup;
    }

    private Button getCbRunAs() {
        return this.cbRunAs;
    }

    private Text getTpRunAsDescription() {
        return this.tpRunAsDescription;
    }

    private Text getTfRoleName() {
        return this.tfRoleName;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + "Tag <" + msg + "> could not be created. " + e.getMessage());
    }

    private void handleJ2eeCreateException1(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + ". " + e.getMessage());
    }

    private void refreshAdditionalDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        IServlet servlet = this.getServlet();
        String loadOnStartupTxt = this.tfLoadOnStartup.getText();
        if (servlet.getLoadOnStartup() != null) {
            if (loadOnStartupTxt != null && !loadOnStartupTxt.equals("")) {
                servlet.getLoadOnStartup().setValue(loadOnStartupTxt);
            } else {
                servlet.removeLoadOnStartup();
            }
        } else if (loadOnStartupTxt != null && !loadOnStartupTxt.equals("")) {
            try {
                servlet.createLoadOnStartup(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("load-on-startup", e);
            }
            servlet.getLoadOnStartup().setValue(loadOnStartupTxt);
        }
        String runAsRoleNameTxt = this.getTfRoleName().getText();
        String runAsDescription = this.getTpRunAsDescription().getText();
        if (runAsRoleNameTxt != null && !runAsRoleNameTxt.equals("")) {
            IRunAs runAs = null;
            if (servlet.getRunAs() != null) {
                runAs = servlet.getRunAs();
                if (runAs.getRoleName() == null) {
                    try {
                        runAs.createRoleName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException(TEXT_ROLE_NAME, e);
                    }
                }
            } else {
                try {
                    runAs = servlet.createRunAs(null);
                    runAs.createRoleName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException1("Tag <run-as> and/or <role-name> could not be created.", e);
                }
            }
            runAs.getRoleName().setValue(runAsRoleNameTxt);
        } else if (servlet.getRunAs() != null) {
            servlet.removeRunAs();
        }
    }

    public String okToLeave() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String message = status.getMessage();
        status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.isDuplicateServletName()) {
            status.setError(TXT_DUPLICATE_SERVLET_NAME);
        } else if (this.getTfLoadOnStartup().getText() != null && !this.getTfLoadOnStartup().getText().equals("")) {
            String loadOnStartupValue = this.getTfLoadOnStartup().getText();
            try {
                Integer.parseInt(loadOnStartupValue);
            }
            catch (NumberFormatException e) {
                status.setError("Load-on-startup value " + loadOnStartupValue + " must be an Integer-typed value.");
            }
        }
        return status;
    }

    private void checkDuplicateServletName() {
        if (this.getWebApp() != null) {
            IServlet[] servletArr = this.getWebApp().getServlets();
            int servNameDuplicateCounter = 0;
            int i = 0;
            while (i < servletArr.length) {
                if (servletArr[i].getServletName().getValue().equals(this.getTfServletName().getText())) {
                    ++servNameDuplicateCounter;
                }
                if (servNameDuplicateCounter > 1) {
                    this.setDuplicateServletName(true);
                } else {
                    this.setDuplicateServletName(false);
                }
                ++i;
            }
        }
    }

    private boolean isSecurityRoleExisting(String roleName) {
        IWebApp lWebApp = this.getWebApp();
        if (lWebApp != null) {
            ISecurityRole[] lSecurityRoles = lWebApp.getSecurityRoles();
            int i = 0;
            while (i < lSecurityRoles.length) {
                if (lSecurityRoles[i].getRoleName() != null && lSecurityRoles[i].getRoleName().getValue().equals(roleName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.infoComponent != null) {
            this.infoComponent.setEditable(editable);
        }
        if (this.getTfServletSource() != null) {
            this.getTfServletSource().setEditable(false);
        }
        if (this.getCbRunAs() != null) {
            this.getCbRunAs().setEnabled(editable);
            this.getTpRunAsDescription().setEnabled(this.getCbRunAs().getSelection() && editable);
            this.getAddRoleNameButton().setEnabled(this.getCbRunAs().getSelection() && editable);
            this.getRemoveRoleNameButton().setEnabled(this.getCbRunAs().getSelection() && editable);
        }
    }

    private Text getTfServletSource() {
        return this.tfServletSource;
    }

    private void setTfServletSource(Text text) {
        this.tfServletSource = text;
    }

    public Text getTfServletName() {
        return this.tfServletName;
    }

    public void setTfServletName(Text text) {
        this.tfServletName = text;
    }

    private boolean isDuplicateServletName() {
        return this.isDuplicateServletName;
    }

    private void setDuplicateServletName(boolean b) {
        this.isDuplicateServletName = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RemoveButtonListener
    extends SelectionAdapter {
        private RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ReusableServletUI.this.getTfRoleName().setText("");
            ReusableServletUI.this.getModifiedCallback().dataModified(true);
            ReusableServletUI.this.refreshAdditionalDataFromUI();
        }
    }

    private class AddButtonListener
    extends SelectionAdapter {
        private AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SecurityRolesDialog securityRolesDialog = new SecurityRolesDialog(ReusableServletUI.this.getWebApp());
            Object[] resultSelections = securityRolesDialog.getRoleNamesFromSelectionDialog(true);
            if (resultSelections != null) {
                ReusableServletUI.this.getTfRoleName().setText(resultSelections[0].toString());
                ReusableServletUI.this.getModifiedCallback().dataModified(true);
                ReusableServletUI.this.refreshAdditionalDataFromUI();
            }
        }
    }

    private class LoadOnStartupAndRoleNameModifyListener
    implements ModifyListener {
        private LoadOnStartupAndRoleNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ReusableServletUI.super.isRefreshingUI()) {
                return;
            }
            if (ReusableServletUI.this.getModifiedCallback() != null) {
                ReusableServletUI.this.getModifiedCallback().dataModified(true);
            }
            ReusableServletUI.this.refreshAdditionalDataFromUI();
        }
    }

    private class InnerComponentAdapter
    implements IDDGeneralInfoComponentAdapter {
        public void createIcons() {
        }

        public String getDescription() {
            String description = "";
            if (ReusableServletUI.this.getServlet() != null) {
                description = MutableUtil.mutableToValue((IMutable)ReusableServletUI.this.getServlet().getDescription());
            }
            return description;
        }

        public String getDisplayName() {
            String displayName = "";
            if (ReusableServletUI.this.getServlet() != null) {
                displayName = MutableUtil.mutableToValue((IMutable)ReusableServletUI.this.getServlet().getDisplayName());
            }
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ILargeIcon largeIconMutable = ReusableServletUI.this.getServlet().getIcon().getLargeIcon();
                ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ISmallIcon smallIconMutable = ReusableServletUI.this.getServlet().getIcon().getSmallIcon();
                ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
            }
            return ret;
        }

        public void removeIcons() {
        }

        public void setDescription(String description) {
            if (ReusableServletUI.this.getServlet() != null) {
                if (ReusableServletUI.this.getServlet().getDescription() != null) {
                    ReusableServletUI.this.getServlet().getDescription().setValue(description);
                } else {
                    try {
                        ReusableServletUI.this.getServlet().createDescription(null).setValue(description);
                    }
                    catch (J2eeCreateException e) {
                        ReusableServletUI.this.handleJ2eeCreateException("description", e);
                    }
                }
                ReusableServletUI.super.handleEvent();
            }
        }

        public void setDisplayName(String displayName) {
            if (ReusableServletUI.this.getServlet() != null) {
                if (ReusableServletUI.this.getServlet().getDisplayName() != null) {
                    ReusableServletUI.this.getServlet().getDisplayName().setValue(displayName);
                } else {
                    try {
                        ReusableServletUI.this.getServlet().createDisplayName(null).setValue(displayName);
                    }
                    catch (J2eeCreateException e) {
                        ReusableServletUI.this.handleJ2eeCreateException("display-name", e);
                    }
                }
                ReusableServletUI.super.handleEvent();
            }
        }

        private IIcon getIcon() {
            IIcon icon = ReusableServletUI.this.getServlet().getIcon();
            if (icon == null) {
                try {
                    icon = ReusableServletUI.this.getServlet().createIcon(null);
                }
                catch (J2eeCreateException e) {
                    ReusableServletUI.this.handleJ2eeCreateException("icon", e);
                }
            }
            return icon;
        }

        public void setLargeIcon(String largeIcon) {
            if (ReusableServletUI.this.getServlet() != null) {
                IIcon icon = this.getIcon();
                if (icon.getLargeIcon() != null) {
                    icon.getLargeIcon().setValue(largeIcon);
                } else {
                    try {
                        icon.createLargeIcon(null).setValue(largeIcon);
                    }
                    catch (J2eeCreateException e) {
                        ReusableServletUI.this.handleJ2eeCreateException("large-icon", e);
                    }
                }
                ReusableServletUI.super.handleEvent();
            }
        }

        public void setSmallIcon(String smallIcon) {
            if (ReusableServletUI.this.getServlet() != null) {
                IIcon icon = this.getIcon();
                if (icon.getSmallIcon() != null) {
                    icon.getSmallIcon().setValue(smallIcon);
                } else {
                    try {
                        icon.createSmallIcon(null).setValue(smallIcon);
                    }
                    catch (J2eeCreateException e) {
                        ReusableServletUI.this.handleJ2eeCreateException("small-icon", e);
                    }
                }
                ReusableServletUI.super.handleEvent();
            }
        }

        public boolean isIconsChecked() {
            IIcon icon = ReusableServletUI.this.getServlet() != null ? ReusableServletUI.this.getServlet().getIcon() : null;
            return icon != null;
        }

        public void setIconsChecked(boolean checkFlag) {
            if (ReusableServletUI.this.getServlet() != null) {
                if (checkFlag) {
                    if (!this.isIconsChecked()) {
                        try {
                            ReusableServletUI.this.getServlet().createIcon(null);
                        }
                        catch (J2eeCreateException e) {
                            ReusableServletUI.this.handleJ2eeCreateException("icon", e);
                        }
                    }
                } else {
                    ReusableServletUI.this.getServlet().removeIcon();
                }
                ReusableServletUI.super.handleEvent();
            }
        }
    }

    private class ServletNameModifyAdapter
    implements ModifyListener {
        private ServletNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (ReusableServletUI.super.isRefreshingUI()) {
                return;
            }
            ReusableServletUI.this.handleServletNameChangedEvent();
            ReusableServletUI.this.getModifiedCallback().dataModified(true);
        }
    }
}

