/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.ISecurityRole;
import com.tssap.j2ee.model.web.dd.ISecurityRoleRef;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.SecurityRolesDialog;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.WebObjectsTreeContentProvider;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class ReusableSecRoleRefUI
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableSecRoleRefUI == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableSecRoleRefUI = ReusableSecRoleRefUI.class$("com.tssap.j2ee.ui.web.editor.internal.ui.ReusableSecRoleRefUI")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableSecRoleRefUI));
    private static final String TXT_DUPLICATE_NAME = "Duplicate name. Please choose another security role reference name.";
    private boolean isDuplicateSecurityRoleRefName = false;
    private Text descriptionTextPane;
    private Text roleLinkTextField;
    private Button addRoleLinkButton;
    private Button removeRoleLinkButton;
    private Text roleNameTextField;
    private SecurityRolesDialog securityRolesDialog;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableSecRoleRefUI;

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane gridPane = userArea.addGridLayoutPane(this.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, true, 4, 4));
        IGridLayoutPane gridPane1 = userArea.addGridLayoutPane(this.getUserGridNumOfColumns(), userArea.createGridLayoutData(4, 4, true, true, 4, 4));
        gridPane.addTextLabel("Role name");
        this.roleNameTextField = gridPane.addTextField("", false, gridPane.createGridLayoutData(4, 4, true, false, 3, 1));
        this.setRoleNameTextField(this.roleNameTextField);
        gridPane.addTextLabel("Role link");
        this.roleLinkTextField = gridPane.addTextField("", true, gridPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setRoleLinkTextField(this.roleLinkTextField);
        this.addRoleLinkButton = gridPane.addPushButton("Add", gridPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.removeRoleLinkButton = gridPane.addPushButton("Remove", gridPane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.setAddRoleLinkButton(this.addRoleLinkButton);
        this.setRemoveRoleLinkButton(this.removeRoleLinkButton);
        gridPane.addTextLabel("Description");
        this.descriptionTextPane = gridPane.addTextPane("", false, true, gridPane.createGridLayoutData(4, 4, true, true, 3, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        gridPane1.addPlaceholder();
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener(this.getModifyAdapterSingleton());
        this.getRoleLinkTextField().addModifyListener(this.getModifyAdapterSingleton());
        this.getRoleNameTextField().addModifyListener((ModifyListener)new RoleNameModifyAdapter());
        this.getAddRoleLinkButton().addSelectionListener((SelectionListener)new AddButtonListener());
        this.getRemoveRoleLinkButton().addSelectionListener((SelectionListener)new RemoveButtonListener());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private Text getRoleLinkTextField() {
        return this.roleLinkTextField;
    }

    private void setRoleLinkTextField(Text roleLinkTextField) {
        this.roleLinkTextField = roleLinkTextField;
    }

    public int getUserGridNumOfColumns() {
        return 4;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        ISecurityRoleRef securityRoleRef = this.getSecurityRef();
        if (securityRoleRef != null) {
            if (!this.getDescriptionTextPane().getText().trim().equals("")) {
                String descrValue;
                if (securityRoleRef.getDescription() == null) {
                    try {
                        securityRoleRef.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                }
                if ((descrValue = this.getDescriptionTextPane().getText()) != null && descrValue.trim().length() != 0) {
                    securityRoleRef.getDescription().setValue(descrValue.trim());
                } else {
                    securityRoleRef.removeDescription();
                }
            }
            if (this.getRoleLinkTextField() != null && !this.getRoleLinkTextField().getText().trim().equals("")) {
                if (securityRoleRef.getRoleLink() == null) {
                    try {
                        securityRoleRef.createRoleLink(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<role-link> could not be created.", e);
                    }
                }
                securityRoleRef.getRoleLink().setValue(this.getRoleLinkTextField().getText().trim());
            } else if (securityRoleRef.getRoleLink() != null) {
                securityRoleRef.removeRoleLink();
            }
            this.refreshRoleNameFromUI();
        }
    }

    private void refreshRoleNameFromUI() {
        ISecurityRoleRef securityRoleRef = this.getSecurityRef();
        if (securityRoleRef != null) {
            if (!this.getRoleNameTextField().getText().trim().equals("")) {
                if (securityRoleRef.getRoleName() == null) {
                    try {
                        securityRoleRef.createRoleName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<role-name> could not be created.", e);
                    }
                }
                securityRoleRef.getRoleName().setValue(this.getRoleNameTextField().getText().trim());
            } else if (securityRoleRef.getRoleName() != null) {
                securityRoleRef.getRoleName().setValue("");
            } else {
                try {
                    securityRoleRef.createRoleName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<role-name> could not be created.", e);
                }
            }
            IServlet iservlet = this.getServlet();
            if (iservlet != null) {
                ISecurityRoleRef[] secRoleRefsArr = null;
                secRoleRefsArr = iservlet.getSecurityRoleRefs();
                int secRoleRefsDuplicateCounter = 0;
                int i = 0;
                while (i < secRoleRefsArr.length) {
                    if (secRoleRefsArr[i].getRoleName().getValue().equals(this.getRoleNameTextField().getText())) {
                        ++secRoleRefsDuplicateCounter;
                    }
                    if (secRoleRefsDuplicateCounter > 1) {
                        this.setDuplicateSecurityRoleRefName(true);
                    } else {
                        this.setDuplicateSecurityRoleRefName(false);
                    }
                    ++i;
                }
            }
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        ISecurityRoleRef securityRoleRef = this.getSecurityRef();
        if (securityRoleRef == null) {
            throw new IllegalArgumentException("No object of ISecurityRoleRef found!");
        }
        this.getDescriptionTextPane().setText(securityRoleRef.getDescription() != null ? securityRoleRef.getDescription().getValue() : "");
        this.getRoleLinkTextField().setText(securityRoleRef.getRoleLink() != null ? securityRoleRef.getRoleLink().getValue() : "");
        this.getRoleNameTextField().setText(securityRoleRef.getRoleName() != null ? securityRoleRef.getRoleName().getValue() : "");
        this.stopRefreshingUI();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getRoleLinkTextField() != null) {
            this.getRoleLinkTextField().setEditable(false);
        }
    }

    private IWebApp getWebApp() {
        if (this.getData() instanceof TreeNode && ((TreeNode)this.getData()).getFolder() instanceof WebObjectsTreeContentProvider.SecurityRoleRefNode) {
            WebObjectsTreeContentProvider.SecurityRoleRefNode refNode = (WebObjectsTreeContentProvider.SecurityRoleRefNode)((TreeNode)this.getData()).getFolder();
            return refNode.getMyWebApp();
        }
        return null;
    }

    private ISecurityRoleRef getSecurityRef() {
        ISecurityRoleRef ret = null;
        if (this.getData() instanceof TreeNode) {
            ret = (ISecurityRoleRef)((TreeNode)this.getData()).getIdentifiable();
        }
        return ret;
    }

    private IServlet getServlet() {
        if (this.getData() instanceof TreeNode && ((TreeNode)this.getData()).getFolder() instanceof WebObjectsTreeContentProvider.SecurityRoleRefNode) {
            WebObjectsTreeContentProvider.SecurityRoleRefNode refNode = (WebObjectsTreeContentProvider.SecurityRoleRefNode)((TreeNode)this.getData()).getFolder();
            return refNode.getServlet();
        }
        return null;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof TreeNode)) {
            ret = "No object of TreeNode found!";
        }
        return ret;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private Text getRoleNameTextField() {
        return this.roleNameTextField;
    }

    private void setRoleNameTextField(Text roleNameTextField) {
        this.roleNameTextField = roleNameTextField;
    }

    protected void handleRoleNameEvent() {
        if (!this.isRefreshingUI()) {
            this.refreshRoleNameFromUI();
            super.handleEvent();
        }
    }

    private Button getAddRoleLinkButton() {
        return this.addRoleLinkButton;
    }

    private Button getRemoveRoleLinkButton() {
        return this.removeRoleLinkButton;
    }

    private void setAddRoleLinkButton(Button addRoleLinkButton) {
        this.addRoleLinkButton = addRoleLinkButton;
    }

    private void setRemoveRoleLinkButton(Button removeRoleLinkButton) {
        this.removeRoleLinkButton = removeRoleLinkButton;
    }

    public String okToLeave() {
        String ret = super.okToLeave();
        StatusWrapper validationStatus = this.isContentValid();
        if (validationStatus != null) {
            ret = validationStatus.getMessage();
        }
        return ret;
    }

    private List getExistingSecRolesList() {
        ISecurityRole[] securityRoles;
        List<String> securityRoleNamesList = null;
        this.securityRolesDialog = this.getSecurityRolesDialog();
        if (this.securityRolesDialog == null) {
            this.securityRolesDialog = new SecurityRolesDialog(this.getWebApp());
        }
        if ((securityRoles = (ISecurityRole[])this.securityRolesDialog.getSecurityRolesFromModel()) != null) {
            String[] securityRoleNames = new String[securityRoles.length];
            int i = 0;
            while (i < securityRoles.length) {
                securityRoleNames[i] = securityRoles[i].getRoleName().getValue();
                ++i;
            }
            securityRoleNamesList = Arrays.asList(securityRoleNames);
        }
        return securityRoleNamesList;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String roleNameValue = this.getRoleNameTextField().getText();
        String roleLinkValue = this.getRoleLinkTextField().getText();
        List securityRoleNamesList = this.getExistingSecRolesList();
        if (roleNameValue == null || roleNameValue.equals("")) {
            status.setError("Please fill in a role name.");
        } else if (roleLinkValue == null || roleLinkValue.equals("")) {
            if (securityRoleNamesList != null && securityRoleNamesList.size() > 0) {
                if (!securityRoleNamesList.contains(roleNameValue)) {
                    status.setError("Please fill in a role link or role name corresponding to an existing security role.");
                }
            } else {
                status.setError("Please add security roles first. Security roles can be added on 'Security Roles' page");
            }
        } else if (this.isDuplicateSecurityRoleRefName()) {
            status.setError(TXT_DUPLICATE_NAME);
        }
        return status;
    }

    private SecurityRolesDialog getSecurityRolesDialog() {
        return this.securityRolesDialog;
    }

    private boolean isDuplicateSecurityRoleRefName() {
        return this.isDuplicateSecurityRoleRefName;
    }

    private void setDuplicateSecurityRoleRefName(boolean isDuplicateSecurityRoleRefName) {
        this.isDuplicateSecurityRoleRefName = isDuplicateSecurityRoleRefName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RemoveButtonListener
    extends SelectionAdapter {
        private RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ReusableSecRoleRefUI.this.getRoleLinkTextField().setText("");
        }
    }

    private class AddButtonListener
    extends SelectionAdapter {
        private AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ReusableSecRoleRefUI.this.securityRolesDialog = new SecurityRolesDialog(ReusableSecRoleRefUI.this.getWebApp());
            Object[] resultSelections = ReusableSecRoleRefUI.this.securityRolesDialog.getRoleNamesFromSelectionDialog(true);
            if (resultSelections != null && ReusableSecRoleRefUI.this.getSecurityRef() != null) {
                int i = 0;
                while (i < resultSelections.length) {
                    ReusableSecRoleRefUI.this.getRoleLinkTextField().setText(resultSelections[i].toString());
                    ++i;
                }
            }
        }
    }

    private class RoleNameModifyAdapter
    implements ModifyListener {
        private RoleNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ReusableSecRoleRefUI.this.handleRoleNameEvent();
        }
    }
}

