/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IDescription;
import com.tssap.j2ee.model.web.dd.IInitParam;
import com.tssap.j2ee.model.web.dd.IParamName;
import com.tssap.j2ee.model.web.dd.IParamValue;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class ReusableParamUI
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableParamUI == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableParamUI = ReusableParamUI.class$("com.tssap.j2ee.ui.web.editor.internal.ui.ReusableParamUI")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableParamUI));
    private Text paramNameTextField;
    private Text paramValueTextField;
    private Text descriptionTextPane;
    private boolean modifyCallbackActive = true;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableParamUI;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Init Parameter Name");
        this.paramNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Init Parameter Value");
        this.paramValueTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.paramNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.paramValueTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.descriptionTextPane.addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getInitParams() != null) {
            this.refreshParamsFromUI();
        }
    }

    private void refreshParamsFromUI() {
        String METHOD = "refreshParamsFromUI";
        if (this.getInitParams() != null) {
            String value = this.paramNameTextField.getText().trim();
            IParamName paramName = this.getInitParams().getParamName();
            if (this.getInitParams().getParamName() == null) {
                try {
                    paramName = this.getInitParams().createParamName(null);
                }
                catch (J2eeCreateException e1) {
                    tracer.error(METHOD, "Element could not be created: " + e1.toString(), (Throwable)e1);
                }
            }
            paramName.setValue(value);
            this.setTitle(value);
            value = this.paramValueTextField.getText().trim();
            IParamValue paramValue = this.getInitParams().getParamValue();
            if (this.getInitParams().getParamValue() == null) {
                try {
                    paramValue = this.getInitParams().createParamValue(null);
                }
                catch (J2eeCreateException e1) {
                    tracer.error(METHOD, "Element could not be created: " + e1.toString(), (Throwable)e1);
                }
            }
            paramValue.setValue(value);
            String descrValue = this.descriptionTextPane.getText();
            if (descrValue != null && descrValue.trim().length() != 0) {
                IDescription descr = this.getInitParams().getDescription();
                try {
                    if (descr == null) {
                        descr = this.getInitParams().createDescription(null);
                    }
                    descr.setValue(descrValue.trim());
                }
                catch (J2eeCreateException e) {
                    tracer.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            } else {
                this.getInitParams().removeDescription();
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this.modifyCallbackActive = false;
            if (this.getInitParams() != null) {
                String name;
                if (this.getInitParams().getParamName() != null) {
                    name = this.getInitParams().getParamName().getValue();
                    if (name.trim().length() == 0) {
                        name = "<fill in init-param-name>";
                    }
                    this.paramNameTextField.setText(name);
                    this.setTitle(name);
                }
                if (this.getInitParams().getParamValue() != null) {
                    name = this.getInitParams().getParamValue().getValue();
                    this.paramValueTextField.setText(name);
                }
                if (this.getInitParams().getDescription() != null) {
                    String description = this.getInitParams().getDescription().getValue();
                    this.descriptionTextPane.setText(description);
                } else {
                    this.descriptionTextPane.setText("");
                }
            }
            Object var3_2 = null;
            this.modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    private IInitParam getInitParams() {
        IInitParam ret = null;
        if (this.getData() instanceof TreeNode) {
            ret = (IInitParam)((TreeNode)this.getData()).getIdentifiable();
        }
        return ret;
    }

    protected void handleParamModifyEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        this.refreshParamsFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ReusableParamUI.this.handleParamModifyEvent();
        }
    }
}

