/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.web.dd.IDescription;
import com.tssap.j2ee.model.web.dd.IDisplayName;
import com.tssap.j2ee.model.web.dd.IFilter;
import com.tssap.j2ee.model.web.dd.IIcon;
import com.tssap.j2ee.model.web.dd.IInitParam;
import com.tssap.j2ee.model.web.dd.ILargeIcon;
import com.tssap.j2ee.model.web.dd.ISmallIcon;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.j2ee.ui.web.editor.internal.ui.ReusableUI;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.reuse.table.AbstractTableAdapter;
import com.tssap.util.ui.reuse.table.ITableAdapter;
import com.tssap.util.ui.reuse.table.ITableColumn;
import com.tssap.util.ui.reuse.table.ITableModifyListener;
import com.tssap.util.ui.reuse.table.ITableRow;
import com.tssap.util.ui.reuse.table.TableColumns;
import com.tssap.util.ui.reuse.table.TableComponent;
import com.tssap.util.ui.reuse.table.impl.TableRow;
import org.eclipse.swt.widgets.Text;

public class ReusableFilterUI
extends ReusableUI {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableFilterUI == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableFilterUI = ReusableFilterUI.class$("com.tssap.j2ee.ui.web.editor.internal.ui.ReusableFilterUI")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableFilterUI));
    private Text tfFilterName;
    private Text tfFilterClass;
    private IDDGeneralInfoComponent infoComponent;
    private TableComponent tabComponent;
    private InnerInitParameterAdapter tabAdapter;
    private InnerInfoComponentAdapter infoComponentAdapter;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableFilterUI;

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        String text = this.tfFilterName.getText();
        if (this.getFilter().getFilterName() != null) {
            this.getFilter().getFilterName().setValue(text);
        } else if (!text.equals("")) {
            try {
                this.getFilter().createFilterName(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("filter-name", e);
            }
            this.getFilter().getFilterName().setValue(text);
        }
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane filterNamePane = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, false));
        filterNamePane.addTextLabel("Filter Name");
        this.tfFilterName = filterNamePane.addTextField(false, userArea.createGridLayoutData(4, 4, true, false));
        this.tfFilterName.addModifyListener(this.getModifyAdapterSingleton());
        filterNamePane.addTextLabel("Filter Class");
        this.tfFilterClass = filterNamePane.addTextField(true, userArea.createGridLayoutData(4, 4, true, false));
        this.tfFilterClass.setEditable(false);
        userArea.addHorizontalSeparator();
        IGridLayoutData gridData = userArea.createGridLayoutData(4, 4, true, true);
        ISimplePane infoPane = userArea.addSimplePane(gridData);
        this.infoComponent = new DDGeneralInfoComponent();
        this.infoComponent.createPartControl(infoPane.getComposite());
        this.infoComponentAdapter = new InnerInfoComponentAdapter();
        this.infoComponent.setAdapter((IDDGeneralInfoComponentAdapter)this.infoComponentAdapter);
        gridData = userArea.createGridLayoutData(4, 4, true, true);
        ISimplePane tablePane = userArea.addSimplePane(gridData);
        this.tabAdapter = new InnerInitParameterAdapter();
        this.tabComponent = new TableComponent((ITableAdapter)this.tabAdapter);
        this.tabComponent.setTitle("Init Parameter");
        this.tabComponent.addTableModifyListener((ITableModifyListener)this.getTableModifyListener());
        this.tabComponent.createPartControl(tablePane.getComposite());
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        IFilter filter = this.getFilter();
        if (filter != null) {
            this.tfFilterName.setText(MutableUtil.mutableToValue((IMutable)filter.getFilterName()));
            this.tfFilterClass.setText(MutableUtil.mutableToValue((IMutable)filter.getFilterClass()));
            this.tabComponent.refreshFromAdapter();
            this.infoComponent.initialize();
        }
        this.stopRefreshingUI();
    }

    public IFilter getFilter() {
        IFilter ret = null;
        if (this.getData() instanceof IFilter) {
            ret = (IFilter)this.getData();
        }
        return ret;
    }

    public String acceptData(Object data) {
        String ret = null;
        if (ret == null && !(data instanceof IFilter)) {
            ret = "Not a Filter";
        }
        return ret;
    }

    protected void handleEvent() {
        this.refreshDataFromUI();
        super.handleEvent();
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + "Tag <" + msg + "> could not be created. " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.tfFilterClass != null) {
            this.tfFilterClass.setEditable(false);
        }
        if (this.tabComponent != null) {
            this.tabComponent.setEditable(editable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerInitParameterAdapter
    extends AbstractTableAdapter {
        protected ITableRow[] createNewRows() {
            ITableRow[] initialRows = new ITableRow[1];
            String[] rowValue = new String[3];
            rowValue[TableColumns.PARAMETER_NAME.getColumnNumber()] = TableColumns.PARAMETER_NAME.getDefaultColumnEntry();
            rowValue[TableColumns.PARAMETER_VALUE.getColumnNumber()] = TableColumns.PARAMETER_VALUE.getDefaultColumnEntry();
            rowValue[TableColumns.PARAMETER_DESCRIPTION.getColumnNumber()] = TableColumns.PARAMETER_DESCRIPTION.getDefaultColumnEntry();
            initialRows[0] = TableRow.createTableRow((String[])rowValue, null);
            return initialRows;
        }

        protected Object createInModel(ITableRow row) {
            String paramName = row.getValues()[TableColumns.PARAMETER_NAME.getColumnNumber()];
            String paramValue = row.getValues()[TableColumns.PARAMETER_VALUE.getColumnNumber()];
            String paramDescription = row.getValues()[TableColumns.PARAMETER_DESCRIPTION.getColumnNumber()];
            IInitParam newParam = null;
            try {
                newParam = ReusableFilterUI.this.getFilter().createInitParam(null);
                newParam.createParamName(null).setValue(paramName);
                newParam.createParamValue(null).setValue(paramValue);
                newParam.createDescription(null).setValue(paramDescription);
                row.setUserObject((Object)newParam);
            }
            catch (J2eeCreateException ex) {
                ReusableFilterUI.this.handleJ2eeCreateException("init-param", ex);
            }
            return newParam;
        }

        public ITableColumn[] getColumns() {
            return TableColumns.PARAMETER_COLUMNS;
        }

        protected void removeFromModel(ITableRow row) {
            if (row.getUserObject() instanceof IInitParam) {
                IInitParam param = (IInitParam)row.getUserObject();
                ReusableFilterUI.this.getFilter().removeInitParam(param);
            }
        }

        protected ITableRow[] retrieveFromModel() {
            if (ReusableFilterUI.this.getFilter() == null) {
                return new ITableRow[0];
            }
            IInitParam[] params = ReusableFilterUI.this.getFilter().getInitParams();
            ITableRow[] modelRows = new ITableRow[params.length];
            int cp = 0;
            while (cp < params.length) {
                String[] rowValue = new String[3];
                rowValue[TableColumns.PARAMETER_NAME.getColumnNumber()] = params[cp].getParamName() != null ? params[cp].getParamName().getValue() : "";
                rowValue[TableColumns.PARAMETER_VALUE.getColumnNumber()] = params[cp].getParamValue() != null ? params[cp].getParamValue().getValue() : "";
                rowValue[TableColumns.PARAMETER_DESCRIPTION.getColumnNumber()] = params[cp].getDescription() != null ? params[cp].getDescription().getValue() : "";
                modelRows[cp] = TableRow.createTableRow((String[])rowValue, (Object)params[cp]);
                ++cp;
            }
            return modelRows;
        }

        protected void updateModel(ITableRow row, ITableColumn column, String value) {
            IInitParam param = (IInitParam)row.getUserObject();
            if (column.getColumnNumber() == TableColumns.PARAMETER_NAME.getColumnNumber()) {
                if (param.getParamName() != null) {
                    param.getParamName().setValue(value);
                } else {
                    try {
                        param.createParamName(null).setValue(value);
                    }
                    catch (J2eeCreateException ex) {
                        ReusableFilterUI.this.handleJ2eeCreateException("param-name", ex);
                    }
                }
            } else if (column.getColumnNumber() == TableColumns.PARAMETER_VALUE.getColumnNumber()) {
                if (param.getParamValue() != null) {
                    param.getParamValue().setValue(value);
                } else {
                    try {
                        param.createParamValue(null).setValue(value);
                    }
                    catch (J2eeCreateException ex) {
                        ReusableFilterUI.this.handleJ2eeCreateException("param-value", ex);
                    }
                }
            } else if (column.getColumnNumber() == TableColumns.PARAMETER_DESCRIPTION.getColumnNumber()) {
                if (param.getDescription() != null) {
                    param.getDescription().setValue(value);
                } else {
                    try {
                        param.createDescription(null).setValue(value);
                    }
                    catch (J2eeCreateException ex) {
                        ReusableFilterUI.this.handleJ2eeCreateException("description", ex);
                    }
                }
            }
        }
    }

    private class InnerInfoComponentAdapter
    implements IDDGeneralInfoComponentAdapter {
        public String getDescription() {
            if (ReusableFilterUI.this.getFilter() == null) {
                return "";
            }
            IDescription descriptionMutable = ReusableFilterUI.this.getFilter().getDescription();
            String description = MutableUtil.mutableToValue((IMutable)descriptionMutable);
            return description;
        }

        public String getDisplayName() {
            if (ReusableFilterUI.this.getFilter() == null) {
                return "";
            }
            IDisplayName displayNameMutable = ReusableFilterUI.this.getFilter().getDisplayName();
            String displayName = MutableUtil.mutableToValue((IMutable)displayNameMutable);
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ILargeIcon largeIconMutable = ReusableFilterUI.this.getFilter().getIcon().getLargeIcon();
                ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked()) {
                ISmallIcon smallIconMutable = ReusableFilterUI.this.getFilter().getIcon().getSmallIcon();
                ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
            }
            return ret;
        }

        public void setDescription(String description) {
            if (ReusableFilterUI.this.getFilter().getDescription() != null) {
                ReusableFilterUI.this.getFilter().getDescription().setValue(description);
            } else {
                try {
                    ReusableFilterUI.this.getFilter().createDescription(null).setValue(description);
                }
                catch (J2eeCreateException e) {
                    ReusableFilterUI.this.handleJ2eeCreateException("description", e);
                }
            }
            ReusableFilterUI.this.handleEvent();
        }

        public void setDisplayName(String displayName) {
            if (ReusableFilterUI.this.getFilter().getDisplayName() != null) {
                ReusableFilterUI.this.getFilter().getDisplayName().setValue(displayName);
            } else {
                try {
                    ReusableFilterUI.this.getFilter().createDisplayName(null).setValue(displayName);
                }
                catch (J2eeCreateException e) {
                    ReusableFilterUI.this.handleJ2eeCreateException("display-name", e);
                }
            }
            ReusableFilterUI.this.handleEvent();
        }

        private IIcon getIcon() {
            IIcon icon = ReusableFilterUI.this.getFilter().getIcon();
            if (icon == null) {
                try {
                    icon = ReusableFilterUI.this.getFilter().createIcon(null);
                }
                catch (J2eeCreateException e) {
                    ReusableFilterUI.this.handleJ2eeCreateException("icon", e);
                }
            }
            return icon;
        }

        public void setLargeIcon(String largeIcon) {
            IIcon icon = this.getIcon();
            if (icon.getLargeIcon() != null) {
                icon.getLargeIcon().setValue(largeIcon);
            } else {
                try {
                    icon.createLargeIcon(null).setValue(largeIcon);
                }
                catch (J2eeCreateException e) {
                    ReusableFilterUI.this.handleJ2eeCreateException("large-icon", e);
                }
            }
            ReusableFilterUI.this.handleEvent();
        }

        public void setSmallIcon(String smallIcon) {
            IIcon icon = this.getIcon();
            if (icon.getSmallIcon() != null) {
                icon.getSmallIcon().setValue(smallIcon);
            } else {
                try {
                    icon.createSmallIcon(null).setValue(smallIcon);
                }
                catch (J2eeCreateException e) {
                    ReusableFilterUI.this.handleJ2eeCreateException("small-icon", e);
                }
            }
            ReusableFilterUI.this.handleEvent();
        }

        public boolean isIconsChecked() {
            IIcon icon = ReusableFilterUI.this.getFilter() != null ? ReusableFilterUI.this.getFilter().getIcon() : null;
            return icon != null;
        }

        public void setIconsChecked(boolean checkFlag) {
            if (ReusableFilterUI.this.getFilter() != null) {
                if (checkFlag) {
                    if (!this.isIconsChecked()) {
                        try {
                            ReusableFilterUI.this.getFilter().createIcon(null);
                        }
                        catch (J2eeCreateException e) {
                            ReusableFilterUI.this.handleJ2eeCreateException("icon", e);
                        }
                    }
                } else {
                    ReusableFilterUI.this.getFilter().removeIcon();
                }
                ReusableFilterUI.this.handleEvent();
            }
        }
    }
}

