/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IContextParam;
import com.tssap.j2ee.model.web.dd.IDescription;
import com.tssap.j2ee.model.web.dd.IParamName;
import com.tssap.j2ee.model.web.dd.IParamValue;
import com.tssap.j2ee.ui.ParentHolder;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class ReusableContextUI
extends RefreshObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableContextUI == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableContextUI = ReusableContextUI.class$("com.tssap.j2ee.ui.web.editor.internal.ui.ReusableContextUI")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableContextUI));
    private Text contextNameTextField;
    private Text contextValueTextField;
    private Text descriptionTextPane;
    private boolean modifyCallbackActive = true;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$ReusableContextUI;

    public String getTitle() {
        return " ";
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Context Name");
        this.contextNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Context Value");
        this.contextValueTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this.contextNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.contextValueTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this.descriptionTextPane.addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public void refreshDataFromUI() {
        super.refreshDataFromUI();
        if (this.getContextParam() != null) {
            this.refreshContextFromUI();
        }
    }

    private void refreshContextFromUI() {
        String METHOD = "refreshContextFromUI";
        if (this.getContextParam() != null) {
            String descrValue;
            String value = this.contextNameTextField.getText().trim();
            IParamName paramName = this.getContextParam().getParamName();
            if (paramName != null) {
                paramName.setValue(value);
            }
            this.setTitle(value);
            value = this.contextValueTextField.getText().trim();
            IParamValue contextValue = this.getContextParam().getParamValue();
            if (contextValue != null) {
                contextValue.setValue(value);
            }
            if ((descrValue = this.descriptionTextPane.getText()) != null && descrValue.trim().length() != 0) {
                IDescription descr = this.getContextParam().getDescription();
                try {
                    if (descr == null) {
                        descr = this.getContextParam().createDescription(null);
                    }
                    descr.setValue(descrValue.trim());
                }
                catch (J2eeCreateException e) {
                    tracer.error(METHOD, "Element could not be created: " + e.toString(), (Throwable)e);
                }
            } else {
                this.getContextParam().removeDescription();
            }
        }
    }

    public void refreshUIFromData() {
        super.refreshUIFromData();
        try {
            this.modifyCallbackActive = false;
            if (this.getContextParam() != null) {
                String name;
                if (this.getContextParam().getParamName() != null) {
                    name = this.getContextParam().getParamName().getValue();
                    if (name.trim().length() == 0) {
                        name = "<fill in context-name>";
                    }
                    this.contextNameTextField.setText(name);
                    this.setTitle(name);
                }
                if (this.getContextParam().getParamValue() != null) {
                    name = this.getContextParam().getParamValue().getValue();
                    this.contextValueTextField.setText(name);
                }
                if (this.getContextParam().getDescription() != null) {
                    String description = this.getContextParam().getDescription().getValue();
                    this.descriptionTextPane.setText(description);
                } else {
                    this.descriptionTextPane.setText("");
                }
            }
            Object var3_2 = null;
            this.modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String contextName = this.contextNameTextField.getText();
        if (contextName.equals("") || contextName.equals("<fill in context-name>")) {
            status.setError("Please enter a context parameter name.");
        }
        return status;
    }

    private IContextParam getContextParam() {
        ParentHolder parentHolder = (ParentHolder)this.getData();
        if (parentHolder == null) {
            return null;
        }
        Object value = parentHolder.getValue();
        IContextParam result = null;
        if (value instanceof IContextParam) {
            result = (IContextParam)value;
        }
        return result;
    }

    protected void handleParamModifyEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        this.refreshContextFromUI();
        super.handleEvent();
    }

    protected void handleEvent() {
        if (!this.modifyCallbackActive) {
            return;
        }
        super.handleEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ReusableContextUI.this.handleParamModifyEvent();
        }
    }
}

