/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IMimeMapping;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class MimeMappingEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$MimeMappingEditorComponent == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$MimeMappingEditorComponent = MimeMappingEditorComponent.class$("com.tssap.j2ee.ui.web.editor.internal.ui.MimeMappingEditorComponent")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$MimeMappingEditorComponent));
    private IModifiedCallback myModifyCallback;
    private IMimeMapping mimeMapping;
    private Text extensionTextfield;
    private Text mimeTypeTextField;
    private IWebApp webApp;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$MimeMappingEditorComponent;

    public MimeMappingEditorComponent(IWebApp webApp) {
        this.webApp = webApp;
    }

    public MimeMappingEditorComponent(String title) {
        super(title);
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Extension ");
        this.extensionTextfield = userArea.addTextField(false, userArea.createGridLayoutData(4, 4, true, false));
        this.setExtensionTextfield(this.extensionTextfield);
        userArea.addTextLabel("MIME Type ");
        this.mimeTypeTextField = userArea.addTextField(false, userArea.createGridLayoutData(4, 4, true, false));
        this.setMimeTypeTextField(this.mimeTypeTextField);
        this.getExtensionTextfield().addModifyListener((ModifyListener)new ExtensionModifyListener());
        this.getMimeTypeTextField().addModifyListener(this.getModifyAdapterSingleton());
    }

    public void refreshDataFromUI() {
        String mimeTypeTxt;
        if (this.isRefreshingUI()) {
            return;
        }
        this.refreshExtensionFromUI();
        if ((IMimeMapping)this.getData() != null && !(mimeTypeTxt = this.getMimeTypeTextField().getText().trim()).equals("")) {
            if (((IMimeMapping)this.getData()).getMimeType() == null) {
                try {
                    ((IMimeMapping)this.getData()).createMimeType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<mime-type> could not be created.", e);
                }
            }
            ((IMimeMapping)this.getData()).getMimeType().setValue(mimeTypeTxt);
        }
    }

    private void refreshExtensionFromUI() {
        String extensionText;
        if ((IMimeMapping)this.getData() != null && !(extensionText = this.getExtensionTextfield().getText().trim()).equals("")) {
            if (((IMimeMapping)this.getData()).getExtension() == null) {
                try {
                    ((IMimeMapping)this.getData()).createExtension(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<extension> could not be created.", e);
                }
            }
            ((IMimeMapping)this.getData()).getExtension().setValue(extensionText);
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        if (this.getData() instanceof IMimeMapping) {
            this.mimeMapping = (IMimeMapping)this.getData();
            if (this.mimeMapping != null) {
                this.getExtensionTextfield().setText(this.mimeMapping.getExtension().getValue());
                this.getMimeTypeTextField().setText(this.mimeMapping.getMimeType().getValue());
            }
        }
        this.stopRefreshingUI();
    }

    protected void handleExtensionChangedEvent() {
        this.refreshExtensionFromUI();
        super.handleEvent();
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private Text getExtensionTextfield() {
        return this.extensionTextfield;
    }

    private void setExtensionTextfield(Text text) {
        this.extensionTextfield = text;
    }

    private Text getMimeTypeTextField() {
        return this.mimeTypeTextField;
    }

    private void setMimeTypeTextField(Text text) {
        this.mimeTypeTextField = text;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public Object getData() {
        return this.mimeMapping;
    }

    public void setData(Object data) {
        if (!(data instanceof IMimeMapping)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof ");
        }
        this.mimeMapping = (IMimeMapping)data;
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getExtensionTextfield().getText().equals("") || this.getMimeTypeTextField().getText().equals("")) {
            status.setError("Please assign values for both extension and mime-type.");
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ExtensionModifyListener
    implements ModifyListener {
        private ExtensionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MimeMappingEditorComponent.this.handleExtensionChangedEvent();
        }
    }
}

