/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.web.dd.IHttpMethod;
import com.tssap.j2ee.model.web.dd.IWebResourceCollection;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;

public class HttpMethodEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$HttpMethodEditorComponent == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$HttpMethodEditorComponent = HttpMethodEditorComponent.class$("com.tssap.j2ee.ui.web.editor.internal.ui.HttpMethodEditorComponent")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$HttpMethodEditorComponent));
    private IModifiedCallback myModifyCallback;
    private IWebResourceCollection webResourceCollection;
    private IHttpMethod httpMethod;
    private Combo httpMethodsCombo;
    private final String[] HTTPMETHODS = new String[]{"GET", "POST", "TRACE", "DELETE", "CONNECT", "PUT", "HEAD", "OPTIONS"};
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$HttpMethodEditorComponent;

    public HttpMethodEditorComponent(IWebResourceCollection webResourceCollection) {
        this.webResourceCollection = webResourceCollection;
    }

    public HttpMethodEditorComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        if (this.getData() instanceof IHttpMethod) {
            this.httpMethod = (IHttpMethod)this.getData();
            int i = 0;
            while (i < this.HTTPMETHODS.length) {
                if (this.httpMethod.getValue().equalsIgnoreCase(this.HTTPMETHODS[i])) {
                    this.getHttpMethodsCombo().setText(this.httpMethod.getValue());
                }
                ++i;
            }
        }
        this.stopRefreshingUI();
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
        this.refreshUrlPatternFromUI();
    }

    private void refreshUrlPatternFromUI() {
        if (this.getHttpMethodsCombo().getText() != null && !this.getHttpMethodsCombo().getText().equals("")) {
            ((IHttpMethod)this.getData()).setValue(this.getHttpMethodsCombo().getText());
        }
    }

    public void setData(Object data) {
        if (!(data instanceof IHttpMethod)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof IHttpMethod");
        }
        this.httpMethod = (IHttpMethod)data;
    }

    public Object getData() {
        return this.httpMethod;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String tag = "";
        ArrayList<String> httpMethodsList = new ArrayList<String>();
        int i = 0;
        while (i < this.HTTPMETHODS.length) {
            httpMethodsList.add(this.HTTPMETHODS[i]);
            ++i;
        }
        if (!httpMethodsList.contains(this.getHttpMethodsCombo().getText())) {
            status.setError("The chosen HTTP method is not valid!");
        }
        return status;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("HTTP Methods ", userArea.createGridLayoutData(true, false));
        this.httpMethodsCombo = userArea.addComboBox(this.HTTPMETHODS, "", true, userArea.createGridLayoutData(4, 4));
        this.setHttpMethodsCombo(this.httpMethodsCombo);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getHttpMethodsCombo().addModifyListener((ModifyListener)new HttpMethodModifyAdapter());
    }

    private void handleHttpMethodChangedEvent() {
        this.refreshUrlPatternFromUI();
        super.handleEvent();
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private Combo getHttpMethodsCombo() {
        return this.httpMethodsCombo;
    }

    private void setHttpMethodsCombo(Combo combo) {
        this.httpMethodsCombo = combo;
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
    }

    protected void updateEditableBehavior() {
        if (this.getHttpMethodsCombo() != null) {
            this.getHttpMethodsCombo().setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HttpMethodModifyAdapter
    implements ModifyListener {
        private HttpMethodModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (HttpMethodEditorComponent.super.isRefreshingUI()) {
                return;
            }
            HttpMethodEditorComponent.this.handleHttpMethodChangedEvent();
            HttpMethodEditorComponent.this.dataModified(true);
        }
    }
}

