/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal.ui;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.web.dd.IFilterMapping;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.RefreshObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IRadioChooser;
import com.tssap.util.ui.reuse.chooser.impl.RadioChooser;
import com.tssap.util.ui.reuse.radio.IRadioButtonComponent;
import com.tssap.util.ui.reuse.radio.RadioButtonComponent;
import com.tssap.util.ui.reuse.radio.RadioButtonComponentEventData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class FilterMappingEditorComponent
extends RefreshObjectEditorComponent
implements IObjectEditorComponent,
IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$ui$FilterMappingEditorComponent == null ? (class$com$tssap$j2ee$ui$web$editor$internal$ui$FilterMappingEditorComponent = FilterMappingEditorComponent.class$("com.tssap.j2ee.ui.web.editor.internal.ui.FilterMappingEditorComponent")) : class$com$tssap$j2ee$ui$web$editor$internal$ui$FilterMappingEditorComponent));
    private static final int UNKNOWN = -1;
    private static final int URL_PATTERN_CHOOSER = 0;
    private static final int SERVLET_NAME_CHOOSER = 1;
    private static final int NUM_OF_COLS = 2;
    private static final String PAGE_NAME = "Mapping";
    private int currentSelection = -1;
    private IModifiedCallback myModifyCallback;
    private IFilterMapping filterMapping;
    private Text filterNameTextField;
    private InnerRadioButtonAdapter typeRadioComponentAdapter = null;
    private IRadioButtonComponent typeRadioComponent;
    private IWebApp webApp;
    private IRadioChooser[] radioChoosers;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$ui$FilterMappingEditorComponent;

    public FilterMappingEditorComponent(IWebApp webApp) {
        this.webApp = webApp;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public FilterMappingEditorComponent(String title) {
        super(title);
    }

    public void dataModified(boolean modified) {
        this.getModifiedCallback().dataModified(modified);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel(" Filter name ");
        this.filterNameTextField = userArea.addTextField(true, userArea.createGridLayoutData(4, 4, true, false));
        this.setFilterNameTextField(this.filterNameTextField);
        this.radioChoosers = new IRadioChooser[2];
        this.radioChoosers[0] = new RadioChooser("URL pattern", "", "", "...", null, null);
        this.radioChoosers[1] = new RadioChooser("Servlet name", "", "", "...", null, null);
        this.typeRadioComponent = new RadioButtonComponent("", this.radioChoosers, true, 0);
        this.typeRadioComponent.setSelectorHasPushButton(false);
        this.typeRadioComponentAdapter = new InnerRadioButtonAdapter();
        this.typeRadioComponent.addModifyListener((ModifyListener)this.typeRadioComponentAdapter);
        this.typeRadioComponent.createPartControl(userArea, true, false);
        this.setTypeRadioComponent(this.typeRadioComponent);
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI()) {
            return;
        }
    }

    public void refreshUIFromData() {
        this.startRefreshingUI();
        if (this.getData() instanceof IFilterMapping) {
            this.filterMapping = (IFilterMapping)this.getData();
            if (this.filterMapping != null) {
                this.getFilterNameTextField().setText(this.filterMapping.getFilterName().getValue());
                this.typeRadioComponentAdapter.setListening(false);
                this.typeRadioComponentAdapter.setFilterMapping(this.filterMapping);
                if (this.typeRadioComponentAdapter != null) {
                    if (!this.typeRadioComponentAdapter.getUrlPattern(this.filterMapping).equals("")) {
                        this.getTypeRadioComponent().getRadioChooser(1).setTextEntry("");
                        this.getTypeRadioComponent().setSelectionIndex(0);
                        this.getTypeRadioComponent().setDeselectionIndex(1);
                        this.getTypeRadioComponent().getRadioChooser(0).setTextEntry(this.typeRadioComponentAdapter.getUrlPattern(this.filterMapping));
                    } else if (!this.typeRadioComponentAdapter.getServletName(this.filterMapping).equals("")) {
                        this.getTypeRadioComponent().getRadioChooser(0).setTextEntry("");
                        this.getTypeRadioComponent().setSelectionIndex(1);
                        this.getTypeRadioComponent().setDeselectionIndex(0);
                        this.getTypeRadioComponent().getRadioChooser(1).setTextEntry(this.typeRadioComponentAdapter.getServletName(this.filterMapping));
                    } else {
                        this.getTypeRadioComponent().getRadioChooser(0).setTextEntry("");
                        this.getTypeRadioComponent().getRadioChooser(1).setTextEntry("");
                    }
                }
                this.getTypeRadioComponent().refresh();
                this.typeRadioComponentAdapter.setListening(true);
            }
        }
        this.stopRefreshingUI();
    }

    private Text getFilterNameTextField() {
        return this.filterNameTextField;
    }

    private void setFilterNameTextField(Text text) {
        this.filterNameTextField = text;
    }

    private IRadioButtonComponent getTypeRadioComponent() {
        return this.typeRadioComponent;
    }

    private void setTypeRadioComponent(IRadioButtonComponent component) {
        this.typeRadioComponent = component;
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.getFilterNameTextField() != null) {
            this.getFilterNameTextField().setEditable(false);
        }
        if (this.getTypeRadioComponent() != null) {
            this.getTypeRadioComponent().setEditable(this.isEditable());
        }
    }

    public Object getData() {
        return this.filterMapping;
    }

    public void setData(Object data) {
        if (!(data instanceof IFilterMapping)) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof IFilterMapping");
        }
        this.filterMapping = (IFilterMapping)data;
    }

    public String okToLeave() {
        String message = super.okToLeave();
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getTypeRadioComponent().getRadioChooser(this.getTypeRadioComponent().getSelectionIndex()).getTextEntry().equals("")) {
            status.setError("Please enter a value for URL Pattern or Servlet Name.");
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerRadioButtonAdapter
    implements ModifyListener {
        private IFilterMapping filterMapping;
        private boolean listening = true;

        private InnerRadioButtonAdapter() {
        }

        public void modifyText(ModifyEvent evt) {
            if (this.isListening() && this.filterMapping != null && evt.data instanceof RadioButtonComponentEventData && evt.getSource() instanceof Text && !FilterMappingEditorComponent.super.isRefreshingUI()) {
                String newValue = ((Text)evt.getSource()).getText();
                RadioButtonComponentEventData evData = (RadioButtonComponentEventData)evt.data;
                int index = evData.getIndex();
                switch (index) {
                    case 0: {
                        this.setUrlPattern(newValue);
                        FilterMappingEditorComponent.this.getTypeRadioComponent().getRadioChooser(0).setTextEntry(newValue);
                        FilterMappingEditorComponent.this.getTypeRadioComponent().getRadioChooser(1).setTextEntry("");
                        this.filterMapping.removeServletName();
                        FilterMappingEditorComponent.this.dataModified(true);
                        break;
                    }
                    case 1: {
                        this.setServletName(newValue);
                        FilterMappingEditorComponent.this.getTypeRadioComponent().getRadioChooser(1).setTextEntry(newValue);
                        FilterMappingEditorComponent.this.getTypeRadioComponent().getRadioChooser(0).setTextEntry("");
                        this.filterMapping.removeUrlPattern();
                        FilterMappingEditorComponent.this.dataModified(true);
                        break;
                    }
                    default: {
                        tracer.error(this.getClass(), "modifyText(evt)", " Error: Illegal Argument provided (index). ");
                    }
                }
            }
        }

        public String getUrlPattern(IFilterMapping filterMapping) {
            String urlPattern = null;
            if (filterMapping != null) {
                urlPattern = MutableUtil.mutableToValue((IMutable)filterMapping.getUrlPattern());
            }
            return urlPattern;
        }

        public String getServletName(IFilterMapping filterMapping) {
            String servletName = null;
            if (filterMapping != null) {
                servletName = MutableUtil.mutableToValue((IMutable)filterMapping.getServletName());
            }
            return servletName;
        }

        public void setUrlPattern(String urlPattern) {
            if (this.filterMapping != null) {
                if (this.filterMapping.getUrlPattern() == null) {
                    try {
                        this.filterMapping.createUrlPattern(null);
                    }
                    catch (J2eeCreateException ex) {
                        FilterMappingEditorComponent.this.handleJ2eeCreateException("<url-pattern> tag could not be created.", ex);
                    }
                }
                this.filterMapping.getUrlPattern().setValue(urlPattern);
                FilterMappingEditorComponent.this.dataModified(true);
            }
        }

        public void setServletName(String servletName) {
            if (this.filterMapping != null) {
                if (this.filterMapping.getServletName() == null) {
                    try {
                        this.filterMapping.createServletName(null);
                    }
                    catch (J2eeCreateException ex) {
                        FilterMappingEditorComponent.this.handleJ2eeCreateException("<servlet-name> tag could not be created.", ex);
                    }
                }
                this.filterMapping.getServletName().setValue(servletName);
                FilterMappingEditorComponent.this.dataModified(true);
            }
        }

        public boolean isListening() {
            return this.listening;
        }

        public void setListening(boolean listening) {
            this.listening = listening;
        }

        public IFilterMapping getFilterMapping() {
            return this.filterMapping;
        }

        public void setFilterMapping(IFilterMapping filterMapping) {
            this.filterMapping = filterMapping;
        }
    }
}

