/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.web.dd.ISecurityRole;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.GenericReferencesCheck;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.RefPrjResourceChooserCB;
import com.tssap.j2ee.ui.editor.editcomponents.SecurityRoleWrapper;
import com.tssap.j2ee.ui.editor.editcomponents.WebEditorManager;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.j2ee.ui.web.editor.internal.WebOtherPageTreeCP;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.IWebAppHolder;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class WebSecurityRolePage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage = WebSecurityRolePage.class$("com.tssap.j2ee.ui.web.editor.internal.WebSecurityPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage));
    private static final int NUM_OF_COLS = 1;
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private WebSecurityRolePageTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage;

    public WebSecurityRolePage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.myTreeSelector.setTreeInput((Object)webApp);
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return "Security Roles";
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector();
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeEditor.setReusableManager((IReuseableManager)new MyReusableManager());
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeContentProvider = new WebSecurityRolePageTreeCP();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        IResourceChooserCallback resourceChooserCallback;

        MySelectionConverter() {
            this.resourceChooserCallback = new RefPrjResourceChooserCB(WebSecurityRolePage.this.getUnderlyingFile().getProject());
        }

        public Object convertSelection(Object selectedObject) {
            if (selectedObject instanceof ISecurityRole) {
                IWebApp webApp = WebSecurityRolePage.this.myTreeContentProvider.getWebAppHolder().getWebApp();
                return new SecurityRoleWrapper(this.resourceChooserCallback, webApp, (ISecurityRole)selectedObject);
            }
            return new WebOtherPageDataWrapper(this.resourceChooserCallback, selectedObject);
        }
    }

    class MyReusableManager
    implements IReuseableManager {
        MyReusableManager() {
        }

        public IReuseable getReusable(Object obj) {
            return WebEditorManager.getObjectEditorComponent((Object)obj);
        }
    }

    private class WebSecurityRolePageTreeCP
    extends LabelProvider
    implements ITreeContentProvider {
        private final Image IMG_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
        private Image iSecurityRole = UIPlugin.getImage((String)"SecurityRole");
        private final Object[] EMPTY_OBJ_AR = new Object[0];
        private final WebOtherPageTreeCP.WebAppHolder webAppHolder = new WebOtherPageTreeCP.WebAppHolder();
        private final SecurityRolesFolder securityRolesFolder = new SecurityRolesFolder(this.webAppHolder);
        private final Object[] roots = new Object[]{this.securityRolesFolder};
        private Object[] activeRoots;

        private WebSecurityRolePageTreeCP() {
        }

        private void setWebApp(IWebApp webApp) {
            this.webAppHolder.setWebApp(webApp);
        }

        public Object[] getChildren(Object parentElement) {
            IWebApp webApp;
            Object[] ret = this.EMPTY_OBJ_AR;
            if (parentElement instanceof SecurityRolesFolder && (webApp = ((SecurityRolesFolder)parentElement).getWebApp()) != null && parentElement instanceof SecurityRolesFolder) {
                ret = webApp.getSecurityRoles();
            }
            return ret;
        }

        public Object[] getElements(Object inputElement) {
            return this.activeRoots;
        }

        public Object getParent(Object child) {
            SecurityRolesFolder ret = null;
            if (child instanceof ISecurityRole) {
                ret = this.securityRolesFolder;
            }
            return ret;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IWebApp) {
                this.webAppHolder.setWebApp((IWebApp)newInput);
                this.activeRoots = this.roots;
            } else {
                this.activeRoots = this.EMPTY_OBJ_AR;
            }
        }

        public Image getImage(Object element) {
            Image retImage = super.getImage(element);
            if (element instanceof SecurityRolesFolder) {
                retImage = this.IMG_FOLDER;
            } else if (element instanceof ISecurityRole) {
                retImage = this.iSecurityRole;
            }
            return retImage;
        }

        public String getText(Object element) {
            String retText = super.getText(element);
            if (element instanceof ISecurityRole) {
                retText = ((ISecurityRole)element).getRoleName() != null ? ((ISecurityRole)element).getRoleName().getValue() : "defaultRole";
            }
            return retText;
        }

        private WebOtherPageTreeCP.WebAppHolder getWebAppHolder() {
            return this.webAppHolder;
        }

        public class SecurityRolesFolder
        implements IWebAppHolder {
            private WebOtherPageTreeCP.WebAppHolder myWebAppHolder;

            public IWebApp getWebApp() {
                return this.myWebAppHolder.getWebApp();
            }

            protected SecurityRolesFolder(WebOtherPageTreeCP.WebAppHolder webAppHolder) {
                this.myWebAppHolder = webAppHolder;
            }

            public String toString() {
                return "SecurityRoles";
            }
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        private static final String DEFAULT_NAME_PREFIX = "DefaultSecurityRole";

        AddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            IWebApp webApp;
            ISecurityRole securityRole = null;
            ISecurityRole ret = null;
            Object parent = WebSecurityRolePage.this.myTreeContentProvider.getParent(currentSelection);
            Object selection = parent != null ? parent : currentSelection;
            boolean type = false;
            if (selection instanceof WebSecurityRolePageTreeCP.SecurityRolesFolder && (webApp = ((WebSecurityRolePageTreeCP.SecurityRolesFolder)selection).getWebApp()) != null) {
                try {
                    securityRole = webApp.createSecurityRole(null);
                    String defaultEnvEntryName = this.getDefaultSecRoleName(webApp);
                    securityRole.createRoleName(null).setValue(defaultEnvEntryName);
                }
                catch (J2eeCreateException e) {
                    WebSecurityRolePage.this.handleJ2eeCreateException("<security-role> tag could not be created.", e);
                }
                ret = securityRole;
            }
            return ret;
        }

        private String getDefaultSecRoleName(IWebApp webApp) {
            String defaultSecRoleName = "<..>";
            String suffix = "";
            ISecurityRole[] securityRoleArr = null;
            int prefix = 0;
            if (webApp != null) {
                defaultSecRoleName = DEFAULT_NAME_PREFIX;
                securityRoleArr = webApp.getSecurityRoles();
                if (securityRoleArr != null) {
                    int i = 0;
                    while (i < securityRoleArr.length) {
                        if (securityRoleArr[i].getRoleName() != null && securityRoleArr[i].getRoleName().getValue().equalsIgnoreCase(defaultSecRoleName)) {
                            defaultSecRoleName = DEFAULT_NAME_PREFIX + String.valueOf(++prefix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                }
                securityRoleArr = null;
            }
            return defaultSecRoleName;
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof WebSecurityRolePageTreeCP.SecurityRolesFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebSecurityRolePage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof WebSecurityRolePageTreeCP.SecurityRolesFolder) {
                IWebApp parentWebApp = ((WebSecurityRolePageTreeCP.SecurityRolesFolder)parentObj).getWebApp();
                if (currentSelection instanceof ISecurityRole) {
                    parentWebApp.removeSecurityRole((ISecurityRole)currentSelection);
                    GenericReferencesCheck genericReferencesCheck = new GenericReferencesCheck((IIdentifiable)parentWebApp, (Object)((ISecurityRole)currentSelection));
                }
            }
            return true;
        }
    }
}

