/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.ISecurityConstraint;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.BaseFolder;
import com.tssap.j2ee.ui.web.editor.internal.SecurityConstraintsReuseableManager;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.j2ee.ui.web.editor.internal.WebOtherPageTreeCP;
import com.tssap.j2ee.ui.web.editor.internal.WebSecurityConstraintsWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class WebSecurityPage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage = WebSecurityPage.class$("com.tssap.j2ee.ui.web.editor.internal.WebSecurityPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage));
    private static final String PAGENAME = "Security";
    private static final int NUM_OF_COLS = 1;
    private IWebApp currentWebApp = null;
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private SecurityPageTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebSecurityPage;

    public WebSecurityPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.currentWebApp = webApp;
        this.myTreeSelector.setTreeInput((Object)webApp);
        SecurityConstraintsReuseableManager.webApp = webApp;
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return PAGENAME;
    }

    protected Control createControls(IGridLayoutPane gridPane) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(2);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeContentProvider = new SecurityPageTreeCP();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(gridPane);
        return gridPane.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
        this.myTreeEditor.setReusableManager((IReuseableManager)new SecurityConstraintsReuseableManager());
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        this.myTreeSelector.setEditable(editable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        MySelectionConverter() {
        }

        public Object convertSelection(Object selectedObject) {
            IWebApp webApp = null;
            if (selectedObject instanceof ISecurityConstraint) {
                webApp = WebSecurityPage.this.myTreeContentProvider.getWebAppHolder().getWebApp();
                return new WebSecurityConstraintsWrapper(webApp, (ISecurityConstraint)selectedObject);
            }
            return null;
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        private static final String TXT_DEFAULT_WEB_RES_NAME = "WebResource";
        private final String PREFIX = "SecurityConstraint";

        AddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            Object selection;
            ISecurityConstraint ret = null;
            Object parent = WebSecurityPage.this.myTreeContentProvider.getParent(currentSelection);
            Object object = selection = parent != null ? parent : currentSelection;
            if (selection instanceof SecurityPageTreeCP.SecurityConstraintsFolder || selection instanceof ISecurityConstraint) {
                String defaultSecurityConstrName = this.getDefaultSecurityConstrName(WebSecurityPage.this.currentWebApp);
                try {
                    WebSecurityPage.this.currentWebApp = ((SecurityPageTreeCP.SecurityConstraintsFolder)selection).getWebApp();
                    ISecurityConstraint securityConstraint = WebSecurityPage.this.currentWebApp.createSecurityConstraint(null);
                    securityConstraint.createDisplayName(null).setValue(defaultSecurityConstrName);
                    securityConstraint.createWebResourceCollection(null).createWebResourceName(null).setValue(TXT_DEFAULT_WEB_RES_NAME);
                    ret = securityConstraint;
                }
                catch (J2eeCreateException e) {
                    tracer.error("AddRemoveCallback", "addElement(Object currentSelection)", "<security-constraint> or <display-name> could not be created.", (Throwable)e);
                }
            }
            return ret;
        }

        private String getDefaultSecurityConstrName(IWebApp webApp) {
            String defaultSecurityConstrName = "SecurityConstraint";
            int suffix = 0;
            ISecurityConstraint[] securityConstraintArr = null;
            if (webApp != null) {
                securityConstraintArr = webApp.getSecurityConstraints();
                if (securityConstraintArr != null) {
                    int i = 0;
                    while (i < securityConstraintArr.length) {
                        if (securityConstraintArr[i].getDisplayName() != null && securityConstraintArr[i].getDisplayName().getValue().equalsIgnoreCase(defaultSecurityConstrName)) {
                            defaultSecurityConstrName = "SecurityConstraint" + String.valueOf(++suffix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                }
                securityConstraintArr = null;
            }
            return defaultSecurityConstrName;
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof BaseFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebSecurityPage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof BaseFolder) {
                IWebApp parentWebApp = ((BaseFolder)parentObj).getWebApp();
                if (currentSelection instanceof ISecurityConstraint) {
                    parentWebApp.removeSecurityConstraint((ISecurityConstraint)currentSelection);
                }
            }
            return true;
        }
    }

    private class SecurityPageTreeCP
    extends J2eeModelLabelProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private final Image IMG_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
        private final Object[] EMPTY_OBJ_AR = new Object[0];
        private final WebOtherPageTreeCP.WebAppHolder webAppHolder = new WebOtherPageTreeCP.WebAppHolder();
        private final SecurityConstraintsFolder securityConstraintsFolder = new SecurityConstraintsFolder(this.webAppHolder);
        private final Object[] roots = new Object[]{this.securityConstraintsFolder};
        private Object[] activeRoots;

        private SecurityPageTreeCP() {
        }

        private void setWebApp(IWebApp webApp) {
            this.webAppHolder.setWebApp(webApp);
        }

        public Object[] getChildren(Object parentElement) {
            IWebApp webApp;
            Object[] ret = this.EMPTY_OBJ_AR;
            if (parentElement instanceof BaseFolder && (webApp = ((BaseFolder)parentElement).getWebApp()) != null && parentElement instanceof SecurityConstraintsFolder) {
                ret = webApp.getSecurityConstraints();
            }
            return ret;
        }

        public Object[] getElements(Object inputElement) {
            return this.activeRoots;
        }

        public Image getImage(Object element) {
            Image retImage = super.getImage(element);
            if (element instanceof BaseFolder) {
                retImage = this.IMG_FOLDER;
            }
            return retImage;
        }

        public Object getParent(Object element) {
            SecurityConstraintsFolder ret = null;
            if (element instanceof ISecurityConstraint) {
                ret = this.securityConstraintsFolder;
            }
            return ret;
        }

        public String getText(Object element) {
            String retText = super.getText(element);
            return retText;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IWebApp) {
                this.webAppHolder.setWebApp((IWebApp)newInput);
                this.activeRoots = this.roots;
            } else {
                this.activeRoots = this.EMPTY_OBJ_AR;
            }
        }

        public WebOtherPageTreeCP.WebAppHolder getWebAppHolder() {
            return this.webAppHolder;
        }

        private class SecurityConstraintsFolder
        extends BaseFolder {
            protected SecurityConstraintsFolder(WebOtherPageTreeCP.WebAppHolder webAppHolder) {
                super(webAppHolder);
            }

            public String toString() {
                return "Security Constraints";
            }
        }
    }
}

