/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IResourceEnvRef;
import com.tssap.j2ee.model.web.dd.IResourceRef;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.core.RefPrjResourceChooserCB;
import com.tssap.j2ee.ui.editor.editcomponents.ResourceRefWrapper;
import com.tssap.j2ee.ui.editor.editcomponents.WebEditorManager;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.ResourcePageTreeCP;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class WebResourcePage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebResourcePage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebResourcePage = WebResourcePage.class$("com.tssap.j2ee.ui.web.editor.internal.WebResourcePage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebResourcePage));
    private static final int NUM_OF_COLS = 1;
    private static final String PAGENAME = "Resource";
    private static final String DEFAULT_RES_ENV_SUFFIX = "DefaultResEnvEntry";
    private static final String DEFAULT_RES_SUFFIX = "DefaultResEntry";
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private ResourcePageTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebResourcePage;

    public WebResourcePage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.myTreeSelector.setTreeInput((Object)webApp);
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return PAGENAME;
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(2);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeEditor.setReusableManager((IReuseableManager)new MyReusableManager(this));
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeContentProvider = new ResourcePageTreeCP();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyReusableManager
    implements IReuseableManager {
        IModifiedCallback modifiedCallback;

        public MyReusableManager(IModifiedCallback modifiedCallback) {
            this.modifiedCallback = modifiedCallback;
        }

        public IReuseable getReusable(Object obj) {
            return WebEditorManager.getObjectEditorComponent((Object)obj, (IModifiedCallback)this.getModifiedCallback());
        }

        private IModifiedCallback getModifiedCallback() {
            return this.modifiedCallback;
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        IResourceChooserCallback resChooserCallback;

        MySelectionConverter() {
            this.resChooserCallback = new RefPrjResourceChooserCB(WebResourcePage.this.getUnderlyingFile().getProject());
        }

        public Object convertSelection(Object selectedObject) {
            if (selectedObject instanceof IResourceRef) {
                IWebApp webApp = WebResourcePage.this.myTreeContentProvider.getWebAppHolder().getWebApp();
                return new ResourceRefWrapper(this.resChooserCallback, webApp, (IResourceRef)selectedObject);
            }
            if (selectedObject instanceof IResourceEnvRef) {
                IWebApp webApp = WebResourcePage.this.myTreeContentProvider.getWebAppHolder().getWebApp();
                return new ResourceRefWrapper(this.resChooserCallback, webApp, (IResourceEnvRef)selectedObject);
            }
            return new WebOtherPageDataWrapper(this.resChooserCallback, selectedObject);
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        private static final int RESOURCE_ENTRIES = 0;
        private static final int RESOURCE_ENVIRONMENT_ENTRIES = 1;

        AddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            Object ret = null;
            Object parent = WebResourcePage.this.myTreeContentProvider.getParent(currentSelection);
            Object selection = parent != null ? parent : currentSelection;
            int type = 0;
            if (selection instanceof ResourcePageTreeCP.BaseFolder) {
                if (selection instanceof ResourcePageTreeCP.ResourceEntriesFolder) {
                    type = 0;
                } else if (selection instanceof ResourcePageTreeCP.ResourceEnvironmentEntriesFolder) {
                    type = 1;
                }
                ret = this.addChild(((ResourcePageTreeCP.BaseFolder)selection).getWebApp(), type);
            }
            return ret;
        }

        private Object addChild(IWebApp webApp, int type) {
            IResourceRef ret = null;
            try {
                switch (type) {
                    case 0: {
                        IResourceRef resourceRef = webApp.createResourceRef(null);
                        String defaultResEntryName = this.getDefaultResEntryName(webApp, 0);
                        resourceRef.createResRefName(null).setValue(defaultResEntryName);
                        resourceRef.createResType(null).setValue("javax.sql.DataSource");
                        ret = resourceRef;
                        break;
                    }
                    case 1: {
                        IResourceEnvRef resourceEnvRef = webApp.createResourceEnvRef(null);
                        String defaultResEnvEntryName = this.getDefaultResEntryName(webApp, 1);
                        resourceEnvRef.createResourceEnvRefName(null).setValue(defaultResEnvEntryName);
                        resourceEnvRef.createResourceEnvRefType(null).setValue("javax.jms.Queue");
                        ret = resourceEnvRef;
                        break;
                    }
                    default: {
                        tracer.error(this.getClass(), "addChild(webApp, type)", " Error: Illegal Argument provided (type). ");
                        break;
                    }
                }
            }
            catch (J2eeCreateException e) {
                WebResourcePage.this.handleJ2eeCreateException("<resource-ref> or <resource-env-ref> could not be created.", e);
            }
            return ret;
        }

        private String getDefaultResEntryName(IWebApp webApp, int type) {
            String defaultResEntryName = "<..>";
            String suffix = "";
            IResourceRef[] resourceRefArr = null;
            IResourceEnvRef[] resourceEnvRefArr = null;
            int prefix = 0;
            if (webApp != null) {
                switch (type) {
                    case 0: {
                        suffix = WebResourcePage.DEFAULT_RES_SUFFIX;
                        defaultResEntryName = "jdbc/" + suffix;
                        resourceRefArr = webApp.getResourceRefs();
                        if (resourceRefArr != null) {
                            int i = 0;
                            while (i < resourceRefArr.length) {
                                if (resourceRefArr[i].getResRefName() != null && resourceRefArr[i].getResRefName().getValue().equalsIgnoreCase(defaultResEntryName)) {
                                    defaultResEntryName = "jdbc/" + suffix + String.valueOf(++prefix);
                                    i = 0;
                                    continue;
                                }
                                ++i;
                            }
                        }
                        resourceRefArr = null;
                        break;
                    }
                    case 1: {
                        suffix = WebResourcePage.DEFAULT_RES_ENV_SUFFIX;
                        defaultResEntryName = "jms/" + suffix;
                        resourceEnvRefArr = webApp.getResourceEnvRefs();
                        if (resourceEnvRefArr == null) break;
                        int i = 0;
                        while (i < resourceEnvRefArr.length) {
                            if (resourceEnvRefArr[i].getResourceEnvRefName() != null && resourceEnvRefArr[i].getResourceEnvRefName().getValue().equalsIgnoreCase(defaultResEntryName)) {
                                defaultResEntryName = "jms/" + suffix + String.valueOf(++prefix);
                                i = 0;
                                continue;
                            }
                            ++i;
                        }
                        resourceEnvRefArr = null;
                        break;
                    }
                    default: {
                        tracer.error(this.getClass(), "getDefaultResEntryName(webApp, type)", " Error: Illegal Argument provided (type). ");
                    }
                }
            }
            return defaultResEntryName;
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof ResourcePageTreeCP.BaseFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebResourcePage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof ResourcePageTreeCP.BaseFolder) {
                IWebApp parentWebApp = ((ResourcePageTreeCP.BaseFolder)parentObj).getWebApp();
                if (currentSelection instanceof IResourceRef) {
                    parentWebApp.removeResourceRef((IResourceRef)currentSelection);
                } else if (currentSelection instanceof IResourceEnvRef) {
                    parentWebApp.removeResourceEnvRef((IResourceEnvRef)currentSelection);
                }
            }
            return true;
        }
    }
}

