/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.web.dd.IHttpMethod;
import com.tssap.j2ee.model.web.dd.ISecurityConstraint;
import com.tssap.j2ee.model.web.dd.IUrlPattern;
import com.tssap.j2ee.model.web.dd.IWebResourceCollection;
import com.tssap.j2ee.ui.Folder;
import com.tssap.j2ee.ui.TreeNode;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.web.editor.internal.BaseFolder;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.ISecurityConstraintsHolder;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class WebResourceCollectionTreeCP
extends J2eeModelLabelProvider
implements ITreeContentProvider,
ILabelProvider {
    private final Image IMG_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
    private final Object[] EMPTY_OBJ_AR = new Object[0];
    private final SecurityConstraintsHolder securityConstraintsHolder = new SecurityConstraintsHolder();
    private final WebResourceCollectionFolder webResourceCollectionFolder = new WebResourceCollectionFolder(this.securityConstraintsHolder);
    private UrlPatternFolderFactory urlPatternFolderFactory = new UrlPatternFolderFactory();
    private HttpMethodFolderFactory httpMethodFolderFactory = new HttpMethodFolderFactory();
    private UrlPatternFolder urlPatternFolder;
    private HttpMethodFolder httpMethodFolder;
    private final Object[] roots = new Object[]{this.webResourceCollectionFolder};
    private Object[] activeRoots;

    public Object[] getChildren(Object parentElement) {
        Object[] ret = this.EMPTY_OBJ_AR;
        if (parentElement instanceof WebResourceCollectionFolder) {
            ISecurityConstraint securityConstraint = ((WebResourceCollectionFolder)parentElement).getSecurityConstraint();
            if (securityConstraint != null) {
                ret = securityConstraint.getWebResourceCollections();
            }
        } else if (parentElement instanceof IWebResourceCollection) {
            this.urlPatternFolder = this.urlPatternFolderFactory.getInstance((IWebResourceCollection)parentElement);
            this.httpMethodFolder = this.httpMethodFolderFactory.getInstance((IWebResourceCollection)parentElement);
            ret = new Object[]{this.urlPatternFolder, this.httpMethodFolder};
        } else if (parentElement instanceof UrlPatternFolder) {
            ArrayList urlPatternNodesArL = ((UrlPatternFolder)parentElement).getTreeNodesArrayList();
            ret = urlPatternNodesArL.toArray(new Object[urlPatternNodesArL.size()]);
        } else if (parentElement instanceof HttpMethodFolder) {
            ArrayList httpMethodNodesArL = ((HttpMethodFolder)parentElement).getTreeNodesArrayList();
            ret = httpMethodNodesArL.toArray(new Object[httpMethodNodesArL.size()]);
        }
        return ret;
    }

    public Object[] getElements(Object inputElement) {
        return this.activeRoots;
    }

    public Object getParent(Object element) {
        Object ret = null;
        if (element instanceof IWebResourceCollection) {
            ret = this.webResourceCollectionFolder;
        } else if (element instanceof UrlPatternFolder) {
            ret = ((UrlPatternFolder)element).getWebResourceCollection();
        } else if (element instanceof HttpMethodFolder) {
            ret = ((HttpMethodFolder)element).getWebResourceCollection();
        } else if (element instanceof IUrlPattern) {
            ret = this.urlPatternFolder;
        } else if (element instanceof IHttpMethod) {
            ret = this.httpMethodFolder;
        }
        return ret;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ISecurityConstraint) {
            this.securityConstraintsHolder.setSecurityConstraint((ISecurityConstraint)newInput);
            this.activeRoots = this.roots;
        } else {
            this.activeRoots = this.EMPTY_OBJ_AR;
        }
    }

    public Image getImage(Object element) {
        Image retImage = super.getImage(element);
        if (element instanceof BaseFolder) {
            retImage = this.IMG_FOLDER;
        } else if (element instanceof TreeNode) {
            if (((TreeNode)element).getFolder() instanceof UrlPatternFolder) {
                return UIPlugin.getImage((String)"UrlPattern");
            }
            if (((TreeNode)element).getFolder() instanceof HttpMethodFolder) {
                return UIPlugin.getImage((String)"defaultMethod");
            }
        }
        return retImage;
    }

    public String getText(Object element) {
        String retText = super.getText(element);
        if (element instanceof WebResourceCollectionFolder) {
            retText = UIPlugin.TEXT_WEB_RESOURCE_COLLECTION_FOLDER;
        } else if (element instanceof IWebResourceCollection) {
            retText = ((IWebResourceCollection)element).getWebResourceName().getValue();
        } else if (element instanceof UrlPatternFolder) {
            retText = UIPlugin.TEXT_URL_PATTERN_FOLDER;
        } else if (element instanceof HttpMethodFolder) {
            retText = UIPlugin.TEXT_HTTP_METHODS_FOLDER;
        } else if (element instanceof TreeNode) {
            if (((TreeNode)element).getFolder() instanceof UrlPatternFolder) {
                IUrlPattern urlPattern = (IUrlPattern)((TreeNode)element).getIdentifiable();
                retText = urlPattern.getValue();
            } else if (((TreeNode)element).getFolder() instanceof HttpMethodFolder) {
                IHttpMethod httpMethod = (IHttpMethod)((TreeNode)element).getIdentifiable();
                retText = httpMethod.getValue();
            }
        }
        return retText;
    }

    private class HttpMethodFolderFactory {
        private HashMap httpMethodHashMap = new HashMap();

        private HttpMethodFolderFactory() {
        }

        public HttpMethodFolder getInstance(IWebResourceCollection webResourceCollection) {
            HttpMethodFolder ret = (HttpMethodFolder)this.httpMethodHashMap.get(webResourceCollection);
            if (ret == null) {
                ret = new HttpMethodFolder(webResourceCollection);
                this.httpMethodHashMap.put(webResourceCollection, ret);
            }
            return ret;
        }
    }

    private class UrlPatternFolderFactory {
        private HashMap urlPatternHashMap = new HashMap();

        private UrlPatternFolderFactory() {
        }

        public UrlPatternFolder getInstance(IWebResourceCollection webResourceCollection) {
            UrlPatternFolder ret = (UrlPatternFolder)this.urlPatternHashMap.get(webResourceCollection);
            if (ret == null) {
                ret = new UrlPatternFolder(webResourceCollection);
                this.urlPatternHashMap.put(webResourceCollection, ret);
            }
            return ret;
        }
    }

    static class SecurityConstraintsHolder
    implements ISecurityConstraintsHolder {
        private ISecurityConstraint securityConstraint;

        SecurityConstraintsHolder() {
        }

        public void setSecurityConstraint(ISecurityConstraint constraint) {
            this.securityConstraint = constraint;
        }

        public ISecurityConstraint getSecurityConstraint() {
            return this.securityConstraint;
        }
    }

    public class HttpMethodFolder
    implements Folder {
        IWebResourceCollection webResourceCollection;
        ArrayList treeNodesArL = null;
        ArrayList httpMethodArL = null;

        protected HttpMethodFolder(IWebResourceCollection webResourceCollection) {
            this.setWebResourceCollection(webResourceCollection);
        }

        private IHttpMethod[] getHttpMethods() {
            return this.webResourceCollection.getHttpMethods();
        }

        public IWebResourceCollection getWebResourceCollection() {
            return this.webResourceCollection;
        }

        public void setWebResourceCollection(IWebResourceCollection collection) {
            this.webResourceCollection = collection;
        }

        private void createTreeNodes() {
            IHttpMethod[] httpMethods = this.getHttpMethods();
            if (this.httpMethodArL == null) {
                this.httpMethodArL = new ArrayList();
            }
            if (this.treeNodesArL == null) {
                this.treeNodesArL = new ArrayList();
            }
            int i = 0;
            while (i < httpMethods.length) {
                if (!this.httpMethodArL.contains(httpMethods[i])) {
                    this.httpMethodArL.add(httpMethods[i]);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setFolder((Folder)this);
                    treeNode.setIdentifiable((IIdentifiable)httpMethods[i]);
                    this.treeNodesArL.add(treeNode);
                }
                ++i;
            }
        }

        public ArrayList getTreeNodesArrayList() {
            this.createTreeNodes();
            return this.treeNodesArL;
        }

        public void removeTreeNode(TreeNode treeNode) {
            ((AbstractCollection)this.treeNodesArL).remove(treeNode);
        }

        protected TreeNode getTreeNode(IHttpMethod httpMethod) {
            TreeNode httpMethodTreeNode;
            block2: {
                httpMethodTreeNode = null;
                if (!this.httpMethodArL.contains(httpMethod)) {
                    this.createTreeNodes();
                }
                int i = this.treeNodesArL.size() - 1;
                if (i < 0) break block2;
                if (this.treeNodesArL.get(i) != null && ((TreeNode)this.treeNodesArL.get(i)).getIdentifiable().equals(httpMethod)) {
                    httpMethodTreeNode = (TreeNode)this.treeNodesArL.get(i);
                }
            }
            return httpMethodTreeNode;
        }
    }

    public class UrlPatternFolder
    implements Folder {
        IWebResourceCollection webResourceCollection;
        ArrayList treeNodesArL = null;
        ArrayList urlPatternArL = null;

        protected UrlPatternFolder(IWebResourceCollection webResourceCollection) {
            this.setWebResourceCollection(webResourceCollection);
        }

        private IUrlPattern[] getUrlPatterns() {
            return this.webResourceCollection.getUrlPatterns();
        }

        private void createTreeNodes() {
            IUrlPattern[] urlPatterns = this.getUrlPatterns();
            if (this.urlPatternArL == null) {
                this.urlPatternArL = new ArrayList();
            }
            if (this.treeNodesArL == null) {
                this.treeNodesArL = new ArrayList();
            }
            int i = 0;
            while (i < urlPatterns.length) {
                if (!this.urlPatternArL.contains(urlPatterns[i])) {
                    this.urlPatternArL.add(urlPatterns[i]);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setFolder((Folder)this);
                    treeNode.setIdentifiable((IIdentifiable)urlPatterns[i]);
                    this.treeNodesArL.add(treeNode);
                }
                ++i;
            }
        }

        public IWebResourceCollection getWebResourceCollection() {
            return this.webResourceCollection;
        }

        public void setWebResourceCollection(IWebResourceCollection collection) {
            this.webResourceCollection = collection;
        }

        public ArrayList getTreeNodesArrayList() {
            this.createTreeNodes();
            return this.treeNodesArL;
        }

        protected TreeNode getTreeNode(IUrlPattern urlPattern) {
            TreeNode urlPatternTreeNode;
            block2: {
                urlPatternTreeNode = null;
                if (!this.urlPatternArL.contains(urlPattern)) {
                    this.createTreeNodes();
                }
                int i = this.treeNodesArL.size() - 1;
                if (i < 0) break block2;
                if (this.treeNodesArL.get(i) != null && ((TreeNode)this.treeNodesArL.get(i)).getIdentifiable().equals(urlPattern)) {
                    urlPatternTreeNode = (TreeNode)this.treeNodesArL.get(i);
                }
            }
            return urlPatternTreeNode;
        }

        public void removeTreeNode(TreeNode treeNode) {
            ((AbstractCollection)this.treeNodesArL).remove(treeNode);
        }
    }

    public class WebResourceCollectionFolder
    extends BaseFolder {
        protected WebResourceCollectionFolder(SecurityConstraintsHolder securityConstraintsHolder) {
            super(securityConstraintsHolder);
        }
    }
}

