/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IErrorPage;
import com.tssap.j2ee.model.web.dd.ITaglib;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.model.web.dd.IWelcomeFile;
import com.tssap.j2ee.ui.core.WebOthersPageResourceChooserCB;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.MyReusableManager;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.j2ee.ui.web.editor.internal.WebOtherPageTreeCP;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class WebOthersPage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebOthersPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebOthersPage = WebOthersPage.class$("com.tssap.j2ee.ui.web.editor.internal.WebOthersPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebOthersPage));
    private static final int NUM_OF_COLS = 1;
    private static final String PAGEMANE = "Others";
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private WebOtherPageTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebOthersPage;

    public WebOthersPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.myTreeSelector.setTreeInput((Object)webApp);
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return PAGEMANE;
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(3);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeEditor.setReusableManager((IReuseableManager)new MyReusableManager());
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeContentProvider = new WebOtherPageTreeCP();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + ". " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        IResourceChooserCallback resChooserCallback;

        MySelectionConverter() {
            this.resChooserCallback = new WebOthersPageResourceChooserCB(WebOthersPage.this.getUnderlyingFile().getProject());
        }

        public Object convertSelection(Object selectedObject) {
            return new WebOtherPageDataWrapper(this.resChooserCallback, selectedObject);
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        private static final int WELCOME_FILE = 0;
        private static final int ERROR_PAGE = 1;
        private static final int TAGLIB = 2;

        AddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            Object ret = null;
            Object parent = WebOthersPage.this.myTreeContentProvider.getParent(currentSelection);
            Object selection = parent != null ? parent : currentSelection;
            int type = 0;
            if (selection instanceof WebOtherPageTreeCP.BaseFolder) {
                if (selection instanceof WebOtherPageTreeCP.WelcomeFilesFolder) {
                    type = 0;
                } else if (selection instanceof WebOtherPageTreeCP.ErrorPageFolder) {
                    type = 1;
                } else if (selection instanceof WebOtherPageTreeCP.TagLibFolder) {
                    type = 2;
                }
                ret = this.addChild(((WebOtherPageTreeCP.BaseFolder)selection).getWebApp(), type);
            }
            return ret;
        }

        private Object addChild(IWebApp webApp, int type) {
            IErrorPage ret = null;
            try {
                switch (type) {
                    case 0: {
                        if (webApp.getWelcomeFileList() == null) {
                            webApp.createWelcomeFileList(null);
                        }
                        ret = webApp.getWelcomeFileList().createWelcomeFile(null);
                        break;
                    }
                    case 1: {
                        IErrorPage ep;
                        ret = ep = webApp.createErrorPage(null);
                        ep.createLocation(null);
                        break;
                    }
                    case 2: {
                        ITaglib tl = webApp.createTaglib(null);
                        ret = tl;
                        tl.createTaglibLocation(null);
                        tl.createTaglibUri(null);
                        break;
                    }
                    default: {
                        tracer.error(this.getClass(), "addChild(webApp, type)", " Error: Illegal Argument provided (type). ");
                        break;
                    }
                }
            }
            catch (J2eeCreateException e) {
                WebOthersPage.this.handleJ2eeCreateException("Tag error-page, taglib or welcome-file could not be created.", e);
            }
            return ret;
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof WebOtherPageTreeCP.BaseFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebOthersPage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof WebOtherPageTreeCP.BaseFolder) {
                IWebApp parentWebApp = ((WebOtherPageTreeCP.BaseFolder)parentObj).getWebApp();
                if (currentSelection instanceof IWelcomeFile) {
                    parentWebApp.getWelcomeFileList().removeWelcomeFile((IWelcomeFile)currentSelection);
                    IWelcomeFile[] welcomeFiles = parentWebApp.getWelcomeFileList().getWelcomeFiles();
                    if (welcomeFiles != null && welcomeFiles.length == 0) {
                        parentWebApp.removeWelcomeFileList();
                    }
                } else if (currentSelection instanceof IErrorPage) {
                    parentWebApp.removeErrorPage((IErrorPage)currentSelection);
                } else if (currentSelection instanceof ITaglib) {
                    parentWebApp.removeTaglib((ITaglib)currentSelection);
                }
            }
            return true;
        }
    }
}

