/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.web.dd.IErrorPage;
import com.tssap.j2ee.model.web.dd.ITaglib;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.model.web.dd.IWelcomeFile;
import com.tssap.j2ee.model.web.dd.IWelcomeFileList;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.IWebAppHolder;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class WebOtherPageTreeCP
extends J2eeModelLabelProvider
implements ITreeContentProvider,
ILabelProvider {
    private static final Image IMG_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
    private static final Object[] EMPTY_OBJ_AR = new Object[0];
    private final WebAppHolder webAppHolder = new WebAppHolder();
    private final ErrorPageFolder errorPageFolder = new ErrorPageFolder(this.webAppHolder);
    private final TagLibFolder taglibFolder = new TagLibFolder(this.webAppHolder);
    private final WelcomeFilesFolder welcomeFilesFolder = new WelcomeFilesFolder(this.webAppHolder);
    private final Object[] roots = new Object[]{this.taglibFolder, this.errorPageFolder, this.welcomeFilesFolder};
    private Object[] activeRoots;

    private void setWebApp(IWebApp webApp) {
        this.webAppHolder.setWebApp(webApp);
    }

    public Object[] getChildren(Object parentElement) {
        IWebApp webApp;
        Object[] ret = EMPTY_OBJ_AR;
        if (parentElement instanceof BaseFolder && (webApp = ((BaseFolder)parentElement).getWebApp()) != null) {
            IWelcomeFileList wl;
            if (parentElement instanceof ErrorPageFolder) {
                ret = webApp.getErrorPages();
            } else if (parentElement instanceof TagLibFolder) {
                ret = webApp.getTaglibs();
            } else if (parentElement instanceof WelcomeFilesFolder && (wl = webApp.getWelcomeFileList()) != null) {
                ret = wl.getWelcomeFiles();
            }
        }
        return ret;
    }

    public Object getParent(Object element) {
        BaseFolder ret = null;
        if (element instanceof IWelcomeFile) {
            ret = this.welcomeFilesFolder;
        } else if (element instanceof IErrorPage) {
            ret = this.errorPageFolder;
        } else if (element instanceof ITaglib) {
            ret = this.taglibFolder;
        }
        return ret;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.activeRoots;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IWebApp) {
            this.webAppHolder.setWebApp((IWebApp)newInput);
            this.activeRoots = this.roots;
        } else {
            this.activeRoots = EMPTY_OBJ_AR;
        }
    }

    public Image getImage(Object element) {
        Image ret = super.getImage(element);
        if (element instanceof BaseFolder) {
            ret = IMG_FOLDER;
        }
        return ret == null ? UIPlugin.getImage((String)"dummy") : ret;
    }

    public String getText(Object element) {
        String ret = super.getText(element);
        if (element instanceof IWelcomeFile) {
            ret = this.getShortValueText((IMutable)((IWelcomeFile)element));
        } else if (element instanceof ITaglib) {
            ret = this.getShortValueText((IMutable)((ITaglib)element).getTaglibLocation());
        } else if (element instanceof BaseFolder) {
            ret = super.getText(element);
        }
        return ret == null ? "<...>" : ret;
    }

    private String getShortValueText(IMutable mutable) {
        String ret;
        String string = ret = mutable != null ? mutable.getValue() : null;
        if (ret != null) {
            if ((ret = this.getFileName(ret)).length() > 15) {
                ret = "..." + ret.substring(ret.length() - 7);
            } else if (ret.length() == 0) {
                ret = null;
            }
        }
        return ret;
    }

    private String getFileName(String s) {
        String ret = s;
        Path testPath = new Path(s);
        ret = testPath.removeFileExtension().lastSegment();
        return ret != null ? ret : "";
    }

    static class WebAppHolder {
        private IWebApp myWebApp;

        WebAppHolder() {
        }

        public void setWebApp(IWebApp webApp) {
            this.myWebApp = webApp;
        }

        public IWebApp getWebApp() {
            return this.myWebApp;
        }
    }

    public static class WelcomeFilesFolder
    extends BaseFolder {
        protected WelcomeFilesFolder(WebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String toString() {
            return "Welcome Pages";
        }
    }

    public static class TagLibFolder
    extends BaseFolder {
        protected TagLibFolder(WebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String toString() {
            return "Tag-Libs";
        }
    }

    public static class ErrorPageFolder
    extends BaseFolder {
        protected ErrorPageFolder(WebAppHolder webAppHolder) {
            super(webAppHolder);
        }

        public String toString() {
            return "Error-Pages";
        }
    }

    public static abstract class BaseFolder
    implements IWebAppHolder {
        private WebAppHolder myWebAppHolder;

        protected BaseFolder(WebAppHolder webAppHolder) {
            this.myWebAppHolder = webAppHolder;
        }

        public IWebApp getWebApp() {
            return this.myWebAppHolder.getWebApp();
        }
    }
}

