/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IFilter;
import com.tssap.j2ee.model.web.dd.IFilterMapping;
import com.tssap.j2ee.model.web.dd.IMimeMapping;
import com.tssap.j2ee.model.web.dd.IServlet;
import com.tssap.j2ee.model.web.dd.IServletMapping;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.BaseFolder;
import com.tssap.j2ee.ui.web.editor.internal.MappingsReuseableManager;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.j2ee.ui.web.editor.internal.WebOtherPageTreeCP;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class WebMappingPage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebMappingPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebMappingPage = WebMappingPage.class$("com.tssap.j2ee.ui.web.editor.internal.WebMappingPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebMappingPage));
    private static final int NUM_OF_COLS = 2;
    private static final String PAGE_NAME = "Mapping";
    private IWebApp currentWebApp = null;
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private MappingPageTreeCP myTreeContentProvider;
    private ILabelProvider myTreeLabelProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebMappingPage;

    public WebMappingPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 2);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.setWebApplication(webApp);
        this.myTreeSelector.setTreeInput((Object)webApp);
        MappingsReuseableManager.webApp = webApp;
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(2);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeContentProvider = new MappingPageTreeCP();
        this.myTreeLabelProvider = new MappingLabelProvider();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider(this.myTreeLabelProvider);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
        this.myTreeEditor.setReusableManager((IReuseableManager)new MappingsReuseableManager());
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    public void setWebApplication(IWebApp webApplication) {
        this.currentWebApp = webApplication;
    }

    public IWebApp getWebApplication() {
        return this.currentWebApp;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        this.myTreeSelector.setEditable(editable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MappingLabelProvider
    extends J2eeModelLabelProvider {
        private final Image IMG_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");

        private MappingLabelProvider() {
        }

        public Image getImage(Object element) {
            Image retImage = super.getImage(element);
            if (element instanceof BaseFolder) {
                retImage = this.IMG_FOLDER;
            } else if (element instanceof IFilterMapping) {
                retImage = UIPlugin.getImage((String)"filter");
            } else if (element instanceof IServletMapping) {
                retImage = UIPlugin.getImage((String)"ServletNameMapping");
            } else if (element instanceof IMimeMapping) {
                retImage = UIPlugin.getImage((String)"MimeMapping");
            }
            return retImage;
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if (element instanceof IFilterMapping) {
                text = ((IFilterMapping)element).getFilterName().getValue();
            } else if (element instanceof IServletMapping) {
                text = ((IServletMapping)element).getServletName().getValue();
            } else if (element instanceof IMimeMapping) {
                text = ((IMimeMapping)element).getExtension().getValue();
            }
            return text;
        }
    }

    private class MappingPageTreeCP
    implements ITreeContentProvider {
        private final Object[] EMPTY_OBJ_AR = new Object[0];
        private final WebOtherPageTreeCP.WebAppHolder webAppHolder = new WebOtherPageTreeCP.WebAppHolder();
        private final FilterMappingFolder filterMappingFolder = new FilterMappingFolder(this.webAppHolder);
        private final ServletMappingFolder servletMappingFolder = new ServletMappingFolder(this.webAppHolder);
        private final MimeMappingFolder mimeMappingFolder = new MimeMappingFolder(this.webAppHolder);
        private final Object[] roots = new Object[]{this.filterMappingFolder, this.servletMappingFolder, this.mimeMappingFolder};
        private Object[] activeRoots;

        private MappingPageTreeCP() {
        }

        public Object[] getChildren(Object parentElement) {
            IWebApp webApp;
            Object[] ret = this.EMPTY_OBJ_AR;
            if (parentElement instanceof BaseFolder && (webApp = ((BaseFolder)parentElement).getWebApp()) != null) {
                if (parentElement instanceof FilterMappingFolder) {
                    ret = webApp.getFilterMappings();
                } else if (parentElement instanceof ServletMappingFolder) {
                    ret = webApp.getServletMappings();
                } else if (parentElement instanceof MimeMappingFolder) {
                    ret = webApp.getMimeMappings();
                }
            }
            return ret;
        }

        public Object[] getElements(Object inputElement) {
            return this.activeRoots;
        }

        public Object getParent(Object element) {
            BaseFolder ret = null;
            if (element instanceof IFilterMapping) {
                ret = this.filterMappingFolder;
            } else if (element instanceof IServletMapping) {
                ret = this.servletMappingFolder;
            } else if (element instanceof IMimeMapping) {
                ret = this.mimeMappingFolder;
            }
            return ret;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IWebApp) {
                this.webAppHolder.setWebApp((IWebApp)newInput);
                this.activeRoots = this.roots;
            } else {
                this.activeRoots = this.EMPTY_OBJ_AR;
            }
        }

        public WebOtherPageTreeCP.WebAppHolder getWebAppHolder() {
            return this.webAppHolder;
        }

        public void dispose() {
        }

        private class MimeMappingFolder
        extends BaseFolder {
            protected MimeMappingFolder(WebOtherPageTreeCP.WebAppHolder webAppHolder) {
                super(webAppHolder);
            }

            public String toString() {
                return "Mime Mappings";
            }
        }

        private class ServletMappingFolder
        extends BaseFolder {
            protected ServletMappingFolder(WebOtherPageTreeCP.WebAppHolder webAppHolder) {
                super(webAppHolder);
            }

            public String toString() {
                return "Servlet Mappings";
            }
        }

        private class FilterMappingFolder
        extends BaseFolder {
            protected FilterMappingFolder(WebOtherPageTreeCP.WebAppHolder webAppHolder) {
                super(webAppHolder);
            }

            public String toString() {
                return "Filter Mappings";
            }
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        AddRemoveCallback() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object addElement(Object currentSelection) {
            Object[] resultSelections;
            String[] selectableServletNames;
            Object selection;
            Object[] ret = null;
            Object parent = WebMappingPage.this.myTreeContentProvider.getParent(currentSelection);
            Object object = selection = parent != null ? parent : currentSelection;
            if (selection instanceof MappingPageTreeCP.FilterMappingFolder || selection instanceof IFilterMapping) {
                Object[] selectableFilterNames = this.getFilterDialogElements(WebMappingPage.this.getWebApplication());
                if (selectableFilterNames.length <= 0) return ret;
                Shell uiShell = UIPlugin.getShell();
                ObjectSelectionDialog selectionDialog = new ObjectSelectionDialog(uiShell, "Choose Filter", "Choose filters from the list below.");
                selectionDialog.setSingleSelection(false);
                selectionDialog.setLabelProvider((ILabelProvider)new FilterLabelProvider());
                Object[] resultSelections2 = selectionDialog.openDialog(selectableFilterNames);
                if (resultSelections2 == null || resultSelections2.length <= 0) return ret;
                ret = new Object[resultSelections2.length];
                int i = 0;
                while (i < resultSelections2.length) {
                    String newFilterMappingName = resultSelections2[i].toString();
                    if (newFilterMappingName != null) {
                        try {
                            IFilterMapping newFilterMapping = WebMappingPage.this.getWebApplication().createFilterMapping(null);
                            newFilterMapping.createFilterName(null).setValue(newFilterMappingName);
                            ret[i] = newFilterMapping;
                        }
                        catch (J2eeCreateException e) {
                            WebMappingPage.this.handleJ2eeCreateException("<filter-mapping> could not be created.", e);
                        }
                    }
                    ++i;
                }
                return ret[0];
            }
            if (selection instanceof MappingPageTreeCP.MimeMappingFolder || selection instanceof IMimeMapping) {
                if (WebMappingPage.this.getWebApplication() == null) return ret;
                try {
                    IMimeMapping mimeMapping = WebMappingPage.this.getWebApplication().createMimeMapping(null);
                    mimeMapping.createExtension(null);
                    mimeMapping.createMimeType(null);
                    return mimeMapping;
                }
                catch (J2eeCreateException e) {
                    WebMappingPage.this.handleJ2eeCreateException("<mime-mapping>,<extension> and/or <mime-type> could not be created.", e);
                    return ret;
                }
            }
            if (!(selection instanceof MappingPageTreeCP.ServletMappingFolder) && !(selection instanceof IServletMapping) || WebMappingPage.this.getWebApplication() == null || (selectableServletNames = this.getServletDialogElements(WebMappingPage.this.getWebApplication())) == null || selectableServletNames.length <= 0 || (resultSelections = this.getServletsFromDialog(selectableServletNames)) == null) return ret;
            ret = new Object[resultSelections.length];
            int i = 0;
            while (i < resultSelections.length) {
                try {
                    IServletMapping servletMapping = WebMappingPage.this.getWebApplication().createServletMapping(null);
                    servletMapping.createServletName(null).setValue(resultSelections[i].toString().substring(0, resultSelections[i].toString().indexOf("(") - 1));
                    servletMapping.createUrlPattern(null);
                    ret[i] = servletMapping;
                }
                catch (J2eeCreateException e) {
                    WebMappingPage.this.handleJ2eeCreateException("<servlet-mapping> could not be created.", e);
                }
                ++i;
            }
            return ret[0];
        }

        private Object[] getServletsFromDialog(String[] selectableServletNames) {
            Shell uiShell = UIPlugin.getShell();
            ObjectSelectionDialog selectionDialog = new ObjectSelectionDialog(uiShell, "Choose Servlet", "Choose servlets from the list below.");
            selectionDialog.setSingleSelection(false);
            selectionDialog.setLabelProvider((ILabelProvider)new ServletLabelProvider());
            Object[] resultSelections = selectionDialog.openDialog((Object[])selectableServletNames);
            return resultSelections;
        }

        private String[] getFilterDialogElements(IWebApp webApp) {
            if (webApp != null) {
                IFilter[] filters = webApp.getFilters();
                ArrayList<String> selectableFilterNamesL = new ArrayList<String>();
                int i = 0;
                while (i < filters.length) {
                    selectableFilterNamesL.add(filters[i].getFilterName().getValue());
                    ++i;
                }
                String[] selectableFilterNames = selectableFilterNamesL.toArray(new String[selectableFilterNamesL.size()]);
                return selectableFilterNames;
            }
            tracer.error(this.getClass(), "getFilterDialogElements()", "IWebApp parameter is null!");
            return null;
        }

        private String[] getServletDialogElements(IWebApp webApp) {
            if (webApp != null) {
                IServlet[] servlets = webApp.getServlets();
                ArrayList<String> selectableServletNamesL = new ArrayList<String>();
                String servletName = null;
                String servletNameOnly = null;
                String servletClass = null;
                int i = 0;
                while (i < servlets.length) {
                    StringBuffer sb = new StringBuffer();
                    if (servlets[i].getServletClass() != null && servlets[i].getServletName() != null) {
                        servletNameOnly = servlets[i].getServletName().getValue();
                        servletClass = servlets[i].getServletClass().getValue();
                        sb.append(servletNameOnly).append(" (").append(servletClass).append(')');
                        servletName = sb.toString();
                    } else if (servlets[i].getJspFile() != null && servlets[i].getServletName() != null) {
                        servletNameOnly = servlets[i].getServletName().getValue();
                        servletClass = servlets[i].getJspFile().getValue();
                        sb.append(servletNameOnly).append(" (").append(servletClass).append(')');
                        servletName = sb.toString();
                    }
                    selectableServletNamesL.add(servletName);
                    ++i;
                }
                String[] selectableServletNames = selectableServletNamesL.toArray(new String[selectableServletNamesL.size()]);
                return selectableServletNames;
            }
            tracer.error(this.getClass(), "getServletDialogElements()", "IWebApp parameter is null!");
            return null;
        }

        public boolean canAddElement(Object currentSelection) {
            if (WebMappingPage.this.getWebApplication() != null) {
                if ((currentSelection instanceof MappingPageTreeCP.FilterMappingFolder || currentSelection instanceof IFilterMapping) && (this.getFilterDialogElements(WebMappingPage.this.getWebApplication()) == null || this.getFilterDialogElements(WebMappingPage.this.getWebApplication()).length == 0)) {
                    return false;
                }
                if ((currentSelection instanceof MappingPageTreeCP.ServletMappingFolder || currentSelection instanceof IServletMapping) && (this.getServletDialogElements(WebMappingPage.this.getWebApplication()) == null || this.getServletDialogElements(WebMappingPage.this.getWebApplication()).length == 0)) {
                    return false;
                }
                return currentSelection != null;
            }
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof BaseFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebMappingPage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof BaseFolder) {
                IWebApp parentWebApp = ((BaseFolder)parentObj).getWebApp();
                if (currentSelection instanceof IFilterMapping) {
                    parentWebApp.removeFilterMapping((IFilterMapping)currentSelection);
                } else if (currentSelection instanceof IServletMapping) {
                    parentWebApp.removeServletMapping((IServletMapping)currentSelection);
                } else if (currentSelection instanceof IMimeMapping) {
                    parentWebApp.removeMimeMapping((IMimeMapping)currentSelection);
                }
            }
            return true;
        }

        private class ServletLabelProvider
        extends J2eeModelLabelProvider
        implements ILabelProvider {
            private ServletLabelProvider() {
            }

            public Image getImage(Object element) {
                return UIPlugin.getImage((String)"servlet");
            }

            public String getText(Object element) {
                return super.getText(element);
            }
        }

        private class FilterLabelProvider
        extends J2eeModelLabelProvider
        implements ILabelProvider {
            private FilterLabelProvider() {
            }

            public Image getImage(Object element) {
                return UIPlugin.getImage((String)"filter");
            }

            public String getText(Object element) {
                return super.getText(element);
            }
        }
    }
}

