/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IMutable;
import com.tssap.j2ee.model.dd.MutableUtil;
import com.tssap.j2ee.model.web.dd.IAuthMethod;
import com.tssap.j2ee.model.web.dd.IDescription;
import com.tssap.j2ee.model.web.dd.IDisplayName;
import com.tssap.j2ee.model.web.dd.IDistributable;
import com.tssap.j2ee.model.web.dd.IFormErrorPage;
import com.tssap.j2ee.model.web.dd.IFormLoginConfig;
import com.tssap.j2ee.model.web.dd.IFormLoginPage;
import com.tssap.j2ee.model.web.dd.IIcon;
import com.tssap.j2ee.model.web.dd.ILargeIcon;
import com.tssap.j2ee.model.web.dd.ILoginConfig;
import com.tssap.j2ee.model.web.dd.IRealmName;
import com.tssap.j2ee.model.web.dd.ISessionConfig;
import com.tssap.j2ee.model.web.dd.ISessionTimeout;
import com.tssap.j2ee.model.web.dd.ISmallIcon;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.core.WebOthersPageResourceChooserCB;
import com.tssap.j2ee.ui.editor.reuse.gi.DDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.j2ee.ui.util.J2eePrjImageChooser;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import com.tssap.util.ui.reuse.chooser.IDropDownSelector;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.FileExtensionFilter;
import com.tssap.util.ui.reuse.chooser.impl.ResourceChooser;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class WebGeneralPage
extends WebEditorPage {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebGeneralPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebGeneralPage = WebGeneralPage.class$("com.tssap.j2ee.ui.web.editor.internal.WebGeneralPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebGeneralPage));
    private static final int NUM_OF_COLS = 1;
    private static final int LOGIN_PAGE_CHOOSER_ID = 0;
    private static final int ERROR_PAGE_CHOOSER_ID = 1;
    private static final String DEFAULT_TEXT_AUTH_METHOD = "Select an authorization method.";
    private static final String DEFAULT_TEXT_LOGIN_PAGE = "Select a form login page.";
    private static final String DEFAULT_TEXT_ERROR_PAGE = "Select a form error page.";
    private IDDGeneralInfoComponent generalInfoComponent;
    private Button distributableCheckbox;
    private Button loginConfigCheckbox;
    private Button formLoginConfigCheckbox;
    private boolean isDistributableChecked = false;
    private Text sessionTimeoutTextField;
    private Combo authMethodCombo;
    private Text realmNameTextField;
    private boolean loginConfigSelected = false;
    private boolean formLoginConfigChecked = false;
    private InnerFormLoginAdapter formLoginAdapter;
    private IWebApp webApp = null;
    private boolean notifyChanges = true;
    private ResourceChooser loginPageResourceChooser;
    private ResourceChooser errorPageResourceChooser;
    private IDropDownSelector[] locationDDS;
    private boolean isRefreshing = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebGeneralPage;

    public WebGeneralPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    public String getPageName() {
        return "General";
    }

    public Control createControls(IGridLayoutPane grid) {
        Composite ret = grid.getComposite();
        IGridLayoutPane generalGlp = grid.addGridLayoutPane(this.getPageName(), 1, false, grid.createGridLayoutData(4, 4, true, false));
        DDGeneralInfoComponent generalInfoComp = new DDGeneralInfoComponent();
        this.setGeneralInfoComponent((IDDGeneralInfoComponent)generalInfoComp);
        J2eePrjImageChooser iconChooser = new J2eePrjImageChooser(this.getUnderlyingFile().getProject());
        generalInfoComp.setDisplayableChooser(0, (IDisplayableChooser)iconChooser);
        generalInfoComp.setDisplayableChooser(1, (IDisplayableChooser)iconChooser);
        generalInfoComp.setAdapter((IDDGeneralInfoComponentAdapter)new DDGeneralInfoComponentAdapter());
        generalInfoComp.createPartControl(generalGlp);
        IGridLayoutPane sessionConfigGlp = generalGlp.addGridLayoutPane(2, false, grid.createGridLayoutData(4, 4, true, false));
        Button distributableCheckbox = sessionConfigGlp.addCheckBox("Distributable", this.isDistributableChecked());
        this.setDistributableCheckbox(distributableCheckbox);
        sessionConfigGlp.addPlaceholder();
        sessionConfigGlp.addTextLabel("Session configuration - Session timeout", sessionConfigGlp.createGridLayoutData(4, 4, false, false, 1, 1));
        this.sessionTimeoutTextField = sessionConfigGlp.addTextField(false, sessionConfigGlp.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setSessionTimeoutTextField(this.sessionTimeoutTextField);
        IGridLayoutPane loginConfigGlp = grid.addGridLayoutPane("", 3, false, grid.createGridLayoutData(4, 4, true, false));
        this.loginConfigCheckbox = loginConfigGlp.addCheckBox("Login configuration", false, loginConfigGlp.createGridLayoutData(4, 4, true, false, 4, 1));
        this.setLoginConfigCheckbox(this.loginConfigCheckbox);
        String[] authMethodTypes = new String[]{DEFAULT_TEXT_AUTH_METHOD, "BASIC", "DIGEST", "FORM", "CLIENT-CERT"};
        loginConfigGlp.addTextLabel("Authorization method", loginConfigGlp.createGridLayoutData(4, 4, false, false, 1, 1));
        this.authMethodCombo = loginConfigGlp.addComboBox(authMethodTypes, "", true, loginConfigGlp.createGridLayoutData(4, 4, true, false, 2, 1));
        this.authMethodCombo.addModifyListener((ModifyListener)new ModifyAdapter());
        this.setAuthMethodCombo(this.authMethodCombo);
        loginConfigGlp.addTextLabel("Realm name", loginConfigGlp.createGridLayoutData(4, 4, false, false));
        this.realmNameTextField = loginConfigGlp.addTextField(false, loginConfigGlp.createGridLayoutData(4, 4, false, false, 2, 1));
        this.setRealmNameTextField(this.realmNameTextField);
        this.formLoginConfigCheckbox = loginConfigGlp.addCheckBox("Form login configuration", false, loginConfigGlp.createGridLayoutData());
        this.setFormLoginConfigCheckbox(this.formLoginConfigCheckbox);
        this.setFormLoginAdapter(new InnerFormLoginAdapter());
        this.loginPageResourceChooser = new ResourceChooser((IResourceChooserCallback)new WebOthersPageResourceChooserCB(this.getUnderlyingFile() != null ? this.getUnderlyingFile().getProject() : null), DEFAULT_TEXT_LOGIN_PAGE, "");
        this.errorPageResourceChooser = new ResourceChooser((IResourceChooserCallback)new WebOthersPageResourceChooserCB(this.getUnderlyingFile() != null ? this.getUnderlyingFile().getProject() : null), DEFAULT_TEXT_ERROR_PAGE, "");
        this.loginPageResourceChooser.setViewerFilter((ViewerFilter)new FileExtensionFilter(new String[]{"htm", "html", "jsp", "xhtml"}));
        this.errorPageResourceChooser.setViewerFilter((ViewerFilter)new FileExtensionFilter(new String[]{"htm", "html", "jsp", "xhtml"}));
        IDisplayableChooser[] formLoginConfigChoosers = new IDisplayableChooser[]{this.loginPageResourceChooser, this.errorPageResourceChooser};
        this.locationDDS = new DropDownSelector[]{new DropDownSelector(0), new DropDownSelector(0)};
        this.setLocationDDS(this.locationDDS);
        int i = 0;
        while (i <= 1) {
            this.locationDDS[i].setIsGrabHorizontal(true);
            if (i == 0) {
                this.locationDDS[i].setSelectorDescription("Form Login Page ");
            } else {
                this.locationDDS[i].setSelectorDescription("Form Error Page  ");
            }
            this.locationDDS[i].setDescriptionPositionLeft(true);
            this.locationDDS[i].setReadOnly(false);
            this.locationDDS[i].setHistory(new String[0]);
            this.locationDDS[i].setButtonText("...");
            this.locationDDS[i].setHasPushButton(true);
            this.locationDDS[i].setPushButtonChooser((IChooser)this.loginPageResourceChooser);
            this.locationDDS[i].createPartControl(loginConfigGlp);
            ++i;
        }
        return ret;
    }

    protected void decorateControls() {
        this.getGeneralInfoComponent().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getSessionTimeoutTextField().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getLoginConfigCheckbox().addSelectionListener((SelectionListener)new LoginConfigSelectionListener());
        this.getAuthMethodCombo().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getRealmNameTextField().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getFormLoginConfigCheckbox().addSelectionListener((SelectionListener)new InnerCheckboxAdapter());
        this.getLocationDDS()[0].addModifyListener((ModifyListener)new InnerFormLoginModifyListener(0));
        this.getLocationDDS()[1].addModifyListener((ModifyListener)new InnerFormLoginModifyListener(1));
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.isRefreshing = true;
        this.setWebApp(webApp);
        InnerFormLoginAdapter formLoginAdapter = this.getFormLoginAdapter();
        this.setNotifyChanges(false);
        this.getGeneralInfoComponent().initialize();
        IDisplayName displayNameMutable = webApp.getDisplayName();
        String displayName = MutableUtil.mutableToValue((IMutable)displayNameMutable);
        this.getGeneralInfoComponent().setDisplayName(displayName);
        IDescription descriptionMutable = webApp.getDescription();
        String description = MutableUtil.mutableToValue((IMutable)descriptionMutable);
        this.getGeneralInfoComponent().setDescription(description);
        IIcon icon = webApp.getIcon();
        boolean iconsIsEnabled = true;
        if (icon != null) {
            ILargeIcon largeIconMutable;
            ISmallIcon smallIconMutable = icon.getSmallIcon();
            if (smallIconMutable != null && !smallIconMutable.getValue().equals("")) {
                this.getGeneralInfoComponent().setSmallIcon(smallIconMutable.getValue());
            }
            if ((largeIconMutable = icon.getLargeIcon()) != null && !largeIconMutable.getValue().equals("")) {
                this.getGeneralInfoComponent().setLargeIcon(largeIconMutable.getValue());
            }
            if ((smallIconMutable == null || smallIconMutable.getValue().equals("")) && (largeIconMutable == null || largeIconMutable.getValue().equals(""))) {
                iconsIsEnabled = false;
            }
        } else {
            iconsIsEnabled = false;
        }
        this.getGeneralInfoComponent().setIconsEnabled(iconsIsEnabled);
        IDistributable distributable = webApp.getDistributable();
        if (distributable != null) {
            this.setIsDistributableChecked(true);
            this.getDistributableCheckbox().setSelection(this.isDistributableChecked());
        } else {
            this.setIsDistributableChecked(false);
            this.getDistributableCheckbox().setSelection(this.isDistributableChecked());
        }
        ISessionConfig sessionConfig = webApp.getSessionConfig();
        ILoginConfig loginConfig = webApp.getLoginConfig();
        String sessionTimeout = "";
        if (sessionConfig != null) {
            ISessionTimeout sessionTimeoutMutable = sessionConfig.getSessionTimeout();
            sessionTimeout = MutableUtil.mutableToValue((IMutable)sessionTimeoutMutable);
        }
        this.getSessionTimeoutTextField().setText(sessionTimeout);
        this.initLoginConfig(formLoginAdapter, loginConfig);
        this.isRefreshing = false;
        this.setNotifyChanges(true);
    }

    private void initLoginConfig(InnerFormLoginAdapter formLoginAdapter, ILoginConfig loginConfig) {
        String authMethod = "";
        String realmName = "";
        if (loginConfig != null) {
            IMutable authMethodMutable = this.checkAuthMethodTag(loginConfig);
            IMutable realmNameMutable = this.checkRealmNameTag(loginConfig);
            this.checkFormLoginConfigTag(loginConfig, formLoginAdapter);
            if (authMethodMutable == null && realmNameMutable == null && loginConfig.getFormLoginConfig() == null) {
                this.setLoginConfigSelected(false);
                this.getLoginConfigCheckbox().setSelection(false);
                this.handleLoginConfigSelection(false);
            } else {
                this.setLoginConfigSelected(true);
                this.getLoginConfigCheckbox().setSelection(true);
                this.handleLoginConfigSelection(true);
                authMethod = MutableUtil.mutableToValue((IMutable)authMethodMutable);
                realmName = MutableUtil.mutableToValue((IMutable)realmNameMutable);
                this.getAuthMethodCombo().setText(authMethod);
                this.getRealmNameTextField().setText(realmName);
                if (loginConfig.getFormLoginConfig() != null) {
                    this.setFormLoginConfigChecked(true);
                    this.getLocationDDS()[0].setText(formLoginAdapter.getFormLoginPage());
                    this.getLocationDDS()[1].setText(formLoginAdapter.getFormErrorPage());
                } else {
                    this.setFormLoginConfigChecked(false);
                    this.getLocationDDS()[0].setText("");
                    this.getLocationDDS()[1].setText("");
                }
            }
            this.getFormLoginConfigCheckbox().setSelection(this.isFormLoginConfigChecked());
        } else {
            this.handleLoginConfigSelection(false);
            this.setLoginConfigSelected(false);
            this.getLoginConfigCheckbox().setSelection(false);
        }
        this.updateEditableBehavior();
    }

    private IMutable checkAuthMethodTag(ILoginConfig loginConfig) {
        if (loginConfig.getAuthMethod() != null && (loginConfig.getAuthMethod().getValue().equals("") || loginConfig.getAuthMethod().getValue().equals(DEFAULT_TEXT_AUTH_METHOD))) {
            loginConfig.removeAuthMethod();
            return null;
        }
        return loginConfig.getAuthMethod();
    }

    private IMutable checkRealmNameTag(ILoginConfig loginConfig) {
        if (loginConfig.getRealmName() != null && loginConfig.getRealmName().getValue().equals("")) {
            loginConfig.removeRealmName();
            return null;
        }
        return loginConfig.getRealmName();
    }

    private void checkFormLoginConfigTag(ILoginConfig loginConfig, InnerFormLoginAdapter formLoginAdapter) {
        IFormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
        if (formLoginConfig != null && formLoginAdapter != null) {
            formLoginAdapter.setFormLoginConfig(formLoginConfig);
            if (formLoginAdapter.getFormErrorPage().equals("")) {
                formLoginConfig.removeFormErrorPage();
            }
            if (formLoginAdapter.getFormLoginPage().equals("")) {
                formLoginConfig.removeFormLoginPage();
            }
            if (formLoginConfig.getFormErrorPage() == null && formLoginConfig.getFormLoginPage() == null) {
                loginConfig.removeFormLoginConfig();
            }
        }
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        ISessionTimeout sessionTimeoutMutable;
        IIcon icon = webApp.getIcon();
        if (icon != null && icon.getLargeIcon() == null && icon.getSmallIcon() == null) {
            webApp.removeIcon();
        }
        IDistributable distributable = webApp.getDistributable();
        if (this.getDistributableCheckbox().getSelection()) {
            this.setIsDistributableChecked(true);
        } else {
            this.setIsDistributableChecked(false);
        }
        if (distributable == null && this.isDistributableChecked) {
            try {
                webApp.createDistributable(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("distributable", e);
            }
        } else if (distributable != null && !this.isDistributableChecked) {
            webApp.removeDistributable();
        }
        String sessionTimeout = this.getSessionTimeoutTextField().getText().trim();
        boolean sessionConfigTagNeeded = false;
        if (sessionTimeout != null && sessionTimeout != "") {
            sessionConfigTagNeeded = true;
        }
        ISessionConfig sessionConfigMutable = webApp.getSessionConfig();
        if (sessionConfigTagNeeded) {
            if (sessionConfigMutable == null && sessionConfigTagNeeded) {
                try {
                    sessionConfigMutable = webApp.createSessionConfig(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("session-config", e);
                }
            }
            if (sessionConfigMutable != null) {
                sessionTimeoutMutable = sessionConfigMutable.getSessionTimeout();
                if (sessionTimeoutMutable == null && sessionTimeout.length() > 0) {
                    try {
                        sessionTimeoutMutable = sessionConfigMutable.createSessionTimeout(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("session-timeout", e);
                    }
                }
                if (sessionTimeoutMutable != null) {
                    sessionTimeoutMutable.setValue(sessionTimeout);
                }
            }
        } else if (sessionConfigMutable != null) {
            sessionTimeoutMutable = sessionConfigMutable.getSessionTimeout();
            if (sessionTimeoutMutable != null) {
                sessionConfigMutable.removeSessionTimeout();
            }
            webApp.removeSessionConfig();
        }
        String authMethod = this.getAuthMethodCombo().getText().trim();
        String realmName = this.getRealmNameTextField().getText().trim();
        String formLoginPage = this.getLocationDDS()[0].getText().trim();
        String formErrorPage = this.getLocationDDS()[1].getText().trim();
        boolean formLoginConfigTagNeeded = this.getFormLoginConfigCheckbox().getSelection() && (!formLoginPage.equals("") || !formErrorPage.equals(""));
        this.setFormLoginConfigChecked(formLoginConfigTagNeeded);
        boolean loginConfigTagNeeded = false;
        loginConfigTagNeeded = !authMethod.equals("") && !authMethod.equals(DEFAULT_TEXT_AUTH_METHOD) || realmName != "" || this.isFormLoginConfigChecked();
        ILoginConfig loginConfigMutable = webApp.getLoginConfig();
        if (loginConfigTagNeeded) {
            if (loginConfigMutable == null && loginConfigTagNeeded) {
                try {
                    loginConfigMutable = webApp.createLoginConfig(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("login-config", e);
                }
            }
            if (loginConfigMutable != null) {
                IAuthMethod authMethodMutable = loginConfigMutable.getAuthMethod();
                if (authMethodMutable == null && authMethod.length() > 0) {
                    try {
                        authMethodMutable = loginConfigMutable.createAuthMethod(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("auth-method", e);
                    }
                }
                if (authMethodMutable != null && !authMethod.equals("") && !authMethod.equals(DEFAULT_TEXT_AUTH_METHOD)) {
                    authMethodMutable.setValue(authMethod);
                } else {
                    loginConfigMutable.removeAuthMethod();
                }
                IRealmName realmNameMutable = loginConfigMutable.getRealmName();
                if (realmNameMutable == null && realmName.length() > 0) {
                    try {
                        realmNameMutable = loginConfigMutable.createRealmName(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("realm-name", e);
                    }
                }
                if (realmNameMutable != null && realmName != "") {
                    realmNameMutable.setValue(realmName);
                } else {
                    loginConfigMutable.removeRealmName();
                }
                if (this.isFormLoginConfigChecked()) {
                    IFormLoginConfig formLoginConfigMutable = loginConfigMutable.getFormLoginConfig();
                    if (formLoginConfigMutable == null) {
                        try {
                            formLoginConfigMutable = loginConfigMutable.createFormLoginConfig(null);
                            formLoginConfigMutable.createFormErrorPage(null).setValue(formErrorPage);
                            formLoginConfigMutable.createFormLoginPage(null).setValue(formLoginPage);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("form-login-config", e);
                        }
                    } else {
                        if (formLoginConfigMutable.getFormErrorPage() == null) {
                            try {
                                formLoginConfigMutable.createFormErrorPage(null);
                            }
                            catch (J2eeCreateException e) {
                                this.handleJ2eeCreateException("form-error-page", e);
                            }
                        }
                        if (formLoginConfigMutable.getFormLoginPage() == null) {
                            try {
                                formLoginConfigMutable.createFormLoginPage(null);
                            }
                            catch (J2eeCreateException e) {
                                this.handleJ2eeCreateException("form-login-page", e);
                            }
                        }
                        formLoginConfigMutable.getFormErrorPage().setValue(formErrorPage);
                        formLoginConfigMutable.getFormLoginPage().setValue(formLoginPage);
                    }
                } else {
                    IFormLoginConfig formLoginConfigMutable = loginConfigMutable.getFormLoginConfig();
                    if (formLoginConfigMutable != null) {
                        IFormErrorPage formErrorPageMutable;
                        IFormLoginPage formLoginPageMutable = formLoginConfigMutable.getFormLoginPage();
                        if (formLoginPageMutable != null) {
                            formLoginConfigMutable.removeFormLoginPage();
                        }
                        if ((formErrorPageMutable = formLoginConfigMutable.getFormErrorPage()) != null) {
                            formLoginConfigMutable.removeFormErrorPage();
                        }
                        loginConfigMutable.removeFormLoginConfig();
                    }
                }
            }
        } else {
            webApp.removeLoginConfig();
        }
    }

    private IDDGeneralInfoComponent getGeneralInfoComponent() {
        return this.generalInfoComponent;
    }

    private void setGeneralInfoComponent(IDDGeneralInfoComponent generalComponent) {
        this.generalInfoComponent = generalComponent;
    }

    private boolean isNotifyChanges() {
        return this.notifyChanges;
    }

    private void setNotifyChanges(boolean notifyChanges) {
        this.notifyChanges = notifyChanges;
    }

    private Text getRealmNameTextField() {
        return this.realmNameTextField;
    }

    private Text getSessionTimeoutTextField() {
        return this.sessionTimeoutTextField;
    }

    private void setRealmNameTextField(Text realmNameTextField) {
        this.realmNameTextField = realmNameTextField;
    }

    private void setSessionTimeoutTextField(Text sessionTimeoutTextField) {
        this.sessionTimeoutTextField = sessionTimeoutTextField;
    }

    private boolean isDistributableChecked() {
        return this.isDistributableChecked;
    }

    private void setIsDistributableChecked(boolean isDistributableChecked) {
        this.isDistributableChecked = isDistributableChecked;
    }

    private Button getDistributableCheckbox() {
        return this.distributableCheckbox;
    }

    private void setDistributableCheckbox(Button distributableCheckbox) {
        this.distributableCheckbox = distributableCheckbox;
    }

    public boolean isFormLoginConfigChecked() {
        return this.formLoginConfigChecked;
    }

    public void setFormLoginConfigChecked(boolean formLoginConfigChecked) {
        this.formLoginConfigChecked = formLoginConfigChecked;
    }

    public InnerFormLoginAdapter getFormLoginAdapter() {
        return this.formLoginAdapter;
    }

    public void setFormLoginAdapter(InnerFormLoginAdapter formLoginAdapter) {
        this.formLoginAdapter = formLoginAdapter;
    }

    private Combo getAuthMethodCombo() {
        return this.authMethodCombo;
    }

    private void setAuthMethodCombo(Combo authMethodCombo) {
        this.authMethodCombo = authMethodCombo;
    }

    private void handleLoginConfigSelection(boolean loginConfigIsSelected) {
        if (!loginConfigIsSelected) {
            this.getAuthMethodCombo().setText(DEFAULT_TEXT_AUTH_METHOD);
            this.getRealmNameTextField().setText("");
            this.setFormLoginConfigChecked(false);
            this.getFormLoginConfigCheckbox().setSelection(this.isFormLoginConfigChecked());
            this.getLocationDDS()[0].setText("");
            this.getLocationDDS()[1].setText("");
        }
    }

    IWebApp getWebApp() {
        return this.webApp;
    }

    void setWebApp(IWebApp app) {
        this.webApp = app;
    }

    private Button getLoginConfigCheckbox() {
        return this.loginConfigCheckbox;
    }

    private void setLoginConfigCheckbox(Button button) {
        this.loginConfigCheckbox = button;
    }

    private Button getFormLoginConfigCheckbox() {
        return this.formLoginConfigCheckbox;
    }

    private void setFormLoginConfigCheckbox(Button button) {
        this.formLoginConfigCheckbox = button;
    }

    private IDropDownSelector[] getLocationDDS() {
        return this.locationDDS;
    }

    private void setLocationDDS(IDropDownSelector[] selectors) {
        this.locationDDS = selectors;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + "Tag <" + msg + "> could not be created. " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        if (this.getDistributableCheckbox() != null) {
            this.getDistributableCheckbox().setEnabled(editable);
        }
        if (this.getGeneralInfoComponent() != null) {
            this.getGeneralInfoComponent().setEditable(editable);
        }
        if (this.getAuthMethodCombo() != null) {
            this.getAuthMethodCombo().setEnabled(this.isLoginConfigSelected() && this.isEditable());
        }
        if (this.getRealmNameTextField() != null) {
            this.getRealmNameTextField().setEnabled(this.isLoginConfigSelected() && this.isEditable());
        }
        if (this.getFormLoginConfigCheckbox() != null) {
            this.getFormLoginConfigCheckbox().setEnabled(this.isLoginConfigSelected() && this.isEditable());
        }
        if (this.getLoginConfigCheckbox() != null) {
            this.getLoginConfigCheckbox().setEnabled(this.isEditable());
        }
        if (this.getLocationDDS() != null) {
            if (this.getLocationDDS()[0] != null) {
                this.getLocationDDS()[0].setEditable(this.isFormLoginConfigChecked() && this.isEditable());
            }
            if (this.getLocationDDS()[1] != null) {
                this.getLocationDDS()[1].setEditable(this.isFormLoginConfigChecked() && this.isEditable());
            }
        }
        if (this.getSessionTimeoutTextField() != null) {
            this.getSessionTimeoutTextField().setEditable(editable);
        }
    }

    private boolean isLoginConfigSelected() {
        return this.loginConfigSelected;
    }

    private void setLoginConfigSelected(boolean b) {
        this.loginConfigSelected = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LoginConfigSelectionListener
    implements SelectionListener {
        private LoginConfigSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            WebGeneralPage.this.setLoginConfigSelected(WebGeneralPage.this.getLoginConfigCheckbox().getSelection());
            WebGeneralPage.this.handleLoginConfigSelection(WebGeneralPage.this.getLoginConfigCheckbox().getSelection());
            WebGeneralPage.this.updateEditableBehavior();
        }
    }

    private class InnerFormLoginAdapter {
        private IFormLoginConfig formLoginConfig;

        private InnerFormLoginAdapter() {
        }

        public String getFormLoginPage() {
            String formLoginPage = "";
            if (this.formLoginConfig != null) {
                formLoginPage = MutableUtil.mutableToValue((IMutable)this.formLoginConfig.getFormLoginPage());
            }
            return formLoginPage;
        }

        public String getFormErrorPage() {
            String formErrorPage = "";
            if (this.formLoginConfig != null) {
                formErrorPage = MutableUtil.mutableToValue((IMutable)this.formLoginConfig.getFormErrorPage());
            }
            return formErrorPage;
        }

        public void setFormLoginPage(String formLoginPage) {
            if (this.formLoginConfig != null) {
                if (this.formLoginConfig.getFormLoginPage() != null) {
                    this.formLoginConfig.getFormLoginPage().setValue(formLoginPage);
                } else {
                    try {
                        this.formLoginConfig.createFormLoginPage(null).setValue(formLoginPage);
                    }
                    catch (J2eeCreateException e) {
                        WebGeneralPage.this.handleJ2eeCreateException("form-login-page", e);
                    }
                }
                WebGeneralPage.super.makeEditorDirty();
            }
        }

        public void setFormErrorPage(String formErrorPage) {
            if (this.formLoginConfig != null) {
                if (this.formLoginConfig.getFormErrorPage() != null) {
                    this.formLoginConfig.getFormErrorPage().setValue(formErrorPage);
                } else {
                    try {
                        this.formLoginConfig.createFormErrorPage(null).setValue(formErrorPage);
                    }
                    catch (J2eeCreateException e) {
                        WebGeneralPage.this.handleJ2eeCreateException("form-error-page", e);
                    }
                }
                WebGeneralPage.super.makeEditorDirty();
            }
        }

        public IFormLoginConfig getFormLoginConfig() {
            return this.formLoginConfig;
        }

        public void setFormLoginConfig(IFormLoginConfig formLoginConfig) {
            this.formLoginConfig = formLoginConfig;
        }
    }

    private class InnerFormLoginModifyListener
    implements ModifyListener {
        private int index = -1;

        public InnerFormLoginModifyListener(int index) {
            this.setIndex(index);
        }

        public void modifyText(ModifyEvent e) {
            if (!WebGeneralPage.this.isRefreshing) {
                WebGeneralPage.this.updateWebAppFromControls(WebGeneralPage.this.getWebApp());
                WebGeneralPage.super.makeEditorDirty();
            }
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int i) {
            this.index = i;
        }
    }

    private class InnerCheckboxAdapter
    implements SelectionListener {
        private InnerCheckboxAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            WebGeneralPage.this.setFormLoginConfigChecked(WebGeneralPage.this.getFormLoginConfigCheckbox().getSelection());
            WebGeneralPage.this.updateEditableBehavior();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }

    private class DDGeneralInfoComponentAdapter
    implements IDDGeneralInfoComponentAdapter {
        private DDGeneralInfoComponentAdapter() {
        }

        public String getDescription() {
            String description = "";
            if (WebGeneralPage.this.getWebApp() != null) {
                description = MutableUtil.mutableToValue((IMutable)WebGeneralPage.this.getWebApp().getDescription());
            }
            return description;
        }

        public String getDisplayName() {
            String displayName = "";
            if (WebGeneralPage.this.getWebApp() != null) {
                displayName = MutableUtil.mutableToValue((IMutable)WebGeneralPage.this.getWebApp().getDisplayName());
            }
            return displayName;
        }

        public String getLargeIcon() {
            String ret = "";
            if (this.isIconsChecked() && WebGeneralPage.this.getWebApp() != null) {
                if (WebGeneralPage.this.getWebApp().getIcon().getLargeIcon() != null && WebGeneralPage.this.getWebApp().getIcon().getLargeIcon().getValue().equals("")) {
                    WebGeneralPage.this.getWebApp().getIcon().removeLargeIcon();
                } else {
                    ILargeIcon largeIconMutable = WebGeneralPage.this.getWebApp().getIcon().getLargeIcon();
                    ret = MutableUtil.mutableToValue((IMutable)largeIconMutable);
                }
            }
            return ret;
        }

        public String getSmallIcon() {
            String ret = "";
            if (this.isIconsChecked() && WebGeneralPage.this.getWebApp() != null) {
                if (WebGeneralPage.this.getWebApp().getIcon().getSmallIcon() != null && WebGeneralPage.this.getWebApp().getIcon().getSmallIcon().getValue().equals("")) {
                    WebGeneralPage.this.getWebApp().getIcon().removeSmallIcon();
                } else {
                    ISmallIcon smallIconMutable = WebGeneralPage.this.getWebApp().getIcon().getSmallIcon();
                    ret = MutableUtil.mutableToValue((IMutable)smallIconMutable);
                }
            }
            return ret;
        }

        public boolean isIconsChecked() {
            IIcon icon = WebGeneralPage.this.getWebApp() != null ? WebGeneralPage.this.getWebApp().getIcon() : null;
            return icon != null;
        }

        public void setDescription(String description) {
            if (description == null || description.equals("") && WebGeneralPage.this.getWebApp().getDescription() == null) {
                return;
            }
            if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.isNotifyChanges()) {
                if (WebGeneralPage.this.getWebApp().getDescription() != null) {
                    if (!description.equals("")) {
                        WebGeneralPage.this.getWebApp().getDescription().setValue(description);
                    } else {
                        WebGeneralPage.this.getWebApp().removeDescription();
                    }
                } else {
                    try {
                        WebGeneralPage.this.getWebApp().createDescription(null).setValue(description);
                    }
                    catch (J2eeCreateException e) {
                        WebGeneralPage.this.handleJ2eeCreateException("description", e);
                    }
                }
                WebGeneralPage.super.makeEditorDirty();
            } else if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.getWebApp().getDescription() != null && WebGeneralPage.this.getWebApp().getDescription().getValue().equals("")) {
                WebGeneralPage.this.getWebApp().removeDescription();
            }
        }

        public void setDisplayName(String displayName) {
            if (displayName == null || displayName.equals("") && WebGeneralPage.this.getWebApp().getDisplayName() == null) {
                return;
            }
            if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.isNotifyChanges()) {
                if (WebGeneralPage.this.getWebApp().getDisplayName() != null) {
                    if (!displayName.equals("")) {
                        WebGeneralPage.this.getWebApp().getDisplayName().setValue(displayName);
                    } else {
                        WebGeneralPage.this.getWebApp().removeDisplayName();
                    }
                } else {
                    try {
                        WebGeneralPage.this.getWebApp().createDisplayName(null).setValue(displayName);
                    }
                    catch (J2eeCreateException e) {
                        WebGeneralPage.this.handleJ2eeCreateException("display-name", e);
                    }
                }
                WebGeneralPage.super.makeEditorDirty();
            } else if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.getWebApp().getDisplayName() != null && WebGeneralPage.this.getWebApp().getDisplayName().getValue().equals("")) {
                WebGeneralPage.this.getWebApp().removeDisplayName();
            }
        }

        public void setIconsChecked(boolean checkFlag) {
            if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.isNotifyChanges()) {
                if (checkFlag) {
                    if (!this.isIconsChecked()) {
                        try {
                            WebGeneralPage.this.getWebApp().createIcon(null);
                        }
                        catch (J2eeCreateException e) {
                            WebGeneralPage.this.handleJ2eeCreateException("icon", e);
                        }
                    }
                } else {
                    WebGeneralPage.this.getWebApp().removeIcon();
                }
                WebGeneralPage.super.makeEditorDirty();
            }
        }

        private IIcon getIcon() {
            IIcon icon = WebGeneralPage.this.getWebApp().getIcon();
            if (icon == null && this.isIconsChecked()) {
                try {
                    icon = WebGeneralPage.this.getWebApp().createIcon(null);
                }
                catch (J2eeCreateException e) {
                    WebGeneralPage.this.handleJ2eeCreateException("icon", e);
                }
            }
            return icon;
        }

        public void setLargeIcon(String largeIcon) {
            if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.isNotifyChanges()) {
                IIcon icon = this.getIcon();
                if (!largeIcon.equals("")) {
                    if (icon.getLargeIcon() != null) {
                        icon.getLargeIcon().setValue(largeIcon);
                    } else {
                        try {
                            icon.createLargeIcon(null).setValue(largeIcon);
                        }
                        catch (J2eeCreateException e) {
                            WebGeneralPage.this.handleJ2eeCreateException("large-icon", e);
                        }
                    }
                } else if (icon != null && icon.getLargeIcon() != null) {
                    icon.removeLargeIcon();
                }
                WebGeneralPage.super.makeEditorDirty();
            }
        }

        public void setSmallIcon(String smallIcon) {
            if (WebGeneralPage.this.getWebApp() != null && WebGeneralPage.this.isNotifyChanges()) {
                IIcon icon = this.getIcon();
                if (!smallIcon.equals("")) {
                    if (icon.getSmallIcon() != null) {
                        icon.getSmallIcon().setValue(smallIcon);
                    } else {
                        try {
                            icon.createSmallIcon(null).setValue(smallIcon);
                        }
                        catch (J2eeCreateException e) {
                            WebGeneralPage.this.handleJ2eeCreateException("small-icon", e);
                        }
                    }
                } else if (icon != null && icon.getSmallIcon() != null) {
                    icon.removeSmallIcon();
                }
                WebGeneralPage.super.makeEditorDirty();
            }
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            if (WebGeneralPage.this.isNotifyChanges()) {
                WebGeneralPage.super.makeEditorDirty();
            }
        }
    }
}

