/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IEnvEntry;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.j2ee.ui.core.RefPrjResourceChooserCB;
import com.tssap.j2ee.ui.editor.editcomponents.WebEditorManager;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.j2ee.ui.web.editor.internal.WebOtherPageTreeCP;
import com.tssap.j2ee.ui.web.editor.internal.webobjects.IWebAppHolder;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class WebEnvironmentPage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebEnvironmentPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebEnvironmentPage = WebEnvironmentPage.class$("com.tssap.j2ee.ui.web.editor.internal.WebEnvironmentPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebEnvironmentPage));
    private static final int NUM_OF_COLS = 1;
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private EnvironmentPageTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebEnvironmentPage;

    public WebEnvironmentPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.myTreeSelector.setTreeInput((Object)webApp);
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return "Environment";
    }

    protected Control createControls(IGridLayoutPane grid) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(3);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeEditor.setReusableManager((IReuseableManager)new MyReusableManager());
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeContentProvider = new EnvironmentPageTreeCP();
        this.myAddRemoveCallback = new AddRemoveCallback();
        this.myTreeSelector.createPartControl(grid);
        return grid.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        IResourceChooserCallback resourceChooserCallback;

        MySelectionConverter() {
            this.resourceChooserCallback = new RefPrjResourceChooserCB(WebEnvironmentPage.this.getUnderlyingFile().getProject());
        }

        public Object convertSelection(Object selectedObject) {
            return new WebOtherPageDataWrapper(this.resourceChooserCallback, selectedObject);
        }
    }

    class MyReusableManager
    implements IReuseableManager {
        MyReusableManager() {
        }

        public IReuseable getReusable(Object obj) {
            return WebEditorManager.getObjectEditorComponent((Object)obj);
        }
    }

    private class EnvironmentPageTreeCP
    extends J2eeModelLabelProvider
    implements ITreeContentProvider {
        private final Image IMG_FOLDER = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_FOLDER");
        private Image iEnvEntry = UIPlugin.getImage((String)"EnvEntry");
        private final Object[] EMPTY_OBJ_AR = new Object[0];
        private final WebOtherPageTreeCP.WebAppHolder webAppHolder = new WebOtherPageTreeCP.WebAppHolder();
        private final EnvEntriesFolder envEntriesFolder = new EnvEntriesFolder(this.webAppHolder);
        private final Object[] roots = new Object[]{this.envEntriesFolder};
        private Object[] activeRoots;

        private EnvironmentPageTreeCP() {
        }

        private void setWebApp(IWebApp webApp) {
            this.webAppHolder.setWebApp(webApp);
        }

        public Object[] getChildren(Object parentElement) {
            IWebApp webApp;
            Object[] ret = this.EMPTY_OBJ_AR;
            if (parentElement instanceof EnvEntriesFolder && (webApp = ((EnvEntriesFolder)parentElement).getWebApp()) != null && parentElement instanceof EnvEntriesFolder) {
                ret = webApp.getEnvEntrys();
            }
            return ret;
        }

        public Object[] getElements(Object inputElement) {
            return this.activeRoots;
        }

        public Object getParent(Object child) {
            EnvEntriesFolder ret = null;
            if (child instanceof IEnvEntry) {
                ret = this.envEntriesFolder;
            }
            return ret;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IWebApp) {
                this.webAppHolder.setWebApp((IWebApp)newInput);
                this.activeRoots = this.roots;
            } else {
                this.activeRoots = this.EMPTY_OBJ_AR;
            }
        }

        public Image getImage(Object element) {
            Image retImage = super.getImage(element);
            if (element instanceof EnvEntriesFolder) {
                retImage = this.IMG_FOLDER;
            }
            return retImage;
        }

        public String getText(Object element) {
            String retText = super.getText(element);
            return retText;
        }

        public class EnvEntriesFolder
        implements IWebAppHolder {
            private WebOtherPageTreeCP.WebAppHolder myWebAppHolder;

            public IWebApp getWebApp() {
                return this.myWebAppHolder.getWebApp();
            }

            protected EnvEntriesFolder(WebOtherPageTreeCP.WebAppHolder webAppHolder) {
                this.myWebAppHolder = webAppHolder;
            }

            public String toString() {
                return "Environment entries";
            }
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        private static final String DEFAULT_NAME_PREFIX = "DefaultEnvEntry";

        AddRemoveCallback() {
        }

        public Object addElement(Object currentSelection) {
            IWebApp webApp;
            IEnvEntry envEntry = null;
            IEnvEntry ret = null;
            Object parent = WebEnvironmentPage.this.myTreeContentProvider.getParent(currentSelection);
            Object selection = parent != null ? parent : currentSelection;
            boolean type = false;
            if (selection instanceof EnvironmentPageTreeCP.EnvEntriesFolder && (webApp = ((EnvironmentPageTreeCP.EnvEntriesFolder)selection).getWebApp()) != null) {
                try {
                    envEntry = webApp.createEnvEntry(null);
                    String defaultEnvEntryName = this.getDefaultEnvEntryName(webApp);
                    envEntry.createEnvEntryName(null).setValue(defaultEnvEntryName);
                    envEntry.createEnvEntryType(null);
                    envEntry.createEnvEntryValue(null);
                }
                catch (J2eeCreateException e) {
                    WebEnvironmentPage.this.handleJ2eeCreateException("<env-entry> tag could not be created.", e);
                }
                ret = envEntry;
            }
            return ret;
        }

        private String getDefaultEnvEntryName(IWebApp webApp) {
            String defaultEnvEntryName = "<..>";
            String suffix = "";
            IEnvEntry[] envEntryArr = null;
            int prefix = 0;
            if (webApp != null) {
                defaultEnvEntryName = DEFAULT_NAME_PREFIX;
                envEntryArr = webApp.getEnvEntrys();
                if (envEntryArr != null) {
                    int i = 0;
                    while (i < envEntryArr.length) {
                        if (envEntryArr[i].getEnvEntryName() != null && envEntryArr[i].getEnvEntryName().getValue().equalsIgnoreCase(defaultEnvEntryName)) {
                            defaultEnvEntryName = DEFAULT_NAME_PREFIX + String.valueOf(++prefix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                }
                envEntryArr = null;
            }
            return defaultEnvEntryName;
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof EnvironmentPageTreeCP.EnvEntriesFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebEnvironmentPage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof EnvironmentPageTreeCP.EnvEntriesFolder) {
                IWebApp parentWebApp = ((EnvironmentPageTreeCP.EnvEntriesFolder)parentObj).getWebApp();
                if (currentSelection instanceof IEnvEntry) {
                    parentWebApp.removeEnvEntry((IEnvEntry)currentSelection);
                }
            }
            return true;
        }
    }
}

