/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.web.editor.internal;

import com.tssap.editors.mpe.IEditor;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.dd.IEjbLink;
import com.tssap.j2ee.model.web.dd.IEjbLocalRef;
import com.tssap.j2ee.model.web.dd.IEjbRef;
import com.tssap.j2ee.model.web.dd.IEjbRefName;
import com.tssap.j2ee.model.web.dd.IEjbRefType;
import com.tssap.j2ee.model.web.dd.IHome;
import com.tssap.j2ee.model.web.dd.ILocal;
import com.tssap.j2ee.model.web.dd.ILocalHome;
import com.tssap.j2ee.model.web.dd.IRemote;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.EjbRefDialogTreeContentProvider;
import com.tssap.j2ee.ui.EjbRefDialogTreeLabelProvider;
import com.tssap.j2ee.ui.EnterpriseBeanObj;
import com.tssap.j2ee.ui.core.RefPrjResourceChooserCB;
import com.tssap.j2ee.ui.editor.DDEditor;
import com.tssap.j2ee.ui.editor.editcomponents.EjbRefWrapper;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.web.editor.IWebEditor;
import com.tssap.j2ee.ui.web.editor.internal.BaseFolder;
import com.tssap.j2ee.ui.web.editor.internal.EjbPageTreeCP;
import com.tssap.j2ee.ui.web.editor.internal.MyReuseableManager;
import com.tssap.j2ee.ui.web.editor.internal.WebEditorPage;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.core.IFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.tree.IAddRemoveCallback;
import com.tssap.util.ui.reuse.tree.ISelectionConverter;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class WebEjbPage
extends WebEditorPage
implements IModifiedCallback {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$web$editor$internal$WebEjbPage == null ? (class$com$tssap$j2ee$ui$web$editor$internal$WebEjbPage = WebEjbPage.class$("com.tssap.j2ee.ui.web.editor.internal.WebEjbPage")) : class$com$tssap$j2ee$ui$web$editor$internal$WebEjbPage));
    private static final int NUM_OF_COLS = 1;
    private static final String PAGENAME = "EJBs";
    protected static final int EJB_REF_TYPE = 1;
    protected static final int EJB_LOCAL_REF_TYPE = 2;
    private static final String DEFAULT_NAME_PREFIX = "Default";
    private static final String DEFAULT_EJB_REF_SUFFIX = "EjbRef";
    private static final String DEFAULT_EJB_LOCAL_REF_SUFFIX = "EjbLocalRef";
    private static final String TXT_ERR_NO_EJBS = "There are no entity or session EJBs available to reference (reference in ejb-jar.xml missing).";
    private static final String TXT_ERR_NO_EJBS_TITLE = "No EJBs available to reference.";
    private static final String TXT_ERR_NO_EJBCLIENTAPIJAR_REF = "To create EJB references, project references to EJB Module Projects are required. These projects must contain EJBs.";
    private static final String TXT_ERR_NO_EJBCLIENTAPIJAR_REF_TITLE = "No Reference to EJB Module Projects";
    private TreeSelector myTreeSelector;
    private TreeSelectorEditorComponent myTreeEditor;
    private EjbPageTreeCP myTreeContentProvider;
    private IAddRemoveCallback myAddRemoveCallback;
    private String mDDEjbName = null;
    private String mDDEjbType = null;
    private String mDDHome = null;
    private String mDDRemote = null;
    private String mDDLocal = null;
    private String mDDLocalHome = null;
    private String mDDEjbLink = null;
    private String mDefaultEjbRefName = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$web$editor$internal$WebEjbPage;

    public WebEjbPage(Composite parent, IWebEditor editor) {
        super(parent, editor, 1);
    }

    protected void initControlsWithWebApp(IWebApp webApp) {
        this.myTreeSelector.setTreeInput((Object)webApp);
    }

    protected void updateWebAppFromControls(IWebApp webApp) {
        this.myTreeEditor.aboutToLeave();
    }

    public String getPageName() {
        return PAGENAME;
    }

    protected Control createControls(IGridLayoutPane gridPane) {
        this.myTreeSelector = new TreeSelector();
        if (this.myTreeSelector != null) {
            this.myTreeSelector.setSplitterWeight(2);
        }
        this.myTreeEditor = new TreeSelectorEditorComponent(this.myTreeSelector);
        this.myTreeEditor.setReusableManager((IReuseableManager)new MyReuseableManager(this));
        this.myTreeEditor.setSelectionConverter((ISelectionConverter)new MySelectionConverter());
        this.myTreeContentProvider = new EjbPageTreeCP();
        this.myAddRemoveCallback = new AddRemoveCallback(this.getEditor());
        this.myTreeSelector.createPartControl(gridPane);
        return gridPane.getComposite();
    }

    protected void decorateControls() {
        this.myTreeEditor.setTreeContentProvider((ITreeContentProvider)this.myTreeContentProvider);
        this.myTreeEditor.setTreeLabelProvider((ILabelProvider)this.myTreeContentProvider);
        this.myTreeEditor.setModifiedCallback((IModifiedCallback)this);
        this.myTreeEditor.setAddRemoveCallback(this.myAddRemoveCallback);
    }

    public void dataModified(boolean modified) {
        this.getEditor().setDirtyFlag(modified);
        TreeViewer tv = this.myTreeEditor.getTreeSelector().getTreeViewer();
        TreeItem[] selection = tv.getTree().getSelection();
        int i = 0;
        while (i < selection.length) {
            tv.refresh(selection[i].getData(), true);
            ++i;
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.myTreeEditor != null) {
            this.myTreeEditor.setEditable(this.isEditable());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerFilter
    implements IFilter {
        private IEnterpriseJavaBean[] iejbs = null;

        public InnerFilter(IEnterpriseJavaBean[] iejbs) {
            this.iejbs = iejbs;
        }

        public boolean accept(Object o) {
            return o instanceof IEnterpriseJavaBean || o instanceof EnterpriseBeanObj;
        }
    }

    class MySelectionConverter
    implements ISelectionConverter {
        IResourceChooserCallback resChooserCallback;

        MySelectionConverter() {
            this.resChooserCallback = new RefPrjResourceChooserCB(WebEjbPage.this.getUnderlyingFile().getProject());
        }

        public Object convertSelection(Object selectedObject) {
            IWebApp webApp = WebEjbPage.this.myTreeContentProvider.getWebAppHolder().getWebApp();
            if (selectedObject instanceof IEjbRef) {
                return new EjbRefWrapper(this.resChooserCallback, webApp, (IEjbRef)selectedObject);
            }
            if (selectedObject instanceof IEjbLocalRef) {
                return new EjbRefWrapper(this.resChooserCallback, webApp, (IEjbLocalRef)selectedObject);
            }
            return new WebOtherPageDataWrapper(this.resChooserCallback, selectedObject);
        }
    }

    class AddRemoveCallback
    implements IAddRemoveCallback {
        private static final String TXT_WEB_MOD_NOT_REF = "There are no web objects referenced to the web.xml deployment descriptor.";
        private static final String TXT_WEB_MOD_NOT_REF_TITLE = "Web Objects not referenced";
        private IClientSource[] clientSources;
        private IServerSource[] serverSources;
        private boolean hasWebDDReference = false;
        private StructuredObjectSelectionDialog diag = null;
        private IEditor editor;
        private EjbRefDialogTreeContentProvider ejbReferencingTreeContentProvider = null;

        public AddRemoveCallback(IEditor editor) {
            this.setEditor(editor);
        }

        public Object addElement(Object currentSelection) {
            Object ret = null;
            Object parent = WebEjbPage.this.myTreeContentProvider.getParent(currentSelection);
            Object selection = parent != null ? parent : currentSelection;
            int type = 0;
            if (selection instanceof BaseFolder) {
                if (selection instanceof EjbPageTreeCP.EjbRefFolder) {
                    type = 1;
                } else if (selection instanceof EjbPageTreeCP.EjbLocalRefFolder) {
                    type = 2;
                }
                Object[] iejbArr = this.getEjbsFromDialog(((BaseFolder)selection).getWebApp(), type);
                if (iejbArr != null && iejbArr.length > 0) {
                    Object[] retObj = new Object[iejbArr.length];
                    int i = 0;
                    while (i < iejbArr.length) {
                        retObj[i] = this.addChild(((BaseFolder)selection).getWebApp(), type, (IEnterpriseJavaBean)iejbArr[i]);
                        ++i;
                    }
                    ret = retObj[0];
                }
            }
            return ret;
        }

        private Object addChild(IWebApp webApp, int type, IEnterpriseJavaBean iejb) {
            Object ret = null;
            if (iejb != null) {
                IEjbModule ejbModule = J2eeElementManager.getEjbModule((Element)iejb.getSelenaEntity().getModel());
                this.setDDEntryValues(iejb, ejbModule, webApp, type);
                ret = this.createEjbReferencesInDD(webApp, type);
            }
            return ret;
        }

        private void setDDEntryValues(IEnterpriseJavaBean referencedEjb, IEjbModule iejbModule, IWebApp webApp, int type) {
            WebEjbPage.this.mDDEjbName = this.createUniqueEjbRefName(webApp, referencedEjb.getEjbName(), type);
            WebEjbPage.this.mDefaultEjbRefName = "ejb/".concat(WebEjbPage.this.mDDEjbName);
            int iejbType = referencedEjb.getEjbType();
            if (iejbType == 0) {
                WebEjbPage.this.mDDEjbType = "Entity";
            } else if (iejbType == 1) {
                WebEjbPage.this.mDDEjbType = "Session";
            }
            WebEjbPage.this.mDDHome = referencedEjb.getHomeInterfaceClass() != null ? referencedEjb.getHomeInterfaceClass().getFullyQualifiedName() : "";
            WebEjbPage.this.mDDRemote = referencedEjb.getRemoteInterfaceClass() != null ? referencedEjb.getRemoteInterfaceClass().getFullyQualifiedName() : "";
            WebEjbPage.this.mDDLocal = referencedEjb.getLocalInterfaceClass() != null ? referencedEjb.getLocalInterfaceClass().getFullyQualifiedName() : "";
            WebEjbPage.this.mDDLocalHome = referencedEjb.getLocalHomeInterfaceClass() != null ? referencedEjb.getLocalHomeInterfaceClass().getFullyQualifiedName() : "";
            WebEjbPage.this.mDDEjbLink = null;
            if (iejbModule != null && iejbModule.getArchiveLocationFullPath() != null) {
                StringBuffer ejbLinkStrgBf = new StringBuffer();
                if (WebEjbPage.this.mDDEjbName != null && !WebEjbPage.this.mDDEjbName.equals("")) {
                    ejbLinkStrgBf.append(iejbModule.getArchiveLocationFullPath().getName()).append("#").append(WebEjbPage.this.mDDEjbName);
                    WebEjbPage.this.mDDEjbLink = ejbLinkStrgBf.toString();
                } else {
                    WebEjbPage.this.mDDEjbLink = WebEjbPage.this.mDDEjbName;
                }
            } else {
                WebEjbPage.this.mDDEjbLink = WebEjbPage.this.mDDEjbName;
            }
        }

        private Object createEjbReferencesInDD(IWebApp webApp, int type) {
            IEjbRef ret = null;
            try {
                switch (type) {
                    case 1: {
                        IEjbRef ejbRef = webApp.createEjbRef(null);
                        if (WebEjbPage.this.mDDEjbName != null) {
                            IEjbRefName iejbRefName = ejbRef.createEjbRefName(null);
                            iejbRefName.setValue(WebEjbPage.this.mDefaultEjbRefName);
                        }
                        if (WebEjbPage.this.mDDEjbType != null) {
                            IEjbRefType iejbRefType = ejbRef.createEjbRefType(null);
                            iejbRefType.setValue(WebEjbPage.this.mDDEjbType);
                        }
                        if (WebEjbPage.this.mDDHome != null) {
                            IHome ihome = ejbRef.createHome(null);
                            ihome.setValue(WebEjbPage.this.mDDHome);
                        }
                        if (WebEjbPage.this.mDDRemote != null) {
                            IRemote iremote = ejbRef.createRemote(null);
                            iremote.setValue(WebEjbPage.this.mDDRemote);
                        }
                        if (WebEjbPage.this.mDDEjbLink != null && !WebEjbPage.this.mDDEjbLink.equals("")) {
                            IEjbLink iejbLink = ejbRef.createEjbLink(null);
                            iejbLink.setValue(WebEjbPage.this.mDDEjbLink);
                        }
                        ret = ejbRef;
                        break;
                    }
                    case 2: {
                        IEjbLocalRef ejbLocalRef = webApp.createEjbLocalRef(null);
                        if (WebEjbPage.this.mDDEjbName != null) {
                            IEjbRefName iejbRefName = ejbLocalRef.createEjbRefName(null);
                            iejbRefName.setValue(WebEjbPage.this.mDefaultEjbRefName);
                        }
                        if (WebEjbPage.this.mDDEjbType != null) {
                            IEjbRefType iejbRefType = ejbLocalRef.createEjbRefType(null);
                            iejbRefType.setValue(WebEjbPage.this.mDDEjbType);
                        }
                        if (WebEjbPage.this.mDDLocal != null) {
                            ILocal ilocal = ejbLocalRef.createLocal(null);
                            ilocal.setValue(WebEjbPage.this.mDDLocal);
                        }
                        if (WebEjbPage.this.mDDLocalHome != null) {
                            ILocalHome ilocalHome = ejbLocalRef.createLocalHome(null);
                            ilocalHome.setValue(WebEjbPage.this.mDDLocalHome);
                        }
                        if (WebEjbPage.this.mDDEjbLink != null && !WebEjbPage.this.mDDEjbLink.equals("")) {
                            IEjbLink iejbLink = ejbLocalRef.createEjbLink(null);
                            iejbLink.setValue(WebEjbPage.this.mDDEjbLink);
                        }
                        ret = ejbLocalRef;
                        break;
                    }
                    default: {
                        tracer.error(this.getClass(), "createEjbReferencesInDD(IWebApp webApp, int type)", " Error: Illegal Argument provided (type). ");
                        break;
                    }
                }
            }
            catch (J2eeCreateException e) {
                WebEjbPage.this.handleJ2eeCreateException("<ejb-ref> or <ejb-local-ref> could not be created.", e);
            }
            return ret;
        }

        private Object[] getEjbsFromDialog(IWebApp webApp, int type) {
            Object[] ret = null;
            IProject project = ((DDEditor)this.editor).getProject();
            this.checkForExistingWebobjects(project);
            if (webApp != null) {
                this.ejbReferencingTreeContentProvider = new EjbRefDialogTreeContentProvider(webApp, type, this.getClientSources(), this.getServerSources());
            }
            EjbRefDialogTreeLabelProvider ejbRefDialogTreeLabelProvider = new EjbRefDialogTreeLabelProvider();
            Shell shell = new Shell();
            this.diag = null;
            IEnterpriseJavaBean[] iejbs = new IEnterpriseJavaBean[]{};
            InnerFilter elementsToReturnFilter = new InnerFilter(iejbs);
            Object[] elements = this.ejbReferencingTreeContentProvider.getElements(null);
            if (!this.isHasWebDDReference()) {
                MessageDialog.openWarning((Shell)shell, (String)TXT_WEB_MOD_NOT_REF_TITLE, (String)TXT_WEB_MOD_NOT_REF);
            } else if (elements == null) {
                MessageDialog.openWarning((Shell)shell, (String)WebEjbPage.TXT_ERR_NO_EJBS_TITLE, (String)WebEjbPage.TXT_ERR_NO_EJBS);
            } else if (elements.length > 0) {
                this.diag = new StructuredObjectSelectionDialog(shell, "Choose EJBs", "Choose EJBs from the list below.");
                this.diag.setTreeInput((Object)ResourcesPlugin.getWorkspace());
                this.diag.setLabelProvider((ILabelProvider)ejbRefDialogTreeLabelProvider);
                this.setDiag(this.diag);
                Object[] result = this.diag.openDialog((ITreeContentProvider)this.ejbReferencingTreeContentProvider, (IFilter)elementsToReturnFilter, 2);
                if (result != null) {
                    ret = result;
                    shell.dispose();
                }
            } else if (J2eeProjectManager.getEjbModules() != null) {
                MessageDialog.openWarning((Shell)shell, (String)WebEjbPage.TXT_ERR_NO_EJBCLIENTAPIJAR_REF_TITLE, (String)WebEjbPage.TXT_ERR_NO_EJBCLIENTAPIJAR_REF);
            } else {
                MessageDialog.openWarning((Shell)shell, (String)WebEjbPage.TXT_ERR_NO_EJBS_TITLE, (String)WebEjbPage.TXT_ERR_NO_EJBS);
            }
            return ret;
        }

        private void checkForExistingWebobjects(IProject project) {
            if (project != null) {
                String projectName = project.getName();
                IWebModule webAssProject = J2eeProjectManager.getWebModule((String)projectName);
                IClientSource[] clientSources = webAssProject.getReferencedClientSources();
                this.setClientSources(clientSources);
                IServerSource[] serverSources = webAssProject.getReferencedServerSources();
                this.setServerSources(serverSources);
                if (clientSources != null && clientSources.length > 0 || serverSources != null && serverSources.length > 0) {
                    this.setHasWebDDReference(true);
                } else {
                    this.setHasWebDDReference(false);
                }
            }
        }

        public boolean canAddElement(Object currentSelection) {
            return currentSelection != null;
        }

        public boolean canRemoveElement(Object currentSelection) {
            boolean ret = true;
            if (currentSelection == null | currentSelection instanceof BaseFolder) {
                ret = false;
            }
            return ret;
        }

        public boolean removeElement(Object currentSelection) {
            Object parentObj = WebEjbPage.this.myTreeContentProvider.getParent(currentSelection);
            if (parentObj != null && parentObj instanceof BaseFolder) {
                IWebApp parentWebApp = ((BaseFolder)parentObj).getWebApp();
                if (currentSelection instanceof IEjbRef) {
                    parentWebApp.removeEjbRef((IEjbRef)currentSelection);
                } else if (currentSelection instanceof IEjbLocalRef) {
                    parentWebApp.removeEjbLocalRef((IEjbLocalRef)currentSelection);
                }
            }
            return true;
        }

        private String createUniqueEjbRefName(IWebApp webApp, String origEjbName, int type) {
            String ejbRefName = null;
            String ejbName = origEjbName;
            int prefix = 0;
            switch (type) {
                case 1: {
                    if (webApp == null) break;
                    IEjbRef[] ejbRefArr = webApp.getEjbRefs();
                    int i = 0;
                    while (i < ejbRefArr.length) {
                        if (ejbRefArr[i].getEjbRefName() == null) continue;
                        ejbRefName = ejbRefArr[i].getEjbRefName().getValue();
                        if (ejbRefName.startsWith("ejb/")) {
                            ejbRefName = ejbRefName.substring(4, ejbRefName.length());
                        }
                        if (ejbRefName.equalsIgnoreCase(ejbName)) {
                            ejbName = origEjbName + String.valueOf(++prefix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    if (webApp == null) break;
                    IEjbLocalRef[] ejbLocalRefArr = webApp.getEjbLocalRefs();
                    int i = 0;
                    while (i < ejbLocalRefArr.length) {
                        if (ejbLocalRefArr[i].getEjbRefName() == null) continue;
                        ejbRefName = ejbLocalRefArr[i].getEjbRefName().getValue();
                        if (ejbRefName.startsWith("ejb/")) {
                            ejbRefName = ejbRefName.substring(4, ejbRefName.length());
                        }
                        if (ejbRefName.equalsIgnoreCase(ejbName)) {
                            ejbName = origEjbName + String.valueOf(++prefix);
                            i = 0;
                            continue;
                        }
                        ++i;
                    }
                    break;
                }
                default: {
                    tracer.error(this.getClass(), "createUniqueEjbRefName(IWebApp webApp, String origEjbName, int type)", " Error: Illegal Argument provided (type). ");
                }
            }
            return ejbName;
        }

        private IClientSource[] getClientSources() {
            return this.clientSources;
        }

        private boolean isHasWebDDReference() {
            return this.hasWebDDReference;
        }

        private IServerSource[] getServerSources() {
            return this.serverSources;
        }

        private void setClientSources(IClientSource[] sources) {
            this.clientSources = sources;
        }

        private void setDiag(StructuredObjectSelectionDialog soDiag) {
            this.diag = soDiag;
        }

        private void setHasWebDDReference(boolean b) {
            this.hasWebDDReference = b;
        }

        private void setServerSources(IServerSource[] sources) {
            this.serverSources = sources;
        }

        private void setEditor(IEditor editor) {
            this.editor = editor;
        }
    }
}

