/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.BinaryOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Instruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class RightShiftOperator
extends BinaryOperator {
    public RightShiftOperator(int resultId, int leftTypeId, int rightTypeId, int start) {
        this(resultId, leftTypeId, rightTypeId, false, start);
    }

    protected RightShiftOperator(int resultId, int leftTypeId, int rightTypeId, boolean isAssignmentOperator, int start) {
        super(resultId, leftTypeId, rightTypeId, isAssignmentOperator, start);
    }

    protected boolean getBooleanResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return false;
    }

    protected double getDoubleResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return 0.0;
    }

    protected float getFloatResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return 0.0f;
    }

    protected int getIntResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        switch (this.fRightTypeId) {
            case 7: {
                return ((IJavaPrimitiveValue)leftOperand).getIntValue() >> (int)((IJavaPrimitiveValue)rightOperand).getLongValue();
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                return ((IJavaPrimitiveValue)leftOperand).getIntValue() >> ((IJavaPrimitiveValue)rightOperand).getIntValue();
            }
        }
        return 0;
    }

    protected long getLongResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        switch (this.fRightTypeId) {
            case 7: {
                return ((IJavaPrimitiveValue)leftOperand).getLongValue() >> (int)((IJavaPrimitiveValue)rightOperand).getLongValue();
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                return ((IJavaPrimitiveValue)leftOperand).getLongValue() >> ((IJavaPrimitiveValue)rightOperand).getIntValue();
            }
        }
        return 0L;
    }

    protected String getStringResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return null;
    }

    protected int getInternResultType() {
        return Instruction.getUnaryPromotionType(this.fLeftTypeId);
    }

    public String toString() {
        return InstructionsEvaluationMessages.getString("RightShiftOperator._>>___operator_1");
    }
}

