/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayPartition;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ArrayInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class ArrayAccess
extends ArrayInstruction {
    public ArrayAccess(int start) {
        super(start);
    }

    public void execute() throws CoreException {
        IJavaArray array;
        int index = ((IJavaPrimitiveValue)this.popValue()).getIntValue();
        if (index >= (array = (IJavaArray)this.popValue()).getLength() || index < 0) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("ArrayAccess.illegal_index"), new Integer(index)), null));
        }
        IVariable[] variables = array.getVariables();
        int firstIndex = 0;
        while (variables[0] instanceof JDIArrayPartition) {
            JDIArrayPartition partition = (JDIArrayPartition)variables[0];
            int offset = partition.getEnd() - firstIndex + 1;
            int partitionIndex = (index - firstIndex) / offset;
            variables = ((JDIArrayPartition)variables[partitionIndex]).getValue().getVariables();
            firstIndex += offset * partitionIndex;
        }
        this.push(variables[index - firstIndex]);
    }

    public String toString() {
        return InstructionsEvaluationMessages.getString("ArrayAccess.array_access_1");
    }
}

