/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationEngineMessages;

public class SourceBasedSourceGenerator
extends ASTVisitor {
    private static final String RUN_METHOD_NAME = "___run";
    private static final String EVAL_METHOD_NAME = "___eval";
    private static final String EVAL_FIELD_NAME = "___field";
    private String[] fLocalVariableTypeNames;
    private String[] fLocalVariableNames;
    private String fCodeSnippet;
    private boolean fRightTypeFound = false;
    private boolean fIsInAStaticMethod;
    private boolean fCreateInAnInstanceMethod;
    private boolean fEvaluateNextEndTypeDeclaration;
    private String fError;
    private CompilationUnit fUnit;
    private int fPosition;
    private boolean fIsLineNumber;
    private StringBuffer fSource;
    private String fLastTypeName;
    private String fCompilationUnitName;
    private int fSnippetStartPosition;
    private int fRunMethodStartOffset;
    private int fRunMethodLength;

    public SourceBasedSourceGenerator(CompilationUnit unit, int position, boolean isLineNumber, boolean createInAnInstanceMethod, String[] localTypesNames, String[] localVariables, String codeSnippet) {
        this.fUnit = unit;
        this.fPosition = position;
        this.fLocalVariableTypeNames = localTypesNames;
        this.fLocalVariableNames = localVariables;
        this.fCodeSnippet = codeSnippet;
        this.fIsInAStaticMethod = false;
        this.fIsLineNumber = isLineNumber;
        this.fCreateInAnInstanceMethod = createInAnInstanceMethod;
    }

    public String getSource() {
        if (this.fSource == null) {
            return null;
        }
        return this.fSource.toString();
    }

    private CompilationUnit getCompilationUnit() {
        return this.fUnit;
    }

    public String getCompilationUnitName() {
        return this.fCompilationUnitName;
    }

    public int getSnippetStart() {
        return this.fSnippetStartPosition;
    }

    public int getRunMethodStart() {
        return this.fSnippetStartPosition - this.fRunMethodStartOffset;
    }

    public int getRunMethodLength() {
        return this.fRunMethodLength;
    }

    private int getPosition() {
        return this.fPosition;
    }

    private int getCorrespondingLineNumber(int charOffset) {
        return this.getCompilationUnit().lineNumber(charOffset);
    }

    private boolean rightTypeFound() {
        return this.fRightTypeFound;
    }

    private void setRightTypeFound(boolean value) {
        this.fRightTypeFound = value;
    }

    public boolean hasError() {
        return this.fError != null;
    }

    public void setError(String errorDesc) {
        this.fError = errorDesc;
    }

    public String getError() {
        return this.fError;
    }

    private boolean isInAStaticMethod() {
        return this.fIsInAStaticMethod && !this.fCreateInAnInstanceMethod;
    }

    private void setIsInAStaticMethod(boolean value) {
        this.fIsInAStaticMethod = value;
    }

    private StringBuffer buildRunMethod(List bodyDeclarations) {
        StringBuffer buffer = new StringBuffer();
        if (this.isInAStaticMethod()) {
            buffer.append("static ");
        }
        buffer.append("void ");
        buffer.append(this.getUniqueMethodName(RUN_METHOD_NAME, bodyDeclarations));
        buffer.append('(');
        int i = 0;
        int length = this.fLocalVariableNames.length;
        while (i < length) {
            buffer.append(this.getDotName(this.fLocalVariableTypeNames[i]));
            buffer.append(' ');
            buffer.append(this.fLocalVariableNames[i]);
            if (i + 1 < length) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(") throws Throwable {");
        buffer.append('\n');
        this.fRunMethodStartOffset = this.fSnippetStartPosition = buffer.length() - 2;
        String codeSnippet = new String(this.fCodeSnippet).trim();
        buffer.append(codeSnippet);
        buffer.append('\n');
        buffer.append('}').append('\n');
        this.fRunMethodLength = buffer.length();
        return buffer;
    }

    private String getDotName(String typeName) {
        return typeName.replace('$', '.');
    }

    private boolean containsLine(ASTNode node) {
        int position = this.getPosition();
        if (this.fIsLineNumber) {
            int startLineNumber = this.getCorrespondingLineNumber(node.getStartPosition());
            int endLineNumber = this.getCorrespondingLineNumber(node.getStartPosition() + node.getLength() - 1);
            return startLineNumber <= position && position <= endLineNumber;
        }
        int startPosition = node.getStartPosition();
        return startPosition <= position && position <= startPosition + node.getLength();
    }

    private StringBuffer buildTypeBody(StringBuffer buffer, List list) {
        StringBuffer source = new StringBuffer();
        source.append('{').append('\n');
        if (buffer != null) {
            this.fSnippetStartPosition += source.length();
            source.append(buffer.toString());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TypeDeclaration typeDeclaration;
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            if (bodyDeclaration instanceof FieldDeclaration) {
                source.append((Object)this.buildFieldDeclaration((FieldDeclaration)bodyDeclaration));
                continue;
            }
            if (bodyDeclaration instanceof MethodDeclaration) {
                source.append((Object)this.buildMethodDeclaration((MethodDeclaration)bodyDeclaration));
                continue;
            }
            if (!(bodyDeclaration instanceof TypeDeclaration) || (typeDeclaration = (TypeDeclaration)bodyDeclaration).getName().getIdentifier().equals(this.fLastTypeName)) continue;
            source.append((Object)this.buildTypeDeclaration(null, (TypeDeclaration)bodyDeclaration));
        }
        source.append('}').append('\n');
        return source;
    }

    private StringBuffer buildFieldDeclaration(FieldDeclaration fieldDeclaration) {
        StringBuffer source = new StringBuffer();
        source.append(Flags.toString((int)fieldDeclaration.getModifiers()));
        source.append(' ');
        source.append(this.getDotName(this.getTypeName(fieldDeclaration.getType())));
        source.append(' ');
        boolean first = true;
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            if (first) {
                first = false;
            } else {
                source.append(',');
            }
            source.append(variableDeclarationFragment.getName().getIdentifier());
            int i = 0;
            int dim = variableDeclarationFragment.getExtraDimensions();
            while (i < dim) {
                source.append('[').append(']');
                ++i;
            }
        }
        source.append(';').append('\n');
        return source;
    }

    private StringBuffer buildMethodDeclaration(MethodDeclaration methodDeclaration) {
        StringBuffer source = new StringBuffer();
        int modifiers = methodDeclaration.getModifiers();
        source.append(Flags.toString((int)modifiers));
        source.append(' ');
        boolean isConstructor = methodDeclaration.isConstructor();
        if (!isConstructor) {
            source.append(this.getDotName(this.getTypeName(methodDeclaration.getReturnType())));
            source.append(' ');
        }
        source.append(methodDeclaration.getName().getIdentifier());
        source.append(' ').append('(');
        boolean first = true;
        Iterator iterator = methodDeclaration.parameters().iterator();
        while (iterator.hasNext()) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
            if (first) {
                first = false;
            } else {
                source.append(',');
            }
            source.append(this.getDotName(this.getTypeName(singleVariableDeclaration.getType())));
            source.append(' ');
            source.append(singleVariableDeclaration.getName().getIdentifier());
            this.appendExtraDimensions(source, singleVariableDeclaration.getExtraDimensions());
        }
        source.append(')');
        this.appendExtraDimensions(source, methodDeclaration.getExtraDimensions());
        first = true;
        iterator = methodDeclaration.thrownExceptions().iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            if (first) {
                first = false;
                source.append(" throws ");
            } else {
                source.append(',');
            }
            source.append(this.getQualifiedIdentifier(name));
        }
        if (Flags.isAbstract((int)modifiers) || Flags.isNative((int)modifiers)) {
            source.append(";\n");
        } else {
            source.append('{').append('\n');
            source.append(this.getReturnExpression(methodDeclaration.getReturnType()));
            source.append('}').append('\n');
        }
        return source;
    }

    private void appendExtraDimensions(StringBuffer source, int extraDimension) {
        if (extraDimension > 0) {
            source.append(' ');
            int i = 0;
            while (i < extraDimension) {
                source.append("[]");
                ++i;
            }
        }
    }

    private StringBuffer buildTypeDeclaration(StringBuffer buffer, TypeDeclaration typeDeclaration) {
        StringBuffer source = new StringBuffer();
        source.append(Flags.toString((int)typeDeclaration.getModifiers()));
        if (typeDeclaration.isInterface()) {
            source.append(" interface ");
        } else {
            source.append(" class ");
        }
        source.append(typeDeclaration.getName().getIdentifier());
        Name superClass = typeDeclaration.getSuperclass();
        if (superClass != null) {
            source.append(" extends ");
            source.append(this.getQualifiedIdentifier(superClass));
        }
        boolean first = true;
        Iterator iterator = typeDeclaration.superInterfaces().iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            if (first) {
                first = false;
                source.append(" implements ");
            } else {
                source.append(',');
            }
            source.append(this.getQualifiedIdentifier(name));
        }
        if (buffer != null) {
            this.fSnippetStartPosition += source.length();
        }
        source.append((Object)this.buildTypeBody(buffer, typeDeclaration.bodyDeclarations()));
        return source;
    }

    private StringBuffer buildCompilationUnit(StringBuffer buffer, CompilationUnit compilationUnit) {
        StringBuffer source = new StringBuffer();
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        if (packageDeclaration != null) {
            source.append("package ");
            source.append(this.getQualifiedIdentifier(packageDeclaration.getName()));
            source.append(";\n");
        }
        Iterator iterator = compilationUnit.imports().iterator();
        while (iterator.hasNext()) {
            ImportDeclaration importDeclaration = (ImportDeclaration)iterator.next();
            source.append("import ");
            source.append(this.getQualifiedIdentifier(importDeclaration.getName()));
            if (importDeclaration.isOnDemand()) {
                source.append(".*");
            }
            source.append(";\n");
        }
        this.fSnippetStartPosition += source.length();
        source.append((Object)buffer);
        iterator = compilationUnit.types().iterator();
        while (iterator.hasNext()) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)iterator.next();
            if (Flags.isPublic((int)typeDeclaration.getModifiers())) {
                this.fCompilationUnitName = typeDeclaration.getName().getIdentifier();
            }
            if (this.fLastTypeName.equals(typeDeclaration.getName().getIdentifier())) continue;
            source.append((Object)this.buildTypeDeclaration(null, typeDeclaration));
        }
        if (this.fCompilationUnitName == null) {
            this.fCompilationUnitName = "Eval";
        }
        return source;
    }

    private String getUniqueMethodName(String methodName, List bodyDeclarations) {
        Iterator iter = bodyDeclarations.iterator();
        while (iter.hasNext()) {
            MethodDeclaration method;
            String foundName;
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iter.next();
            if (!(bodyDeclaration instanceof MethodDeclaration) || !(foundName = (method = (MethodDeclaration)bodyDeclaration).getName().getIdentifier()).startsWith(methodName)) continue;
            methodName = String.valueOf(foundName) + '_';
        }
        return methodName;
    }

    private String getUniqueFieldName(String fieldName, List bodyDeclarations) {
        Iterator iter = bodyDeclarations.iterator();
        while (iter.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iter.next();
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            Iterator iterator = fieldDeclaration.fragments().iterator();
            while (iterator.hasNext()) {
                String foundName = ((VariableDeclarationFragment)iterator.next()).getName().getIdentifier();
                if (!foundName.startsWith(fieldName)) continue;
                fieldName = String.valueOf(foundName) + '_';
            }
        }
        return fieldName;
    }

    private String getQualifiedIdentifier(Name name) {
        String typeName = "";
        while (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            typeName = "." + qualifiedName.getName().getIdentifier() + typeName;
            name = qualifiedName.getQualifier();
        }
        if (!name.isSimpleName()) {
            return null;
        }
        typeName = String.valueOf(((SimpleName)name).getIdentifier()) + typeName;
        return typeName;
    }

    public String getTypeName(Type type) {
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            return this.getQualifiedIdentifier(simpleType.getName());
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            String res = this.getTypeName(arrayType.getElementType());
            int i = 0;
            int dim = arrayType.getDimensions();
            while (i < dim) {
                res = String.valueOf(res) + "[]";
                ++i;
            }
            return res;
        }
        if (type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return primitiveType.getPrimitiveTypeCode().toString();
        }
        return null;
    }

    public String getReturnExpression(Type type) {
        if (type.isSimpleType() || type.isArrayType()) {
            return "return null;";
        }
        if (type.isPrimitiveType()) {
            String typeName = ((PrimitiveType)type).getPrimitiveTypeCode().toString();
            char char0 = typeName.charAt(0);
            if (char0 == 'v') {
                return "";
            }
            char char1 = typeName.charAt(1);
            if (char0 == 'b' && char1 == 'o') {
                return "return false;";
            }
            return "return 0;";
        }
        return null;
    }

    public void endVisit(ClassInstanceCreation node) {
        if (this.hasError()) {
            return;
        }
        AnonymousClassDeclaration anonymousClassDeclaration = node.getAnonymousClassDeclaration();
        if (anonymousClassDeclaration != null) {
            if (!this.rightTypeFound() && this.containsLine((ASTNode)node)) {
                this.setRightTypeFound(true);
                this.fSource = this.buildRunMethod(anonymousClassDeclaration.bodyDeclarations());
                this.fEvaluateNextEndTypeDeclaration = true;
            }
            if (this.rightTypeFound()) {
                if (!node.arguments().isEmpty()) {
                    this.setError(EvaluationEngineMessages.getString("SourceBasedSourceGenerator.Cannot_evaluate_an_expression_in_the_context_of_anonymous_type_with_no_default_constructor._1"));
                    return;
                }
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                StringBuffer source = this.buildTypeBody(this.fSource, bodyDeclarations);
                ASTNode parent = node.getParent();
                while (!(parent instanceof MethodDeclaration) && !(parent instanceof FieldDeclaration)) {
                    parent = parent.getParent();
                }
                this.fSource = new StringBuffer();
                if (parent instanceof MethodDeclaration) {
                    MethodDeclaration enclosingMethodDeclaration = (MethodDeclaration)parent;
                    if (Flags.isStatic((int)enclosingMethodDeclaration.getModifiers())) {
                        this.fSource.append("static ");
                    }
                    this.fSource.append("void ");
                    this.fSource.append(this.getUniqueMethodName(EVAL_METHOD_NAME, bodyDeclarations));
                    this.fSource.append("() {\n");
                    this.fSource.append("new ");
                    this.fSource.append(this.getQualifiedIdentifier(node.getName()));
                    this.fSource.append("()");
                    this.fSnippetStartPosition += this.fSource.length();
                    this.fSource.append((Object)source);
                    this.fSource.append(";}\n");
                } else if (parent instanceof FieldDeclaration) {
                    FieldDeclaration enclosingFieldDeclaration = (FieldDeclaration)parent;
                    if (Flags.isStatic((int)enclosingFieldDeclaration.getModifiers())) {
                        this.fSource.append("static ");
                    }
                    Type type = enclosingFieldDeclaration.getType();
                    while (type instanceof ArrayType) {
                        type = ((ArrayType)type).getComponentType();
                    }
                    this.fSource.append(this.getQualifiedIdentifier(((SimpleType)type).getName()));
                    this.fSource.append(' ');
                    this.fSource.append(this.getUniqueFieldName(EVAL_FIELD_NAME, bodyDeclarations));
                    this.fSource.append(" = new ");
                    this.fSource.append(this.getQualifiedIdentifier(node.getName()));
                    this.fSource.append("()");
                    this.fSnippetStartPosition += this.fSource.length();
                    this.fSource.append((Object)source);
                    this.fSource.append(";\n");
                }
                this.fLastTypeName = "";
            }
        }
    }

    public void endVisit(CompilationUnit node) {
        if (this.hasError()) {
            return;
        }
        if (!this.rightTypeFound()) {
            this.fSource = null;
            return;
        }
        this.fSource = this.buildCompilationUnit(this.fSource, node);
    }

    public void endVisit(Initializer node) {
        if (this.hasError()) {
            return;
        }
        if (!this.rightTypeFound() && this.containsLine((ASTNode)node)) {
            this.setIsInAStaticMethod(Flags.isStatic((int)node.getModifiers()));
        }
    }

    public void endVisit(MethodDeclaration node) {
        if (this.hasError()) {
            return;
        }
        if (!this.rightTypeFound() && this.containsLine((ASTNode)node)) {
            this.setIsInAStaticMethod(Flags.isStatic((int)node.getModifiers()));
        }
    }

    public void endVisit(TypeDeclaration node) {
        if (this.hasError()) {
            return;
        }
        if (!this.rightTypeFound() && this.containsLine((ASTNode)node)) {
            this.setRightTypeFound(true);
            this.fSource = this.buildRunMethod(node.bodyDeclarations());
            this.fEvaluateNextEndTypeDeclaration = true;
        }
        if (!this.fEvaluateNextEndTypeDeclaration) {
            this.fEvaluateNextEndTypeDeclaration = true;
            return;
        }
        if (this.rightTypeFound()) {
            StringBuffer source = this.buildTypeDeclaration(this.fSource, node);
            if (node.isLocalTypeDeclaration()) {
                ASTNode parent = node.getParent();
                while (!(parent instanceof MethodDeclaration)) {
                    parent = parent.getParent();
                }
                MethodDeclaration enclosingMethodDeclaration = (MethodDeclaration)parent;
                this.fSource = new StringBuffer();
                if (Flags.isStatic((int)enclosingMethodDeclaration.getModifiers())) {
                    this.fSource.append("static ");
                }
                this.fSource.append("void ___eval() {\n");
                this.fSnippetStartPosition += this.fSource.length();
                this.fSource.append((Object)source);
                this.fSource.append("}\n");
                this.fLastTypeName = "";
            } else {
                this.fSource = source;
                this.fLastTypeName = node.getName().getIdentifier();
            }
        }
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ArrayAccess node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ArrayCreation node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ArrayInitializer node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ArrayType node) {
        return !this.rightTypeFound();
    }

    public boolean visit(AssertStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(Assignment node) {
        return !this.rightTypeFound();
    }

    public boolean visit(Block node) {
        return !this.rightTypeFound();
    }

    public boolean visit(BooleanLiteral node) {
        return !this.rightTypeFound();
    }

    public boolean visit(BreakStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(CastExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(CatchClause node) {
        return !this.rightTypeFound();
    }

    public boolean visit(CharacterLiteral node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ClassInstanceCreation node) {
        return !this.rightTypeFound();
    }

    public boolean visit(CompilationUnit node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ConditionalExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ConstructorInvocation node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ContinueStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(DoStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(EmptyStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ExpressionStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(FieldAccess node) {
        return !this.rightTypeFound();
    }

    public boolean visit(FieldDeclaration node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ForStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(IfStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ImportDeclaration node) {
        return !this.rightTypeFound();
    }

    public boolean visit(InfixExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(Initializer node) {
        return !this.rightTypeFound();
    }

    public boolean visit(Javadoc node) {
        return !this.rightTypeFound();
    }

    public boolean visit(LabeledStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(MethodDeclaration node) {
        return !this.rightTypeFound();
    }

    public boolean visit(MethodInvocation node) {
        return !this.rightTypeFound();
    }

    public boolean visit(NullLiteral node) {
        return !this.rightTypeFound();
    }

    public boolean visit(NumberLiteral node) {
        return !this.rightTypeFound();
    }

    public boolean visit(PackageDeclaration node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ParenthesizedExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(PostfixExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(PrefixExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(PrimitiveType node) {
        return !this.rightTypeFound();
    }

    public boolean visit(QualifiedName node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ReturnStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SimpleName node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SimpleType node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SingleVariableDeclaration node) {
        return !this.rightTypeFound();
    }

    public boolean visit(StringLiteral node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SuperConstructorInvocation node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SuperFieldAccess node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SuperMethodInvocation node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SwitchCase node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SwitchStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(SynchronizedStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ThisExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(ThrowStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(TryStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(TypeDeclaration node) {
        if (this.rightTypeFound()) {
            this.fEvaluateNextEndTypeDeclaration = false;
            return false;
        }
        return true;
    }

    public boolean visit(TypeDeclarationStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(TypeLiteral node) {
        return !this.rightTypeFound();
    }

    public boolean visit(VariableDeclarationExpression node) {
        return !this.rightTypeFound();
    }

    public boolean visit(VariableDeclarationFragment node) {
        return !this.rightTypeFound();
    }

    public boolean visit(VariableDeclarationStatement node) {
        return !this.rightTypeFound();
    }

    public boolean visit(WhileStatement node) {
        return !this.rightTypeFound();
    }
}

