/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.sun.jdi.Accessible;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.internal.debug.core.model.JDIClassType;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;

public class BinaryBasedSourceGenerator {
    private static final String RUN_METHOD_NAME = "___run";
    private static final String EVAL_METHOD_NAME = "___eval";
    private static final String ANONYMOUS_CLASS_NAME = "___EvalClass";
    private String[] fLocalVariableTypeNames;
    private String[] fLocalVariableNames;
    private boolean fIsInStaticMethod;
    private StringBuffer fSource;
    private int fRunMethodStartOffset;
    private int fRunMethodLength;
    private int fCodeSnippetPosition;
    private String fCompilationUnitName;

    public BinaryBasedSourceGenerator(String[] localTypesNames, String[] localVariables, boolean isInStaticMethod) throws DebugException {
        this.fLocalVariableTypeNames = localTypesNames;
        this.fLocalVariableNames = localVariables;
        this.fIsInStaticMethod = isInStaticMethod;
    }

    public void buildSource(JDIObjectValue object) {
        ObjectReference reference = object.getUnderlyingObject();
        this.fSource = this.buildTypeDeclaration(reference, this.buildRunMethod(reference.referenceType()), null);
    }

    public void buildSource(JDIClassType type) {
        Type underlyingType = type.getUnderlyingType();
        if (!(underlyingType instanceof ReferenceType)) {
            return;
        }
        ReferenceType refType = (ReferenceType)underlyingType;
        this.fSource = this.buildTypeDeclaration(refType, this.buildRunMethod(refType), null, false);
        String packageName = this.getPackageName(refType.name());
        if (packageName != null) {
            this.fSource.insert(0, "package " + packageName + ";\n");
            this.fCodeSnippetPosition += 10 + packageName.length();
        }
        this.fCompilationUnitName = this.getSimpleName(refType.name());
    }

    protected String getUniqueMethodName(String methodName, ReferenceType type) {
        List<Method> methods = type.methodsByName(methodName);
        while (!methods.isEmpty()) {
            methodName = String.valueOf(methodName) + '_';
            methods = type.methodsByName(methodName);
        }
        return methodName;
    }

    private StringBuffer buildRunMethod(ReferenceType type) {
        StringBuffer source = new StringBuffer();
        if (this.isInStaticMethod()) {
            source.append("static ");
        }
        source.append("void ");
        source.append(this.getUniqueMethodName(RUN_METHOD_NAME, type));
        source.append('(');
        int i = 0;
        int length = this.fLocalVariableNames.length;
        while (i < length) {
            source.append(this.getDotName(this.fLocalVariableTypeNames[i]));
            source.append(' ');
            source.append(this.fLocalVariableNames[i]);
            if (i + 1 < length) {
                source.append(", ");
            }
            ++i;
        }
        source.append(") throws Throwable {");
        source.append('\n');
        this.fRunMethodStartOffset = this.fCodeSnippetPosition = source.length();
        source.append('\n');
        source.append('}').append('\n');
        this.fRunMethodLength = source.length();
        return source;
    }

    private StringBuffer buildTypeDeclaration(ObjectReference object, StringBuffer buffer, String nestedTypeName) {
        ReferenceType referenceType = object.referenceType();
        Field thisField = null;
        List<Field> fields = referenceType.visibleFields();
        Iterator<Field> iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            if (!field.name().startsWith("this$")) continue;
            thisField = field;
            break;
        }
        StringBuffer source = this.buildTypeDeclaration(referenceType, buffer, nestedTypeName, thisField != null);
        if (thisField == null) {
            String packageName = this.getPackageName(referenceType.name());
            if (packageName != null) {
                source.insert(0, "package " + packageName + ";\n");
                this.fCodeSnippetPosition += 10 + packageName.length();
            }
            this.fCompilationUnitName = this.isAnonymousTypeName(referenceType.name()) ? ANONYMOUS_CLASS_NAME : this.getSimpleName(referenceType.name());
        } else {
            ObjectReference thisObject = (ObjectReference)object.getValue(thisField);
            return this.buildTypeDeclaration(thisObject, source, referenceType.name());
        }
        return source;
    }

    private StringBuffer buildTypeDeclaration(ReferenceType referenceType, StringBuffer buffer, String nestedTypeName, boolean hasEnclosingInstance) {
        ReferenceType nestedType;
        Iterator<Accessible> iterator;
        Iterator<ReferenceType> iterator2;
        ClassType classType;
        StringBuffer source = new StringBuffer();
        String typeName = referenceType.name();
        boolean isAnonymousType = this.isAnonymousTypeName(typeName);
        if (isAnonymousType) {
            classType = (ClassType)referenceType;
            List<InterfaceType> interfaceList = classType.interfaces();
            String superClassName = classType.superclass().name();
            if (hasEnclosingInstance) {
                source.append("void ");
                source.append(this.getUniqueMethodName(EVAL_METHOD_NAME, referenceType));
                source.append("() {\nnew ");
                if (interfaceList.size() != 0) {
                    source.append(this.getDotName(interfaceList.get(0).name()));
                } else {
                    source.append(this.getDotName(superClassName));
                }
                source.append("()");
            } else {
                source.append("public class ").append(ANONYMOUS_CLASS_NAME).append(" ");
                if (interfaceList.size() != 0) {
                    source.append(" implements ").append(this.getDotName(interfaceList.get(0).name()));
                } else {
                    source.append(" implements ").append(this.getDotName(superClassName));
                }
            }
        } else {
            if (referenceType.isFinal()) {
                source.append("final ");
            }
            if (referenceType.isStatic()) {
                source.append("static ");
            }
            if (referenceType instanceof ClassType) {
                List<InterfaceType> interfaces;
                classType = (ClassType)referenceType;
                if (classType.isAbstract()) {
                    source.append("abstract ");
                }
                source.append("class ");
                source.append(this.getSimpleName(typeName)).append(' ');
                ClassType superClass = classType.superclass();
                if (superClass != null) {
                    source.append("extends ").append(this.getDotName(superClass.name())).append(' ');
                }
                try {
                    interfaces = classType.interfaces();
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    return new StringBuffer();
                }
                if (interfaces.size() != 0) {
                    source.append("implements ");
                    iterator2 = interfaces.iterator();
                    InterfaceType interface_ = (InterfaceType)iterator2.next();
                    source.append(this.getDotName(interface_.name()));
                    while (iterator2.hasNext()) {
                        source.append(',').append(this.getDotName(((InterfaceType)iterator2.next()).name()));
                    }
                }
            } else if (referenceType instanceof InterfaceType) {
                List<InterfaceType> interfaces;
                InterfaceType interfaceType = (InterfaceType)referenceType;
                source.append("interface ");
                source.append(this.getSimpleName(typeName)).append(' ');
                try {
                    interfaces = interfaceType.superinterfaces();
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    return new StringBuffer();
                }
                if (interfaces.size() != 0) {
                    source.append("extends ");
                    iterator = interfaces.iterator();
                    InterfaceType interface_ = (InterfaceType)iterator.next();
                    source.append(this.getDotName(interface_.name()));
                    while (iterator.hasNext()) {
                        source.append(',').append(this.getDotName(((InterfaceType)iterator.next()).name()));
                    }
                }
            }
        }
        source.append(" {\n");
        if (buffer != null) {
            this.fCodeSnippetPosition += source.length();
            source.append((Object)buffer);
        }
        List<Field> fields = referenceType.fields();
        Iterator<Field> iterator3 = fields.iterator();
        while (iterator3.hasNext()) {
            Field field = iterator3.next();
            if (field.name().startsWith("this$")) continue;
            source.append((Object)this.buildFieldDeclaration(field));
        }
        List<Method> methods = referenceType.methods();
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (method.isConstructor() || method.isStaticInitializer()) continue;
            source.append((Object)this.buildMethodDeclaration(method));
        }
        List<ReferenceType> nestedTypes = referenceType.nestedTypes();
        if (nestedTypeName == null) {
            iterator2 = nestedTypes.iterator();
            while (iterator2.hasNext()) {
                nestedType = iterator2.next();
                if (!this.isADirectInnerType(typeName, nestedType.name())) continue;
                source.append((Object)this.buildTypeDeclaration(nestedType, null, null, true));
            }
        } else {
            iterator2 = nestedTypes.iterator();
            while (iterator2.hasNext()) {
                nestedType = iterator2.next();
                if (nestedTypeName.equals(nestedType.name()) || !this.isADirectInnerType(typeName, nestedType.name())) continue;
                source.append((Object)this.buildTypeDeclaration(nestedType, null, null, true));
            }
        }
        if (isAnonymousType & hasEnclosingInstance) {
            source.append("};\n");
        }
        source.append("}\n");
        return source;
    }

    private StringBuffer buildFieldDeclaration(Field field) {
        StringBuffer source = new StringBuffer();
        if (field.isFinal()) {
            source.append("final ");
        }
        if (field.isStatic()) {
            source.append("static ");
        }
        if (field.isPublic()) {
            source.append("public ");
        } else if (field.isPrivate()) {
            source.append("private ");
        } else if (field.isProtected()) {
            source.append("protected ");
        }
        source.append(this.getDotName(field.typeName())).append(' ').append(field.name()).append(';').append('\n');
        return source;
    }

    private StringBuffer buildMethodDeclaration(Method method) {
        StringBuffer source = new StringBuffer();
        if (method.isFinal()) {
            source.append("final ");
        }
        if (method.isStatic()) {
            source.append("static ");
        }
        if (method.isNative()) {
            source.append("native ");
        } else if (method.isAbstract()) {
            source.append("abstract ");
        }
        if (method.isPublic()) {
            source.append("public ");
        } else if (method.isPrivate()) {
            source.append("private ");
        } else if (method.isProtected()) {
            source.append("protected ");
        }
        source.append(this.getDotName(method.returnTypeName())).append(' ').append(method.name()).append('(');
        List<String> arguments = method.argumentTypeNames();
        int i = 0;
        if (arguments.size() != 0) {
            Iterator<String> iterator = arguments.iterator();
            source.append(this.getDotName(iterator.next())).append(" arg").append(i++);
            while (iterator.hasNext()) {
                source.append(',').append(this.getDotName(iterator.next())).append(" arg").append(i++);
            }
        }
        source.append(')');
        if (method.isAbstract() || method.isNative()) {
            source.append(";\n");
        } else {
            source.append('{').append('\n');
            source.append(this.getReturnStatement(method.returnTypeName()));
            source.append('}').append('\n');
        }
        return source;
    }

    private String getReturnStatement(String returnTypeName) {
        String typeName = this.getSimpleName(returnTypeName);
        if (typeName.charAt(typeName.length() - 1) == ']') {
            return "return null;\n";
        }
        switch (typeName.charAt(0)) {
            case 'v': {
                return "";
            }
            case 'b': {
                if (typeName.charAt(1) == 'o') {
                    return "return false;\n";
                }
            }
            case 'c': 
            case 'd': 
            case 'f': 
            case 'i': 
            case 'l': 
            case 's': {
                return "return 0;\n";
            }
        }
        return "return null;\n";
    }

    private String getDotName(String typeName) {
        return typeName.replace('$', '.');
    }

    private boolean isAnonymousTypeName(String typeName) {
        char char0 = this.getSimpleName(typeName).charAt(0);
        return '0' <= char0 && char0 <= '9';
    }

    private String getSimpleName(String qualifiedName) {
        int pos = qualifiedName.lastIndexOf(36);
        if (pos == -1) {
            pos = qualifiedName.lastIndexOf(46);
        }
        return pos == -1 ? qualifiedName : qualifiedName.substring(pos + 1);
    }

    private String getPackageName(String qualifiedName) {
        int pos = qualifiedName.lastIndexOf(46);
        return pos == -1 ? null : qualifiedName.substring(0, pos);
    }

    private boolean isADirectInnerType(String typeName, String nestedTypeName) {
        String end = nestedTypeName.substring(typeName.length() + 1);
        return end.indexOf(36) == -1;
    }

    private boolean isInStaticMethod() {
        return this.fIsInStaticMethod;
    }

    public StringBuffer getSource() {
        return this.fSource;
    }

    public int getCodeSnippetPosition() {
        return this.fCodeSnippetPosition;
    }

    public String getCompilationUnitName() {
        return this.fCompilationUnitName;
    }

    public int getSnippetStart() {
        return this.fCodeSnippetPosition - 2;
    }

    public int getRunMethodStart() {
        return this.fCodeSnippetPosition - this.fRunMethodStartOffset;
    }

    public int getRunMethodLength() {
        return this.fRunMethodLength;
    }
}

